unit WebSocket;

interface

type

HCkBinData = Pointer;
HCkRest = Pointer;
HCkString = Pointer;
HCkStringBuilder = Pointer;
HCkWebSocket = Pointer;
HCkTask = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TWebSocketAbortCheck = function(): Integer; cdecl;
TWebSocketProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TWebSocketPercentDone = function(pctDone: Integer): Integer; cdecl;
TWebSocketTaskCompleted = procedure(task: HCkTask); cdecl;


function CkWebSocket_Create: HCkWebSocket;  stdcall;
procedure CkWebSocket_Dispose(handle: HCkWebSocket); stdcall;

procedure CkWebSocket_SetAbortCheck(objHandle: HCkWebSocket; fn: TWebSocketAbortCheck) stdcall;
procedure CkWebSocket_SetProgressInfo(objHandle: HCkWebSocket; fn: TWebSocketProgressInfo) stdcall;
procedure CkWebSocket_SetPercentDone(objHandle: HCkWebSocket; fn: TWebSocketPercentDone) stdcall;
procedure CkWebSocket_SetTaskCompleted(objHandle: HCkWebSocket; fn: TWebSocketTaskCompleted) stdcall;
function CkWebSocket_getCloseAutoRespond(objHandle: HCkWebSocket): wordbool;
procedure CkWebSocket_putCloseAutoRespond(objHandle: HCkWebSocket; newPropVal: wordbool);
procedure CkWebSocket_getCloseReason(objHandle: HCkWebSocket; outPropVal: HCkString);
function CkWebSocket__closeReason(objHandle: HCkWebSocket): PWideChar;
function CkWebSocket_getCloseReceived(objHandle: HCkWebSocket): wordbool;
function CkWebSocket_getCloseStatusCode(objHandle: HCkWebSocket): Integer;
procedure CkWebSocket_getDebugLogFilePath(objHandle: HCkWebSocket; outPropVal: HCkString);
procedure CkWebSocket_putDebugLogFilePath(objHandle: HCkWebSocket; newPropVal: PWideChar);
function CkWebSocket__debugLogFilePath(objHandle: HCkWebSocket): PWideChar;
function CkWebSocket_getFinalFrame(objHandle: HCkWebSocket): wordbool;
function CkWebSocket_getFrameDataLen(objHandle: HCkWebSocket): Integer;
procedure CkWebSocket_getFrameOpcode(objHandle: HCkWebSocket; outPropVal: HCkString);
function CkWebSocket__frameOpcode(objHandle: HCkWebSocket): PWideChar;
function CkWebSocket_getFrameOpcodeInt(objHandle: HCkWebSocket): Integer;
function CkWebSocket_getHeartbeatMs(objHandle: HCkWebSocket): Integer;
procedure CkWebSocket_putHeartbeatMs(objHandle: HCkWebSocket; newPropVal: Integer);
function CkWebSocket_getIdleTimeoutMs(objHandle: HCkWebSocket): Integer;
procedure CkWebSocket_putIdleTimeoutMs(objHandle: HCkWebSocket; newPropVal: Integer);
function CkWebSocket_getIsConnected(objHandle: HCkWebSocket): wordbool;
procedure CkWebSocket_getLastErrorHtml(objHandle: HCkWebSocket; outPropVal: HCkString);
function CkWebSocket__lastErrorHtml(objHandle: HCkWebSocket): PWideChar;
procedure CkWebSocket_getLastErrorText(objHandle: HCkWebSocket; outPropVal: HCkString);
function CkWebSocket__lastErrorText(objHandle: HCkWebSocket): PWideChar;
procedure CkWebSocket_getLastErrorXml(objHandle: HCkWebSocket; outPropVal: HCkString);
function CkWebSocket__lastErrorXml(objHandle: HCkWebSocket): PWideChar;
function CkWebSocket_getLastMethodSuccess(objHandle: HCkWebSocket): wordbool;
procedure CkWebSocket_putLastMethodSuccess(objHandle: HCkWebSocket; newPropVal: wordbool);
function CkWebSocket_getNeedSendPong(objHandle: HCkWebSocket): wordbool;
function CkWebSocket_getPingAutoRespond(objHandle: HCkWebSocket): wordbool;
procedure CkWebSocket_putPingAutoRespond(objHandle: HCkWebSocket; newPropVal: wordbool);
function CkWebSocket_getPongAutoConsume(objHandle: HCkWebSocket): wordbool;
procedure CkWebSocket_putPongAutoConsume(objHandle: HCkWebSocket; newPropVal: wordbool);
function CkWebSocket_getPongConsumed(objHandle: HCkWebSocket): wordbool;
function CkWebSocket_getReadFrameFailReason(objHandle: HCkWebSocket): Integer;
procedure CkWebSocket_getUncommonOptions(objHandle: HCkWebSocket; outPropVal: HCkString);
function CkWebSocket__uncommonOptions(objHandle: HCkWebSocket): PWideChar;
function CkWebSocket_getVerboseLogging(objHandle: HCkWebSocket): wordbool;
procedure CkWebSocket_putVerboseLogging(objHandle: HCkWebSocket; newPropVal: wordbool);
procedure CkWebSocket_getVersion(objHandle: HCkWebSocket; outPropVal: HCkString);
function CkWebSocket__version(objHandle: HCkWebSocket): PWideChar;
function CkWebSocket_AddClientHeaders(objHandle: HCkWebSocket): wordbool;
function CkWebSocket_CloseConnection(objHandle: HCkWebSocket): wordbool;
function CkWebSocket_GetFrameData(objHandle: HCkWebSocket; outStr: HCkString): wordbool;
function CkWebSocket__getFrameData(objHandle: HCkWebSocket): PWideChar;
function CkWebSocket_GetFrameDataBd(objHandle: HCkWebSocket; binData: HCkBinData): wordbool;
function CkWebSocket_GetFrameDataSb(objHandle: HCkWebSocket; sb: HCkStringBuilder): wordbool;
function CkWebSocket_LoadTaskCaller(objHandle: HCkWebSocket; task: HCkTask): wordbool;
function CkWebSocket_PollDataAvailable(objHandle: HCkWebSocket): wordbool;
function CkWebSocket_ReadFrame(objHandle: HCkWebSocket): wordbool;
function CkWebSocket_ReadFrameAsync(objHandle: HCkWebSocket): HCkTask;
function CkWebSocket_SendClose(objHandle: HCkWebSocket; includeStatus: wordbool; statusCode: Integer; reason: PWideChar): wordbool;
function CkWebSocket_SendCloseAsync(objHandle: HCkWebSocket; includeStatus: wordbool; statusCode: Integer; reason: PWideChar): HCkTask;
function CkWebSocket_SendFrame(objHandle: HCkWebSocket; stringToSend: PWideChar; finalFrame: wordbool): wordbool;
function CkWebSocket_SendFrameAsync(objHandle: HCkWebSocket; stringToSend: PWideChar; finalFrame: wordbool): HCkTask;
function CkWebSocket_SendFrameBd(objHandle: HCkWebSocket; bdToSend: HCkBinData; finalFrame: wordbool): wordbool;
function CkWebSocket_SendFrameBdAsync(objHandle: HCkWebSocket; bdToSend: HCkBinData; finalFrame: wordbool): HCkTask;
function CkWebSocket_SendFrameSb(objHandle: HCkWebSocket; sbToSend: HCkStringBuilder; finalFrame: wordbool): wordbool;
function CkWebSocket_SendFrameSbAsync(objHandle: HCkWebSocket; sbToSend: HCkStringBuilder; finalFrame: wordbool): HCkTask;
function CkWebSocket_SendPing(objHandle: HCkWebSocket; pingData: PWideChar): wordbool;
function CkWebSocket_SendPingAsync(objHandle: HCkWebSocket; pingData: PWideChar): HCkTask;
function CkWebSocket_SendPong(objHandle: HCkWebSocket): wordbool;
function CkWebSocket_SendPongAsync(objHandle: HCkWebSocket): HCkTask;
function CkWebSocket_ShareConnection(objHandle: HCkWebSocket; ws: HCkWebSocket): wordbool;
function CkWebSocket_UseConnection(objHandle: HCkWebSocket; connection: HCkRest): wordbool;
function CkWebSocket_ValidateServerHandshake(objHandle: HCkWebSocket): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkWebSocket_Create = function : HCkWebSocket; stdcall;
  TCkWebSocket_Dispose = procedure (handle: HCkWebSocket); stdcall;
  TCkWebSocket_SetAbortCheck = procedure (objHandle: HCkWebSocket; fn: TWebSocketAbortCheck); stdcall;
  TCkWebSocket_SetProgressInfo = procedure (objHandle: HCkWebSocket; fn: TWebSocketProgressInfo); stdcall;
  TCkWebSocket_SetPercentDone = procedure (objHandle: HCkWebSocket; fn: TWebSocketPercentDone); stdcall;
  TCkWebSocket_SetTaskCompleted = procedure (objHandle: HCkWebSocket; fn: TWebSocketTaskCompleted); stdcall;
  TCkWebSocket_getCloseAutoRespond = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_putCloseAutoRespond = procedure (objHandle: HCkWebSocket; newPropVal: wordbool); stdcall;
  TCkWebSocket_getCloseReason = procedure (objHandle: HCkWebSocket; outPropVal: HCkString); stdcall;
  TCkWebSocket__closeReason = function (objHandle: HCkWebSocket): PWideChar; stdcall;
  TCkWebSocket_getCloseReceived = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_getCloseStatusCode = function (objHandle: HCkWebSocket): Integer; stdcall;
  TCkWebSocket_getDebugLogFilePath = procedure (objHandle: HCkWebSocket; outPropVal: HCkString); stdcall;
  TCkWebSocket_putDebugLogFilePath = procedure (objHandle: HCkWebSocket; newPropVal: PWideChar); stdcall;
  TCkWebSocket__debugLogFilePath = function (objHandle: HCkWebSocket): PWideChar; stdcall;
  TCkWebSocket_getFinalFrame = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_getFrameDataLen = function (objHandle: HCkWebSocket): Integer; stdcall;
  TCkWebSocket_getFrameOpcode = procedure (objHandle: HCkWebSocket; outPropVal: HCkString); stdcall;
  TCkWebSocket__frameOpcode = function (objHandle: HCkWebSocket): PWideChar; stdcall;
  TCkWebSocket_getFrameOpcodeInt = function (objHandle: HCkWebSocket): Integer; stdcall;
  TCkWebSocket_getHeartbeatMs = function (objHandle: HCkWebSocket): Integer; stdcall;
  TCkWebSocket_putHeartbeatMs = procedure (objHandle: HCkWebSocket; newPropVal: Integer); stdcall;
  TCkWebSocket_getIdleTimeoutMs = function (objHandle: HCkWebSocket): Integer; stdcall;
  TCkWebSocket_putIdleTimeoutMs = procedure (objHandle: HCkWebSocket; newPropVal: Integer); stdcall;
  TCkWebSocket_getIsConnected = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_getLastErrorHtml = procedure (objHandle: HCkWebSocket; outPropVal: HCkString); stdcall;
  TCkWebSocket__lastErrorHtml = function (objHandle: HCkWebSocket): PWideChar; stdcall;
  TCkWebSocket_getLastErrorText = procedure (objHandle: HCkWebSocket; outPropVal: HCkString); stdcall;
  TCkWebSocket__lastErrorText = function (objHandle: HCkWebSocket): PWideChar; stdcall;
  TCkWebSocket_getLastErrorXml = procedure (objHandle: HCkWebSocket; outPropVal: HCkString); stdcall;
  TCkWebSocket__lastErrorXml = function (objHandle: HCkWebSocket): PWideChar; stdcall;
  TCkWebSocket_getLastMethodSuccess = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_putLastMethodSuccess = procedure (objHandle: HCkWebSocket; newPropVal: wordbool); stdcall;
  TCkWebSocket_getNeedSendPong = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_getPingAutoRespond = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_putPingAutoRespond = procedure (objHandle: HCkWebSocket; newPropVal: wordbool); stdcall;
  TCkWebSocket_getPongAutoConsume = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_putPongAutoConsume = procedure (objHandle: HCkWebSocket; newPropVal: wordbool); stdcall;
  TCkWebSocket_getPongConsumed = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_getReadFrameFailReason = function (objHandle: HCkWebSocket): Integer; stdcall;
  TCkWebSocket_getUncommonOptions = procedure (objHandle: HCkWebSocket; outPropVal: HCkString); stdcall;
  TCkWebSocket__uncommonOptions = function (objHandle: HCkWebSocket): PWideChar; stdcall;
  TCkWebSocket_getVerboseLogging = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_putVerboseLogging = procedure (objHandle: HCkWebSocket; newPropVal: wordbool); stdcall;
  TCkWebSocket_getVersion = procedure (objHandle: HCkWebSocket; outPropVal: HCkString); stdcall;
  TCkWebSocket__version = function (objHandle: HCkWebSocket): PWideChar; stdcall;
  TCkWebSocket_AddClientHeaders = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_CloseConnection = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_GetFrameData = function (objHandle: HCkWebSocket; outStr: HCkString): wordbool; stdcall;
  TCkWebSocket__getFrameData = function (objHandle: HCkWebSocket): PWideChar; stdcall;
  TCkWebSocket_GetFrameDataBd = function (objHandle: HCkWebSocket; binData: HCkBinData): wordbool; stdcall;
  TCkWebSocket_GetFrameDataSb = function (objHandle: HCkWebSocket; sb: HCkStringBuilder): wordbool; stdcall;
  TCkWebSocket_LoadTaskCaller = function (objHandle: HCkWebSocket; task: HCkTask): wordbool; stdcall;
  TCkWebSocket_PollDataAvailable = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_ReadFrame = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_ReadFrameAsync = function (objHandle: HCkWebSocket): HCkTask; stdcall;
  TCkWebSocket_SendClose = function (objHandle: HCkWebSocket; includeStatus: wordbool; statusCode: Integer; reason: PWideChar): wordbool; stdcall;
  TCkWebSocket_SendCloseAsync = function (objHandle: HCkWebSocket; includeStatus: wordbool; statusCode: Integer; reason: PWideChar): HCkTask; stdcall;
  TCkWebSocket_SendFrame = function (objHandle: HCkWebSocket; stringToSend: PWideChar; finalFrame: wordbool): wordbool; stdcall;
  TCkWebSocket_SendFrameAsync = function (objHandle: HCkWebSocket; stringToSend: PWideChar; finalFrame: wordbool): HCkTask; stdcall;
  TCkWebSocket_SendFrameBd = function (objHandle: HCkWebSocket; bdToSend: HCkBinData; finalFrame: wordbool): wordbool; stdcall;
  TCkWebSocket_SendFrameBdAsync = function (objHandle: HCkWebSocket; bdToSend: HCkBinData; finalFrame: wordbool): HCkTask; stdcall;
  TCkWebSocket_SendFrameSb = function (objHandle: HCkWebSocket; sbToSend: HCkStringBuilder; finalFrame: wordbool): wordbool; stdcall;
  TCkWebSocket_SendFrameSbAsync = function (objHandle: HCkWebSocket; sbToSend: HCkStringBuilder; finalFrame: wordbool): HCkTask; stdcall;
  TCkWebSocket_SendPing = function (objHandle: HCkWebSocket; pingData: PWideChar): wordbool; stdcall;
  TCkWebSocket_SendPingAsync = function (objHandle: HCkWebSocket; pingData: PWideChar): HCkTask; stdcall;
  TCkWebSocket_SendPong = function (objHandle: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_SendPongAsync = function (objHandle: HCkWebSocket): HCkTask; stdcall;
  TCkWebSocket_ShareConnection = function (objHandle: HCkWebSocket; ws: HCkWebSocket): wordbool; stdcall;
  TCkWebSocket_UseConnection = function (objHandle: HCkWebSocket; connection: HCkRest): wordbool; stdcall;
  TCkWebSocket_ValidateServerHandshake = function (objHandle: HCkWebSocket): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..70] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkWebSocket_Create : HCkWebSocket;
begin
  result := TCkWebSocket_Create(_map(0, 'CkWebSocket_Create'));
end;

procedure CkWebSocket_Dispose (handle: HCkWebSocket);
begin
  TCkWebSocket_Dispose(_map(1, 'CkWebSocket_Dispose'))
    (handle);
end;


procedure CkWebSocket_SetAbortCheck (objHandle: HCkWebSocket; fn: TWebSocketAbortCheck);
begin
    TCkWebSocket_SetAbortCheck(_map(2, 'CkWebSocket_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkWebSocket_SetProgressInfo (objHandle: HCkWebSocket; fn: TWebSocketProgressInfo);
begin
    TCkWebSocket_SetProgressInfo(_map(3, 'CkWebSocket_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkWebSocket_SetPercentDone (objHandle: HCkWebSocket; fn: TWebSocketPercentDone);
begin
    TCkWebSocket_SetPercentDone(_map(4, 'CkWebSocket_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkWebSocket_SetTaskCompleted (objHandle: HCkWebSocket; fn: TWebSocketTaskCompleted);
begin
    TCkWebSocket_SetTaskCompleted(_map(5, 'CkWebSocket_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkWebSocket_getCloseAutoRespond (objHandle: HCkWebSocket): wordbool;
begin
    result := TCkWebSocket_getCloseAutoRespond(_map(6, 'CkWebSocket_getCloseAutoRespond'))
    (objHandle);
end;

procedure CkWebSocket_putCloseAutoRespond (objHandle: HCkWebSocket; newPropVal: wordbool);
begin
  TCkWebSocket_putCloseAutoRespond(_map(7, 'CkWebSocket_putCloseAutoRespond'))
    (objHandle, newPropVal);
end;

procedure CkWebSocket_getCloseReason (objHandle: HCkWebSocket; outPropVal: HCkString);
begin
  TCkWebSocket_getCloseReason(_map(8, 'CkWebSocket_getCloseReason'))
    (objHandle, outPropVal);
end;

function CkWebSocket__closeReason (objHandle: HCkWebSocket): PWideChar;
begin
  result := TCkWebSocket__closeReason(_map(9, 'CkWebSocket__closeReason'))
    (objHandle);
end;

function CkWebSocket_getCloseReceived (objHandle: HCkWebSocket): wordbool;
begin
    result := TCkWebSocket_getCloseReceived(_map(10, 'CkWebSocket_getCloseReceived'))
    (objHandle);
end;

function CkWebSocket_getCloseStatusCode (objHandle: HCkWebSocket): Integer;
begin
    result := TCkWebSocket_getCloseStatusCode(_map(11, 'CkWebSocket_getCloseStatusCode'))
    (objHandle);
end;

procedure CkWebSocket_getDebugLogFilePath (objHandle: HCkWebSocket; outPropVal: HCkString);
begin
  TCkWebSocket_getDebugLogFilePath(_map(12, 'CkWebSocket_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkWebSocket_putDebugLogFilePath (objHandle: HCkWebSocket; newPropVal: PWideChar);
begin
  TCkWebSocket_putDebugLogFilePath(_map(13, 'CkWebSocket_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkWebSocket__debugLogFilePath (objHandle: HCkWebSocket): PWideChar;
begin
  result := TCkWebSocket__debugLogFilePath(_map(14, 'CkWebSocket__debugLogFilePath'))
    (objHandle);
end;

function CkWebSocket_getFinalFrame (objHandle: HCkWebSocket): wordbool;
begin
    result := TCkWebSocket_getFinalFrame(_map(15, 'CkWebSocket_getFinalFrame'))
    (objHandle);
end;

function CkWebSocket_getFrameDataLen (objHandle: HCkWebSocket): Integer;
begin
    result := TCkWebSocket_getFrameDataLen(_map(16, 'CkWebSocket_getFrameDataLen'))
    (objHandle);
end;

procedure CkWebSocket_getFrameOpcode (objHandle: HCkWebSocket; outPropVal: HCkString);
begin
  TCkWebSocket_getFrameOpcode(_map(17, 'CkWebSocket_getFrameOpcode'))
    (objHandle, outPropVal);
end;

function CkWebSocket__frameOpcode (objHandle: HCkWebSocket): PWideChar;
begin
  result := TCkWebSocket__frameOpcode(_map(18, 'CkWebSocket__frameOpcode'))
    (objHandle);
end;

function CkWebSocket_getFrameOpcodeInt (objHandle: HCkWebSocket): Integer;
begin
    result := TCkWebSocket_getFrameOpcodeInt(_map(19, 'CkWebSocket_getFrameOpcodeInt'))
    (objHandle);
end;

function CkWebSocket_getHeartbeatMs (objHandle: HCkWebSocket): Integer;
begin
    result := TCkWebSocket_getHeartbeatMs(_map(20, 'CkWebSocket_getHeartbeatMs'))
    (objHandle);
end;

procedure CkWebSocket_putHeartbeatMs (objHandle: HCkWebSocket; newPropVal: Integer);
begin
  TCkWebSocket_putHeartbeatMs(_map(21, 'CkWebSocket_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

function CkWebSocket_getIdleTimeoutMs (objHandle: HCkWebSocket): Integer;
begin
    result := TCkWebSocket_getIdleTimeoutMs(_map(22, 'CkWebSocket_getIdleTimeoutMs'))
    (objHandle);
end;

procedure CkWebSocket_putIdleTimeoutMs (objHandle: HCkWebSocket; newPropVal: Integer);
begin
  TCkWebSocket_putIdleTimeoutMs(_map(23, 'CkWebSocket_putIdleTimeoutMs'))
    (objHandle, newPropVal);
end;

function CkWebSocket_getIsConnected (objHandle: HCkWebSocket): wordbool;
begin
    result := TCkWebSocket_getIsConnected(_map(24, 'CkWebSocket_getIsConnected'))
    (objHandle);
end;

procedure CkWebSocket_getLastErrorHtml (objHandle: HCkWebSocket; outPropVal: HCkString);
begin
  TCkWebSocket_getLastErrorHtml(_map(25, 'CkWebSocket_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkWebSocket__lastErrorHtml (objHandle: HCkWebSocket): PWideChar;
begin
  result := TCkWebSocket__lastErrorHtml(_map(26, 'CkWebSocket__lastErrorHtml'))
    (objHandle);
end;

procedure CkWebSocket_getLastErrorText (objHandle: HCkWebSocket; outPropVal: HCkString);
begin
  TCkWebSocket_getLastErrorText(_map(27, 'CkWebSocket_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkWebSocket__lastErrorText (objHandle: HCkWebSocket): PWideChar;
begin
  result := TCkWebSocket__lastErrorText(_map(28, 'CkWebSocket__lastErrorText'))
    (objHandle);
end;

procedure CkWebSocket_getLastErrorXml (objHandle: HCkWebSocket; outPropVal: HCkString);
begin
  TCkWebSocket_getLastErrorXml(_map(29, 'CkWebSocket_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkWebSocket__lastErrorXml (objHandle: HCkWebSocket): PWideChar;
begin
  result := TCkWebSocket__lastErrorXml(_map(30, 'CkWebSocket__lastErrorXml'))
    (objHandle);
end;

function CkWebSocket_getLastMethodSuccess (objHandle: HCkWebSocket): wordbool;
begin
    result := TCkWebSocket_getLastMethodSuccess(_map(31, 'CkWebSocket_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkWebSocket_putLastMethodSuccess (objHandle: HCkWebSocket; newPropVal: wordbool);
begin
  TCkWebSocket_putLastMethodSuccess(_map(32, 'CkWebSocket_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkWebSocket_getNeedSendPong (objHandle: HCkWebSocket): wordbool;
begin
    result := TCkWebSocket_getNeedSendPong(_map(33, 'CkWebSocket_getNeedSendPong'))
    (objHandle);
end;

function CkWebSocket_getPingAutoRespond (objHandle: HCkWebSocket): wordbool;
begin
    result := TCkWebSocket_getPingAutoRespond(_map(34, 'CkWebSocket_getPingAutoRespond'))
    (objHandle);
end;

procedure CkWebSocket_putPingAutoRespond (objHandle: HCkWebSocket; newPropVal: wordbool);
begin
  TCkWebSocket_putPingAutoRespond(_map(35, 'CkWebSocket_putPingAutoRespond'))
    (objHandle, newPropVal);
end;

function CkWebSocket_getPongAutoConsume (objHandle: HCkWebSocket): wordbool;
begin
    result := TCkWebSocket_getPongAutoConsume(_map(36, 'CkWebSocket_getPongAutoConsume'))
    (objHandle);
end;

procedure CkWebSocket_putPongAutoConsume (objHandle: HCkWebSocket; newPropVal: wordbool);
begin
  TCkWebSocket_putPongAutoConsume(_map(37, 'CkWebSocket_putPongAutoConsume'))
    (objHandle, newPropVal);
end;

function CkWebSocket_getPongConsumed (objHandle: HCkWebSocket): wordbool;
begin
    result := TCkWebSocket_getPongConsumed(_map(38, 'CkWebSocket_getPongConsumed'))
    (objHandle);
end;

function CkWebSocket_getReadFrameFailReason (objHandle: HCkWebSocket): Integer;
begin
    result := TCkWebSocket_getReadFrameFailReason(_map(39, 'CkWebSocket_getReadFrameFailReason'))
    (objHandle);
end;

procedure CkWebSocket_getUncommonOptions (objHandle: HCkWebSocket; outPropVal: HCkString);
begin
  TCkWebSocket_getUncommonOptions(_map(40, 'CkWebSocket_getUncommonOptions'))
    (objHandle, outPropVal);
end;

function CkWebSocket__uncommonOptions (objHandle: HCkWebSocket): PWideChar;
begin
  result := TCkWebSocket__uncommonOptions(_map(41, 'CkWebSocket__uncommonOptions'))
    (objHandle);
end;

function CkWebSocket_getVerboseLogging (objHandle: HCkWebSocket): wordbool;
begin
    result := TCkWebSocket_getVerboseLogging(_map(42, 'CkWebSocket_getVerboseLogging'))
    (objHandle);
end;

procedure CkWebSocket_putVerboseLogging (objHandle: HCkWebSocket; newPropVal: wordbool);
begin
  TCkWebSocket_putVerboseLogging(_map(43, 'CkWebSocket_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkWebSocket_getVersion (objHandle: HCkWebSocket; outPropVal: HCkString);
begin
  TCkWebSocket_getVersion(_map(44, 'CkWebSocket_getVersion'))
    (objHandle, outPropVal);
end;

function CkWebSocket__version (objHandle: HCkWebSocket): PWideChar;
begin
  result := TCkWebSocket__version(_map(45, 'CkWebSocket__version'))
    (objHandle);
end;

function CkWebSocket_AddClientHeaders (objHandle: HCkWebSocket): wordbool;
begin
  result := TCkWebSocket_AddClientHeaders(_map(46, 'CkWebSocket_AddClientHeaders'))
    (objHandle);
end;

function CkWebSocket_CloseConnection (objHandle: HCkWebSocket): wordbool;
begin
  result := TCkWebSocket_CloseConnection(_map(47, 'CkWebSocket_CloseConnection'))
    (objHandle);
end;

function CkWebSocket_GetFrameData (objHandle: HCkWebSocket; outStr: HCkString): wordbool;
begin
  result := TCkWebSocket_GetFrameData(_map(48, 'CkWebSocket_GetFrameData'))
    (objHandle, outStr);
end;

function CkWebSocket__getFrameData (objHandle: HCkWebSocket): PWideChar;
begin
  result := TCkWebSocket__getFrameData(_map(49, 'CkWebSocket__getFrameData'))
    (objHandle);
end;

function CkWebSocket_GetFrameDataBd (objHandle: HCkWebSocket; binData: HCkBinData): wordbool;
begin
  result := TCkWebSocket_GetFrameDataBd(_map(50, 'CkWebSocket_GetFrameDataBd'))
    (objHandle, binData);
end;

function CkWebSocket_GetFrameDataSb (objHandle: HCkWebSocket; sb: HCkStringBuilder): wordbool;
begin
  result := TCkWebSocket_GetFrameDataSb(_map(51, 'CkWebSocket_GetFrameDataSb'))
    (objHandle, sb);
end;

function CkWebSocket_LoadTaskCaller (objHandle: HCkWebSocket; task: HCkTask): wordbool;
begin
  result := TCkWebSocket_LoadTaskCaller(_map(52, 'CkWebSocket_LoadTaskCaller'))
    (objHandle, task);
end;

function CkWebSocket_PollDataAvailable (objHandle: HCkWebSocket): wordbool;
begin
  result := TCkWebSocket_PollDataAvailable(_map(53, 'CkWebSocket_PollDataAvailable'))
    (objHandle);
end;

function CkWebSocket_ReadFrame (objHandle: HCkWebSocket): wordbool;
begin
  result := TCkWebSocket_ReadFrame(_map(54, 'CkWebSocket_ReadFrame'))
    (objHandle);
end;

function CkWebSocket_ReadFrameAsync (objHandle: HCkWebSocket): HCkTask;
begin
  result := TCkWebSocket_ReadFrameAsync(_map(55, 'CkWebSocket_ReadFrameAsync'))
    (objHandle);
end;

function CkWebSocket_SendClose (objHandle: HCkWebSocket; includeStatus: wordbool; statusCode: Integer; reason: PWideChar): wordbool;
begin
  result := TCkWebSocket_SendClose(_map(56, 'CkWebSocket_SendClose'))
    (objHandle, includeStatus, statusCode, reason);
end;

function CkWebSocket_SendCloseAsync (objHandle: HCkWebSocket; includeStatus: wordbool; statusCode: Integer; reason: PWideChar): HCkTask;
begin
  result := TCkWebSocket_SendCloseAsync(_map(57, 'CkWebSocket_SendCloseAsync'))
    (objHandle, includeStatus, statusCode, reason);
end;

function CkWebSocket_SendFrame (objHandle: HCkWebSocket; stringToSend: PWideChar; finalFrame: wordbool): wordbool;
begin
  result := TCkWebSocket_SendFrame(_map(58, 'CkWebSocket_SendFrame'))
    (objHandle, stringToSend, finalFrame);
end;

function CkWebSocket_SendFrameAsync (objHandle: HCkWebSocket; stringToSend: PWideChar; finalFrame: wordbool): HCkTask;
begin
  result := TCkWebSocket_SendFrameAsync(_map(59, 'CkWebSocket_SendFrameAsync'))
    (objHandle, stringToSend, finalFrame);
end;

function CkWebSocket_SendFrameBd (objHandle: HCkWebSocket; bdToSend: HCkBinData; finalFrame: wordbool): wordbool;
begin
  result := TCkWebSocket_SendFrameBd(_map(60, 'CkWebSocket_SendFrameBd'))
    (objHandle, bdToSend, finalFrame);
end;

function CkWebSocket_SendFrameBdAsync (objHandle: HCkWebSocket; bdToSend: HCkBinData; finalFrame: wordbool): HCkTask;
begin
  result := TCkWebSocket_SendFrameBdAsync(_map(61, 'CkWebSocket_SendFrameBdAsync'))
    (objHandle, bdToSend, finalFrame);
end;

function CkWebSocket_SendFrameSb (objHandle: HCkWebSocket; sbToSend: HCkStringBuilder; finalFrame: wordbool): wordbool;
begin
  result := TCkWebSocket_SendFrameSb(_map(62, 'CkWebSocket_SendFrameSb'))
    (objHandle, sbToSend, finalFrame);
end;

function CkWebSocket_SendFrameSbAsync (objHandle: HCkWebSocket; sbToSend: HCkStringBuilder; finalFrame: wordbool): HCkTask;
begin
  result := TCkWebSocket_SendFrameSbAsync(_map(63, 'CkWebSocket_SendFrameSbAsync'))
    (objHandle, sbToSend, finalFrame);
end;

function CkWebSocket_SendPing (objHandle: HCkWebSocket; pingData: PWideChar): wordbool;
begin
  result := TCkWebSocket_SendPing(_map(64, 'CkWebSocket_SendPing'))
    (objHandle, pingData);
end;

function CkWebSocket_SendPingAsync (objHandle: HCkWebSocket; pingData: PWideChar): HCkTask;
begin
  result := TCkWebSocket_SendPingAsync(_map(65, 'CkWebSocket_SendPingAsync'))
    (objHandle, pingData);
end;

function CkWebSocket_SendPong (objHandle: HCkWebSocket): wordbool;
begin
  result := TCkWebSocket_SendPong(_map(66, 'CkWebSocket_SendPong'))
    (objHandle);
end;

function CkWebSocket_SendPongAsync (objHandle: HCkWebSocket): HCkTask;
begin
  result := TCkWebSocket_SendPongAsync(_map(67, 'CkWebSocket_SendPongAsync'))
    (objHandle);
end;

function CkWebSocket_ShareConnection (objHandle: HCkWebSocket; ws: HCkWebSocket): wordbool;
begin
  result := TCkWebSocket_ShareConnection(_map(68, 'CkWebSocket_ShareConnection'))
    (objHandle, ws);
end;

function CkWebSocket_UseConnection (objHandle: HCkWebSocket; connection: HCkRest): wordbool;
begin
  result := TCkWebSocket_UseConnection(_map(69, 'CkWebSocket_UseConnection'))
    (objHandle, connection);
end;

function CkWebSocket_ValidateServerHandshake (objHandle: HCkWebSocket): wordbool;
begin
  result := TCkWebSocket_ValidateServerHandshake(_map(70, 'CkWebSocket_ValidateServerHandshake'))
    (objHandle);
end;

end.
