unit XmlCertVault;

interface

type

HCkXmlCertVault = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkPfx = Pointer;
HCkCertChain = Pointer;
HCkCert = Pointer;


function CkXmlCertVault_Create: HCkXmlCertVault;  stdcall;
procedure CkXmlCertVault_Dispose(handle: HCkXmlCertVault); stdcall;
procedure CkXmlCertVault_getDebugLogFilePath(objHandle: HCkXmlCertVault; outPropVal: HCkString);
procedure CkXmlCertVault_putDebugLogFilePath(objHandle: HCkXmlCertVault; newPropVal: PWideChar);
function CkXmlCertVault__debugLogFilePath(objHandle: HCkXmlCertVault): PWideChar;
procedure CkXmlCertVault_getLastErrorHtml(objHandle: HCkXmlCertVault; outPropVal: HCkString);
function CkXmlCertVault__lastErrorHtml(objHandle: HCkXmlCertVault): PWideChar;
procedure CkXmlCertVault_getLastErrorText(objHandle: HCkXmlCertVault; outPropVal: HCkString);
function CkXmlCertVault__lastErrorText(objHandle: HCkXmlCertVault): PWideChar;
procedure CkXmlCertVault_getLastErrorXml(objHandle: HCkXmlCertVault; outPropVal: HCkString);
function CkXmlCertVault__lastErrorXml(objHandle: HCkXmlCertVault): PWideChar;
function CkXmlCertVault_getLastMethodSuccess(objHandle: HCkXmlCertVault): wordbool;
procedure CkXmlCertVault_putLastMethodSuccess(objHandle: HCkXmlCertVault; newPropVal: wordbool);
procedure CkXmlCertVault_getMasterPassword(objHandle: HCkXmlCertVault; outPropVal: HCkString);
procedure CkXmlCertVault_putMasterPassword(objHandle: HCkXmlCertVault; newPropVal: PWideChar);
function CkXmlCertVault__masterPassword(objHandle: HCkXmlCertVault): PWideChar;
function CkXmlCertVault_getVerboseLogging(objHandle: HCkXmlCertVault): wordbool;
procedure CkXmlCertVault_putVerboseLogging(objHandle: HCkXmlCertVault; newPropVal: wordbool);
procedure CkXmlCertVault_getVersion(objHandle: HCkXmlCertVault; outPropVal: HCkString);
function CkXmlCertVault__version(objHandle: HCkXmlCertVault): PWideChar;
function CkXmlCertVault_AddCert(objHandle: HCkXmlCertVault; cert: HCkCert): wordbool;
function CkXmlCertVault_AddCertBinary(objHandle: HCkXmlCertVault; certBytes: HCkByteData): wordbool;
function CkXmlCertVault_AddCertChain(objHandle: HCkXmlCertVault; certChain: HCkCertChain): wordbool;
function CkXmlCertVault_AddCertEncoded(objHandle: HCkXmlCertVault; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
function CkXmlCertVault_AddCertFile(objHandle: HCkXmlCertVault; path: PWideChar): wordbool;
function CkXmlCertVault_AddCertString(objHandle: HCkXmlCertVault; certData: PWideChar): wordbool;
function CkXmlCertVault_AddPemFile(objHandle: HCkXmlCertVault; path: PWideChar; password: PWideChar): wordbool;
function CkXmlCertVault_AddPfx(objHandle: HCkXmlCertVault; pfx: HCkPfx): wordbool;
function CkXmlCertVault_AddPfxBinary(objHandle: HCkXmlCertVault; pfxBytes: HCkByteData; password: PWideChar): wordbool;
function CkXmlCertVault_AddPfxEncoded(objHandle: HCkXmlCertVault; encodedBytes: PWideChar; encoding: PWideChar; password: PWideChar): wordbool;
function CkXmlCertVault_AddPfxFile(objHandle: HCkXmlCertVault; path: PWideChar; password: PWideChar): wordbool;
function CkXmlCertVault_GetXml(objHandle: HCkXmlCertVault; outStr: HCkString): wordbool;
function CkXmlCertVault__getXml(objHandle: HCkXmlCertVault): PWideChar;
function CkXmlCertVault_LoadXml(objHandle: HCkXmlCertVault; xml: PWideChar): wordbool;
function CkXmlCertVault_LoadXmlFile(objHandle: HCkXmlCertVault; path: PWideChar): wordbool;
function CkXmlCertVault_SaveXml(objHandle: HCkXmlCertVault; path: PWideChar): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkXmlCertVault_Create = function : HCkXmlCertVault; stdcall;
  TCkXmlCertVault_Dispose = procedure (handle: HCkXmlCertVault); stdcall;
  TCkXmlCertVault_getDebugLogFilePath = procedure (objHandle: HCkXmlCertVault; outPropVal: HCkString); stdcall;
  TCkXmlCertVault_putDebugLogFilePath = procedure (objHandle: HCkXmlCertVault; newPropVal: PWideChar); stdcall;
  TCkXmlCertVault__debugLogFilePath = function (objHandle: HCkXmlCertVault): PWideChar; stdcall;
  TCkXmlCertVault_getLastErrorHtml = procedure (objHandle: HCkXmlCertVault; outPropVal: HCkString); stdcall;
  TCkXmlCertVault__lastErrorHtml = function (objHandle: HCkXmlCertVault): PWideChar; stdcall;
  TCkXmlCertVault_getLastErrorText = procedure (objHandle: HCkXmlCertVault; outPropVal: HCkString); stdcall;
  TCkXmlCertVault__lastErrorText = function (objHandle: HCkXmlCertVault): PWideChar; stdcall;
  TCkXmlCertVault_getLastErrorXml = procedure (objHandle: HCkXmlCertVault; outPropVal: HCkString); stdcall;
  TCkXmlCertVault__lastErrorXml = function (objHandle: HCkXmlCertVault): PWideChar; stdcall;
  TCkXmlCertVault_getLastMethodSuccess = function (objHandle: HCkXmlCertVault): wordbool; stdcall;
  TCkXmlCertVault_putLastMethodSuccess = procedure (objHandle: HCkXmlCertVault; newPropVal: wordbool); stdcall;
  TCkXmlCertVault_getMasterPassword = procedure (objHandle: HCkXmlCertVault; outPropVal: HCkString); stdcall;
  TCkXmlCertVault_putMasterPassword = procedure (objHandle: HCkXmlCertVault; newPropVal: PWideChar); stdcall;
  TCkXmlCertVault__masterPassword = function (objHandle: HCkXmlCertVault): PWideChar; stdcall;
  TCkXmlCertVault_getVerboseLogging = function (objHandle: HCkXmlCertVault): wordbool; stdcall;
  TCkXmlCertVault_putVerboseLogging = procedure (objHandle: HCkXmlCertVault; newPropVal: wordbool); stdcall;
  TCkXmlCertVault_getVersion = procedure (objHandle: HCkXmlCertVault; outPropVal: HCkString); stdcall;
  TCkXmlCertVault__version = function (objHandle: HCkXmlCertVault): PWideChar; stdcall;
  TCkXmlCertVault_AddCert = function (objHandle: HCkXmlCertVault; cert: HCkCert): wordbool; stdcall;
  TCkXmlCertVault_AddCertBinary = function (objHandle: HCkXmlCertVault; certBytes: HCkByteData): wordbool; stdcall;
  TCkXmlCertVault_AddCertChain = function (objHandle: HCkXmlCertVault; certChain: HCkCertChain): wordbool; stdcall;
  TCkXmlCertVault_AddCertEncoded = function (objHandle: HCkXmlCertVault; encodedBytes: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkXmlCertVault_AddCertFile = function (objHandle: HCkXmlCertVault; path: PWideChar): wordbool; stdcall;
  TCkXmlCertVault_AddCertString = function (objHandle: HCkXmlCertVault; certData: PWideChar): wordbool; stdcall;
  TCkXmlCertVault_AddPemFile = function (objHandle: HCkXmlCertVault; path: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkXmlCertVault_AddPfx = function (objHandle: HCkXmlCertVault; pfx: HCkPfx): wordbool; stdcall;
  TCkXmlCertVault_AddPfxBinary = function (objHandle: HCkXmlCertVault; pfxBytes: HCkByteData; password: PWideChar): wordbool; stdcall;
  TCkXmlCertVault_AddPfxEncoded = function (objHandle: HCkXmlCertVault; encodedBytes: PWideChar; encoding: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkXmlCertVault_AddPfxFile = function (objHandle: HCkXmlCertVault; path: PWideChar; password: PWideChar): wordbool; stdcall;
  TCkXmlCertVault_GetXml = function (objHandle: HCkXmlCertVault; outStr: HCkString): wordbool; stdcall;
  TCkXmlCertVault__getXml = function (objHandle: HCkXmlCertVault): PWideChar; stdcall;
  TCkXmlCertVault_LoadXml = function (objHandle: HCkXmlCertVault; xml: PWideChar): wordbool; stdcall;
  TCkXmlCertVault_LoadXmlFile = function (objHandle: HCkXmlCertVault; path: PWideChar): wordbool; stdcall;
  TCkXmlCertVault_SaveXml = function (objHandle: HCkXmlCertVault; path: PWideChar): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..35] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkXmlCertVault_Create : HCkXmlCertVault;
begin
  result := TCkXmlCertVault_Create(_map(0, 'CkXmlCertVault_Create'));
end;

procedure CkXmlCertVault_Dispose (handle: HCkXmlCertVault);
begin
  TCkXmlCertVault_Dispose(_map(1, 'CkXmlCertVault_Dispose'))
    (handle);
end;


procedure CkXmlCertVault_getDebugLogFilePath (objHandle: HCkXmlCertVault; outPropVal: HCkString);
begin
  TCkXmlCertVault_getDebugLogFilePath(_map(2, 'CkXmlCertVault_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkXmlCertVault_putDebugLogFilePath (objHandle: HCkXmlCertVault; newPropVal: PWideChar);
begin
  TCkXmlCertVault_putDebugLogFilePath(_map(3, 'CkXmlCertVault_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkXmlCertVault__debugLogFilePath (objHandle: HCkXmlCertVault): PWideChar;
begin
  result := TCkXmlCertVault__debugLogFilePath(_map(4, 'CkXmlCertVault__debugLogFilePath'))
    (objHandle);
end;

procedure CkXmlCertVault_getLastErrorHtml (objHandle: HCkXmlCertVault; outPropVal: HCkString);
begin
  TCkXmlCertVault_getLastErrorHtml(_map(5, 'CkXmlCertVault_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkXmlCertVault__lastErrorHtml (objHandle: HCkXmlCertVault): PWideChar;
begin
  result := TCkXmlCertVault__lastErrorHtml(_map(6, 'CkXmlCertVault__lastErrorHtml'))
    (objHandle);
end;

procedure CkXmlCertVault_getLastErrorText (objHandle: HCkXmlCertVault; outPropVal: HCkString);
begin
  TCkXmlCertVault_getLastErrorText(_map(7, 'CkXmlCertVault_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkXmlCertVault__lastErrorText (objHandle: HCkXmlCertVault): PWideChar;
begin
  result := TCkXmlCertVault__lastErrorText(_map(8, 'CkXmlCertVault__lastErrorText'))
    (objHandle);
end;

procedure CkXmlCertVault_getLastErrorXml (objHandle: HCkXmlCertVault; outPropVal: HCkString);
begin
  TCkXmlCertVault_getLastErrorXml(_map(9, 'CkXmlCertVault_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkXmlCertVault__lastErrorXml (objHandle: HCkXmlCertVault): PWideChar;
begin
  result := TCkXmlCertVault__lastErrorXml(_map(10, 'CkXmlCertVault__lastErrorXml'))
    (objHandle);
end;

function CkXmlCertVault_getLastMethodSuccess (objHandle: HCkXmlCertVault): wordbool;
begin
    result := TCkXmlCertVault_getLastMethodSuccess(_map(11, 'CkXmlCertVault_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkXmlCertVault_putLastMethodSuccess (objHandle: HCkXmlCertVault; newPropVal: wordbool);
begin
  TCkXmlCertVault_putLastMethodSuccess(_map(12, 'CkXmlCertVault_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkXmlCertVault_getMasterPassword (objHandle: HCkXmlCertVault; outPropVal: HCkString);
begin
  TCkXmlCertVault_getMasterPassword(_map(13, 'CkXmlCertVault_getMasterPassword'))
    (objHandle, outPropVal);
end;

procedure CkXmlCertVault_putMasterPassword (objHandle: HCkXmlCertVault; newPropVal: PWideChar);
begin
  TCkXmlCertVault_putMasterPassword(_map(14, 'CkXmlCertVault_putMasterPassword'))
    (objHandle, newPropVal);
end;

function CkXmlCertVault__masterPassword (objHandle: HCkXmlCertVault): PWideChar;
begin
  result := TCkXmlCertVault__masterPassword(_map(15, 'CkXmlCertVault__masterPassword'))
    (objHandle);
end;

function CkXmlCertVault_getVerboseLogging (objHandle: HCkXmlCertVault): wordbool;
begin
    result := TCkXmlCertVault_getVerboseLogging(_map(16, 'CkXmlCertVault_getVerboseLogging'))
    (objHandle);
end;

procedure CkXmlCertVault_putVerboseLogging (objHandle: HCkXmlCertVault; newPropVal: wordbool);
begin
  TCkXmlCertVault_putVerboseLogging(_map(17, 'CkXmlCertVault_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkXmlCertVault_getVersion (objHandle: HCkXmlCertVault; outPropVal: HCkString);
begin
  TCkXmlCertVault_getVersion(_map(18, 'CkXmlCertVault_getVersion'))
    (objHandle, outPropVal);
end;

function CkXmlCertVault__version (objHandle: HCkXmlCertVault): PWideChar;
begin
  result := TCkXmlCertVault__version(_map(19, 'CkXmlCertVault__version'))
    (objHandle);
end;

function CkXmlCertVault_AddCert (objHandle: HCkXmlCertVault; cert: HCkCert): wordbool;
begin
  result := TCkXmlCertVault_AddCert(_map(20, 'CkXmlCertVault_AddCert'))
    (objHandle, cert);
end;

function CkXmlCertVault_AddCertBinary (objHandle: HCkXmlCertVault; certBytes: HCkByteData): wordbool;
begin
  result := TCkXmlCertVault_AddCertBinary(_map(21, 'CkXmlCertVault_AddCertBinary'))
    (objHandle, certBytes);
end;

function CkXmlCertVault_AddCertChain (objHandle: HCkXmlCertVault; certChain: HCkCertChain): wordbool;
begin
  result := TCkXmlCertVault_AddCertChain(_map(22, 'CkXmlCertVault_AddCertChain'))
    (objHandle, certChain);
end;

function CkXmlCertVault_AddCertEncoded (objHandle: HCkXmlCertVault; encodedBytes: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkXmlCertVault_AddCertEncoded(_map(23, 'CkXmlCertVault_AddCertEncoded'))
    (objHandle, encodedBytes, encoding);
end;

function CkXmlCertVault_AddCertFile (objHandle: HCkXmlCertVault; path: PWideChar): wordbool;
begin
  result := TCkXmlCertVault_AddCertFile(_map(24, 'CkXmlCertVault_AddCertFile'))
    (objHandle, path);
end;

function CkXmlCertVault_AddCertString (objHandle: HCkXmlCertVault; certData: PWideChar): wordbool;
begin
  result := TCkXmlCertVault_AddCertString(_map(25, 'CkXmlCertVault_AddCertString'))
    (objHandle, certData);
end;

function CkXmlCertVault_AddPemFile (objHandle: HCkXmlCertVault; path: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkXmlCertVault_AddPemFile(_map(26, 'CkXmlCertVault_AddPemFile'))
    (objHandle, path, password);
end;

function CkXmlCertVault_AddPfx (objHandle: HCkXmlCertVault; pfx: HCkPfx): wordbool;
begin
  result := TCkXmlCertVault_AddPfx(_map(27, 'CkXmlCertVault_AddPfx'))
    (objHandle, pfx);
end;

function CkXmlCertVault_AddPfxBinary (objHandle: HCkXmlCertVault; pfxBytes: HCkByteData; password: PWideChar): wordbool;
begin
  result := TCkXmlCertVault_AddPfxBinary(_map(28, 'CkXmlCertVault_AddPfxBinary'))
    (objHandle, pfxBytes, password);
end;

function CkXmlCertVault_AddPfxEncoded (objHandle: HCkXmlCertVault; encodedBytes: PWideChar; encoding: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkXmlCertVault_AddPfxEncoded(_map(29, 'CkXmlCertVault_AddPfxEncoded'))
    (objHandle, encodedBytes, encoding, password);
end;

function CkXmlCertVault_AddPfxFile (objHandle: HCkXmlCertVault; path: PWideChar; password: PWideChar): wordbool;
begin
  result := TCkXmlCertVault_AddPfxFile(_map(30, 'CkXmlCertVault_AddPfxFile'))
    (objHandle, path, password);
end;

function CkXmlCertVault_GetXml (objHandle: HCkXmlCertVault; outStr: HCkString): wordbool;
begin
  result := TCkXmlCertVault_GetXml(_map(31, 'CkXmlCertVault_GetXml'))
    (objHandle, outStr);
end;

function CkXmlCertVault__getXml (objHandle: HCkXmlCertVault): PWideChar;
begin
  result := TCkXmlCertVault__getXml(_map(32, 'CkXmlCertVault__getXml'))
    (objHandle);
end;

function CkXmlCertVault_LoadXml (objHandle: HCkXmlCertVault; xml: PWideChar): wordbool;
begin
  result := TCkXmlCertVault_LoadXml(_map(33, 'CkXmlCertVault_LoadXml'))
    (objHandle, xml);
end;

function CkXmlCertVault_LoadXmlFile (objHandle: HCkXmlCertVault; path: PWideChar): wordbool;
begin
  result := TCkXmlCertVault_LoadXmlFile(_map(34, 'CkXmlCertVault_LoadXmlFile'))
    (objHandle, path);
end;

function CkXmlCertVault_SaveXml (objHandle: HCkXmlCertVault; path: PWideChar): wordbool;
begin
  result := TCkXmlCertVault_SaveXml(_map(35, 'CkXmlCertVault_SaveXml'))
    (objHandle, path);
end;

end.
