unit XmlDSigGen;

interface

type

HCkBinData = Pointer;
HCkPrivateKey = Pointer;
HCkHttp = Pointer;
HCkXml = Pointer;
HCkString = Pointer;
HCkXmlDSigGen = Pointer;
HCkCert = Pointer;
HCkStringBuilder = Pointer;
HCkTask = Pointer;
HCkJsonObject = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TXmlDSigGenAbortCheck = function(): Integer; cdecl;
TXmlDSigGenProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TXmlDSigGenPercentDone = function(pctDone: Integer): Integer; cdecl;
TXmlDSigGenTaskCompleted = procedure(task: HCkTask); cdecl;


function CkXmlDSigGen_Create: HCkXmlDSigGen;  stdcall;
procedure CkXmlDSigGen_Dispose(handle: HCkXmlDSigGen); stdcall;

procedure CkXmlDSigGen_SetAbortCheck(objHandle: HCkXmlDSigGen; fn: TXmlDSigGenAbortCheck) stdcall;
procedure CkXmlDSigGen_SetProgressInfo(objHandle: HCkXmlDSigGen; fn: TXmlDSigGenProgressInfo) stdcall;
procedure CkXmlDSigGen_SetPercentDone(objHandle: HCkXmlDSigGen; fn: TXmlDSigGenPercentDone) stdcall;
procedure CkXmlDSigGen_SetTaskCompleted(objHandle: HCkXmlDSigGen; fn: TXmlDSigGenTaskCompleted) stdcall;
procedure CkXmlDSigGen_getBehaviors(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putBehaviors(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__behaviors(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getCustomKeyInfoXml(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putCustomKeyInfoXml(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__customKeyInfoXml(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getDebugLogFilePath(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putDebugLogFilePath(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__debugLogFilePath(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getIncNamespacePrefix(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putIncNamespacePrefix(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__incNamespacePrefix(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getIncNamespaceUri(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putIncNamespaceUri(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__incNamespaceUri(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getKeyInfoId(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putKeyInfoId(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__keyInfoId(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getKeyInfoKeyName(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putKeyInfoKeyName(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__keyInfoKeyName(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getKeyInfoType(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putKeyInfoType(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__keyInfoType(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getLastErrorHtml(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
function CkXmlDSigGen__lastErrorHtml(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getLastErrorText(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
function CkXmlDSigGen__lastErrorText(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getLastErrorXml(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
function CkXmlDSigGen__lastErrorXml(objHandle: HCkXmlDSigGen): PWideChar;
function CkXmlDSigGen_getLastMethodSuccess(objHandle: HCkXmlDSigGen): wordbool;
procedure CkXmlDSigGen_putLastMethodSuccess(objHandle: HCkXmlDSigGen; newPropVal: wordbool);
procedure CkXmlDSigGen_getSigId(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putSigId(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__sigId(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getSigLocation(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putSigLocation(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__sigLocation(objHandle: HCkXmlDSigGen): PWideChar;
function CkXmlDSigGen_getSigLocationIdx(objHandle: HCkXmlDSigGen): Integer;
procedure CkXmlDSigGen_putSigLocationIdx(objHandle: HCkXmlDSigGen; newPropVal: Integer);
function CkXmlDSigGen_getSigLocationMod(objHandle: HCkXmlDSigGen): Integer;
procedure CkXmlDSigGen_putSigLocationMod(objHandle: HCkXmlDSigGen; newPropVal: Integer);
procedure CkXmlDSigGen_getSigNamespacePrefix(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putSigNamespacePrefix(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__sigNamespacePrefix(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getSigNamespaceUri(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putSigNamespaceUri(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__sigNamespaceUri(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getSignedInfoCanonAlg(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putSignedInfoCanonAlg(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__signedInfoCanonAlg(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getSignedInfoDigestMethod(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putSignedInfoDigestMethod(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__signedInfoDigestMethod(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getSignedInfoId(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putSignedInfoId(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__signedInfoId(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getSignedInfoPrefixList(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putSignedInfoPrefixList(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__signedInfoPrefixList(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getSigningAlg(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putSigningAlg(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__signingAlg(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getSigValueId(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putSigValueId(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__sigValueId(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getUncommonOptions(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putUncommonOptions(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__uncommonOptions(objHandle: HCkXmlDSigGen): PWideChar;
function CkXmlDSigGen_getVerboseLogging(objHandle: HCkXmlDSigGen): wordbool;
procedure CkXmlDSigGen_putVerboseLogging(objHandle: HCkXmlDSigGen; newPropVal: wordbool);
procedure CkXmlDSigGen_getVersion(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
function CkXmlDSigGen__version(objHandle: HCkXmlDSigGen): PWideChar;
procedure CkXmlDSigGen_getX509Type(objHandle: HCkXmlDSigGen; outPropVal: HCkString);
procedure CkXmlDSigGen_putX509Type(objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
function CkXmlDSigGen__x509Type(objHandle: HCkXmlDSigGen): PWideChar;
function CkXmlDSigGen_AddEnvelopedRef(objHandle: HCkXmlDSigGen; id: PWideChar; content: HCkStringBuilder; digestMethod: PWideChar; canonMethod: PWideChar; refType: PWideChar): wordbool;
function CkXmlDSigGen_AddExternalBinaryRef(objHandle: HCkXmlDSigGen; uri: PWideChar; content: HCkBinData; digestMethod: PWideChar; refType: PWideChar): wordbool;
function CkXmlDSigGen_AddExternalFileRef(objHandle: HCkXmlDSigGen; uri: PWideChar; localFilePath: PWideChar; digestMethod: PWideChar; refType: PWideChar): wordbool;
function CkXmlDSigGen_AddExternalTextRef(objHandle: HCkXmlDSigGen; uri: PWideChar; content: HCkStringBuilder; charset: PWideChar; includeBom: wordbool; digestMethod: PWideChar; refType: PWideChar): wordbool;
function CkXmlDSigGen_AddExternalXmlRef(objHandle: HCkXmlDSigGen; uri: PWideChar; content: HCkStringBuilder; digestMethod: PWideChar; canonMethod: PWideChar; refType: PWideChar): wordbool;
function CkXmlDSigGen_AddObject(objHandle: HCkXmlDSigGen; id: PWideChar; content: PWideChar; mimeType: PWideChar; encoding: PWideChar): wordbool;
function CkXmlDSigGen_AddObjectRef(objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; canonMethod: PWideChar; prefixList: PWideChar; refType: PWideChar): wordbool;
function CkXmlDSigGen_AddObjectRef2(objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; transforms: HCkXml; refType: PWideChar): wordbool;
function CkXmlDSigGen_AddSameDocRef(objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; canonMethod: PWideChar; prefixList: PWideChar; refType: PWideChar): wordbool;
function CkXmlDSigGen_AddSameDocRef2(objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; transforms: HCkXml; refType: PWideChar): wordbool;
function CkXmlDSigGen_AddSignatureNamespace(objHandle: HCkXmlDSigGen; nsPrefix: PWideChar; nsUri: PWideChar): wordbool;
function CkXmlDSigGen_ConstructSignedInfo(objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder; outStr: HCkString): wordbool;
function CkXmlDSigGen__constructSignedInfo(objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder): PWideChar;
function CkXmlDSigGen_CreateXmlDSig(objHandle: HCkXmlDSigGen; inXml: PWideChar; outStr: HCkString): wordbool;
function CkXmlDSigGen__createXmlDSig(objHandle: HCkXmlDSigGen; inXml: PWideChar): PWideChar;
function CkXmlDSigGen_CreateXmlDSigAsync(objHandle: HCkXmlDSigGen; inXml: PWideChar): HCkTask;
function CkXmlDSigGen_CreateXmlDSigSb(objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder): wordbool;
function CkXmlDSigGen_CreateXmlDSigSbAsync(objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder): HCkTask;
function CkXmlDSigGen_SetHmacKey(objHandle: HCkXmlDSigGen; key: PWideChar; encoding: PWideChar): wordbool;
procedure CkXmlDSigGen_SetHttpObj(objHandle: HCkXmlDSigGen; http: HCkHttp);
function CkXmlDSigGen_SetPrivateKey(objHandle: HCkXmlDSigGen; privKey: HCkPrivateKey): wordbool;
function CkXmlDSigGen_SetRefIdAttr(objHandle: HCkXmlDSigGen; uri_or_id: PWideChar; value: PWideChar): wordbool;
function CkXmlDSigGen_SetTsa(objHandle: HCkXmlDSigGen; json: HCkJsonObject): wordbool;
function CkXmlDSigGen_SetX509Cert(objHandle: HCkXmlDSigGen; cert: HCkCert; usePrivateKey: wordbool): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkXmlDSigGen_Create = function : HCkXmlDSigGen; stdcall;
  TCkXmlDSigGen_Dispose = procedure (handle: HCkXmlDSigGen); stdcall;
  TCkXmlDSigGen_SetAbortCheck = procedure (objHandle: HCkXmlDSigGen; fn: TXmlDSigGenAbortCheck); stdcall;
  TCkXmlDSigGen_SetProgressInfo = procedure (objHandle: HCkXmlDSigGen; fn: TXmlDSigGenProgressInfo); stdcall;
  TCkXmlDSigGen_SetPercentDone = procedure (objHandle: HCkXmlDSigGen; fn: TXmlDSigGenPercentDone); stdcall;
  TCkXmlDSigGen_SetTaskCompleted = procedure (objHandle: HCkXmlDSigGen; fn: TXmlDSigGenTaskCompleted); stdcall;
  TCkXmlDSigGen_getBehaviors = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putBehaviors = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__behaviors = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getCustomKeyInfoXml = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putCustomKeyInfoXml = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__customKeyInfoXml = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getDebugLogFilePath = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putDebugLogFilePath = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__debugLogFilePath = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getIncNamespacePrefix = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putIncNamespacePrefix = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__incNamespacePrefix = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getIncNamespaceUri = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putIncNamespaceUri = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__incNamespaceUri = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getKeyInfoId = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putKeyInfoId = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__keyInfoId = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getKeyInfoKeyName = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putKeyInfoKeyName = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__keyInfoKeyName = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getKeyInfoType = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putKeyInfoType = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__keyInfoType = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getLastErrorHtml = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen__lastErrorHtml = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getLastErrorText = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen__lastErrorText = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getLastErrorXml = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen__lastErrorXml = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getLastMethodSuccess = function (objHandle: HCkXmlDSigGen): wordbool; stdcall;
  TCkXmlDSigGen_putLastMethodSuccess = procedure (objHandle: HCkXmlDSigGen; newPropVal: wordbool); stdcall;
  TCkXmlDSigGen_getSigId = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putSigId = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__sigId = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getSigLocation = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putSigLocation = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__sigLocation = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getSigLocationIdx = function (objHandle: HCkXmlDSigGen): Integer; stdcall;
  TCkXmlDSigGen_putSigLocationIdx = procedure (objHandle: HCkXmlDSigGen; newPropVal: Integer); stdcall;
  TCkXmlDSigGen_getSigLocationMod = function (objHandle: HCkXmlDSigGen): Integer; stdcall;
  TCkXmlDSigGen_putSigLocationMod = procedure (objHandle: HCkXmlDSigGen; newPropVal: Integer); stdcall;
  TCkXmlDSigGen_getSigNamespacePrefix = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putSigNamespacePrefix = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__sigNamespacePrefix = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getSigNamespaceUri = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putSigNamespaceUri = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__sigNamespaceUri = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getSignedInfoCanonAlg = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putSignedInfoCanonAlg = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__signedInfoCanonAlg = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getSignedInfoDigestMethod = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putSignedInfoDigestMethod = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__signedInfoDigestMethod = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getSignedInfoId = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putSignedInfoId = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__signedInfoId = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getSignedInfoPrefixList = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putSignedInfoPrefixList = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__signedInfoPrefixList = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getSigningAlg = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putSigningAlg = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__signingAlg = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getSigValueId = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putSigValueId = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__sigValueId = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getUncommonOptions = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putUncommonOptions = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__uncommonOptions = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getVerboseLogging = function (objHandle: HCkXmlDSigGen): wordbool; stdcall;
  TCkXmlDSigGen_putVerboseLogging = procedure (objHandle: HCkXmlDSigGen; newPropVal: wordbool); stdcall;
  TCkXmlDSigGen_getVersion = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen__version = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_getX509Type = procedure (objHandle: HCkXmlDSigGen; outPropVal: HCkString); stdcall;
  TCkXmlDSigGen_putX509Type = procedure (objHandle: HCkXmlDSigGen; newPropVal: PWideChar); stdcall;
  TCkXmlDSigGen__x509Type = function (objHandle: HCkXmlDSigGen): PWideChar; stdcall;
  TCkXmlDSigGen_AddEnvelopedRef = function (objHandle: HCkXmlDSigGen; id: PWideChar; content: HCkStringBuilder; digestMethod: PWideChar; canonMethod: PWideChar; refType: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_AddExternalBinaryRef = function (objHandle: HCkXmlDSigGen; uri: PWideChar; content: HCkBinData; digestMethod: PWideChar; refType: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_AddExternalFileRef = function (objHandle: HCkXmlDSigGen; uri: PWideChar; localFilePath: PWideChar; digestMethod: PWideChar; refType: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_AddExternalTextRef = function (objHandle: HCkXmlDSigGen; uri: PWideChar; content: HCkStringBuilder; charset: PWideChar; includeBom: wordbool; digestMethod: PWideChar; refType: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_AddExternalXmlRef = function (objHandle: HCkXmlDSigGen; uri: PWideChar; content: HCkStringBuilder; digestMethod: PWideChar; canonMethod: PWideChar; refType: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_AddObject = function (objHandle: HCkXmlDSigGen; id: PWideChar; content: PWideChar; mimeType: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_AddObjectRef = function (objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; canonMethod: PWideChar; prefixList: PWideChar; refType: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_AddObjectRef2 = function (objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; transforms: HCkXml; refType: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_AddSameDocRef = function (objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; canonMethod: PWideChar; prefixList: PWideChar; refType: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_AddSameDocRef2 = function (objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; transforms: HCkXml; refType: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_AddSignatureNamespace = function (objHandle: HCkXmlDSigGen; nsPrefix: PWideChar; nsUri: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_ConstructSignedInfo = function (objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder; outStr: HCkString): wordbool; stdcall;
  TCkXmlDSigGen__constructSignedInfo = function (objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder): PWideChar; stdcall;
  TCkXmlDSigGen_CreateXmlDSig = function (objHandle: HCkXmlDSigGen; inXml: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkXmlDSigGen__createXmlDSig = function (objHandle: HCkXmlDSigGen; inXml: PWideChar): PWideChar; stdcall;
  TCkXmlDSigGen_CreateXmlDSigAsync = function (objHandle: HCkXmlDSigGen; inXml: PWideChar): HCkTask; stdcall;
  TCkXmlDSigGen_CreateXmlDSigSb = function (objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder): wordbool; stdcall;
  TCkXmlDSigGen_CreateXmlDSigSbAsync = function (objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder): HCkTask; stdcall;
  TCkXmlDSigGen_SetHmacKey = function (objHandle: HCkXmlDSigGen; key: PWideChar; encoding: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_SetHttpObj = procedure (objHandle: HCkXmlDSigGen; http: HCkHttp); stdcall;
  TCkXmlDSigGen_SetPrivateKey = function (objHandle: HCkXmlDSigGen; privKey: HCkPrivateKey): wordbool; stdcall;
  TCkXmlDSigGen_SetRefIdAttr = function (objHandle: HCkXmlDSigGen; uri_or_id: PWideChar; value: PWideChar): wordbool; stdcall;
  TCkXmlDSigGen_SetTsa = function (objHandle: HCkXmlDSigGen; json: HCkJsonObject): wordbool; stdcall;
  TCkXmlDSigGen_SetX509Cert = function (objHandle: HCkXmlDSigGen; cert: HCkCert; usePrivateKey: wordbool): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..105] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkXmlDSigGen_Create : HCkXmlDSigGen;
begin
  result := TCkXmlDSigGen_Create(_map(0, 'CkXmlDSigGen_Create'));
end;

procedure CkXmlDSigGen_Dispose (handle: HCkXmlDSigGen);
begin
  TCkXmlDSigGen_Dispose(_map(1, 'CkXmlDSigGen_Dispose'))
    (handle);
end;


procedure CkXmlDSigGen_SetAbortCheck (objHandle: HCkXmlDSigGen; fn: TXmlDSigGenAbortCheck);
begin
    TCkXmlDSigGen_SetAbortCheck(_map(2, 'CkXmlDSigGen_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkXmlDSigGen_SetProgressInfo (objHandle: HCkXmlDSigGen; fn: TXmlDSigGenProgressInfo);
begin
    TCkXmlDSigGen_SetProgressInfo(_map(3, 'CkXmlDSigGen_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkXmlDSigGen_SetPercentDone (objHandle: HCkXmlDSigGen; fn: TXmlDSigGenPercentDone);
begin
    TCkXmlDSigGen_SetPercentDone(_map(4, 'CkXmlDSigGen_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkXmlDSigGen_SetTaskCompleted (objHandle: HCkXmlDSigGen; fn: TXmlDSigGenTaskCompleted);
begin
    TCkXmlDSigGen_SetTaskCompleted(_map(5, 'CkXmlDSigGen_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkXmlDSigGen_getBehaviors (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getBehaviors(_map(6, 'CkXmlDSigGen_getBehaviors'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putBehaviors (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putBehaviors(_map(7, 'CkXmlDSigGen_putBehaviors'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__behaviors (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__behaviors(_map(8, 'CkXmlDSigGen__behaviors'))
    (objHandle);
end;

procedure CkXmlDSigGen_getCustomKeyInfoXml (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getCustomKeyInfoXml(_map(9, 'CkXmlDSigGen_getCustomKeyInfoXml'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putCustomKeyInfoXml (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putCustomKeyInfoXml(_map(10, 'CkXmlDSigGen_putCustomKeyInfoXml'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__customKeyInfoXml (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__customKeyInfoXml(_map(11, 'CkXmlDSigGen__customKeyInfoXml'))
    (objHandle);
end;

procedure CkXmlDSigGen_getDebugLogFilePath (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getDebugLogFilePath(_map(12, 'CkXmlDSigGen_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putDebugLogFilePath (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putDebugLogFilePath(_map(13, 'CkXmlDSigGen_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__debugLogFilePath (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__debugLogFilePath(_map(14, 'CkXmlDSigGen__debugLogFilePath'))
    (objHandle);
end;

procedure CkXmlDSigGen_getIncNamespacePrefix (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getIncNamespacePrefix(_map(15, 'CkXmlDSigGen_getIncNamespacePrefix'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putIncNamespacePrefix (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putIncNamespacePrefix(_map(16, 'CkXmlDSigGen_putIncNamespacePrefix'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__incNamespacePrefix (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__incNamespacePrefix(_map(17, 'CkXmlDSigGen__incNamespacePrefix'))
    (objHandle);
end;

procedure CkXmlDSigGen_getIncNamespaceUri (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getIncNamespaceUri(_map(18, 'CkXmlDSigGen_getIncNamespaceUri'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putIncNamespaceUri (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putIncNamespaceUri(_map(19, 'CkXmlDSigGen_putIncNamespaceUri'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__incNamespaceUri (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__incNamespaceUri(_map(20, 'CkXmlDSigGen__incNamespaceUri'))
    (objHandle);
end;

procedure CkXmlDSigGen_getKeyInfoId (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getKeyInfoId(_map(21, 'CkXmlDSigGen_getKeyInfoId'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putKeyInfoId (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putKeyInfoId(_map(22, 'CkXmlDSigGen_putKeyInfoId'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__keyInfoId (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__keyInfoId(_map(23, 'CkXmlDSigGen__keyInfoId'))
    (objHandle);
end;

procedure CkXmlDSigGen_getKeyInfoKeyName (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getKeyInfoKeyName(_map(24, 'CkXmlDSigGen_getKeyInfoKeyName'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putKeyInfoKeyName (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putKeyInfoKeyName(_map(25, 'CkXmlDSigGen_putKeyInfoKeyName'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__keyInfoKeyName (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__keyInfoKeyName(_map(26, 'CkXmlDSigGen__keyInfoKeyName'))
    (objHandle);
end;

procedure CkXmlDSigGen_getKeyInfoType (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getKeyInfoType(_map(27, 'CkXmlDSigGen_getKeyInfoType'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putKeyInfoType (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putKeyInfoType(_map(28, 'CkXmlDSigGen_putKeyInfoType'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__keyInfoType (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__keyInfoType(_map(29, 'CkXmlDSigGen__keyInfoType'))
    (objHandle);
end;

procedure CkXmlDSigGen_getLastErrorHtml (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getLastErrorHtml(_map(30, 'CkXmlDSigGen_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkXmlDSigGen__lastErrorHtml (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__lastErrorHtml(_map(31, 'CkXmlDSigGen__lastErrorHtml'))
    (objHandle);
end;

procedure CkXmlDSigGen_getLastErrorText (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getLastErrorText(_map(32, 'CkXmlDSigGen_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkXmlDSigGen__lastErrorText (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__lastErrorText(_map(33, 'CkXmlDSigGen__lastErrorText'))
    (objHandle);
end;

procedure CkXmlDSigGen_getLastErrorXml (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getLastErrorXml(_map(34, 'CkXmlDSigGen_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkXmlDSigGen__lastErrorXml (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__lastErrorXml(_map(35, 'CkXmlDSigGen__lastErrorXml'))
    (objHandle);
end;

function CkXmlDSigGen_getLastMethodSuccess (objHandle: HCkXmlDSigGen): wordbool;
begin
    result := TCkXmlDSigGen_getLastMethodSuccess(_map(36, 'CkXmlDSigGen_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkXmlDSigGen_putLastMethodSuccess (objHandle: HCkXmlDSigGen; newPropVal: wordbool);
begin
  TCkXmlDSigGen_putLastMethodSuccess(_map(37, 'CkXmlDSigGen_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkXmlDSigGen_getSigId (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getSigId(_map(38, 'CkXmlDSigGen_getSigId'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putSigId (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putSigId(_map(39, 'CkXmlDSigGen_putSigId'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__sigId (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__sigId(_map(40, 'CkXmlDSigGen__sigId'))
    (objHandle);
end;

procedure CkXmlDSigGen_getSigLocation (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getSigLocation(_map(41, 'CkXmlDSigGen_getSigLocation'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putSigLocation (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putSigLocation(_map(42, 'CkXmlDSigGen_putSigLocation'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__sigLocation (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__sigLocation(_map(43, 'CkXmlDSigGen__sigLocation'))
    (objHandle);
end;

function CkXmlDSigGen_getSigLocationIdx (objHandle: HCkXmlDSigGen): Integer;
begin
    result := TCkXmlDSigGen_getSigLocationIdx(_map(44, 'CkXmlDSigGen_getSigLocationIdx'))
    (objHandle);
end;

procedure CkXmlDSigGen_putSigLocationIdx (objHandle: HCkXmlDSigGen; newPropVal: Integer);
begin
  TCkXmlDSigGen_putSigLocationIdx(_map(45, 'CkXmlDSigGen_putSigLocationIdx'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen_getSigLocationMod (objHandle: HCkXmlDSigGen): Integer;
begin
    result := TCkXmlDSigGen_getSigLocationMod(_map(46, 'CkXmlDSigGen_getSigLocationMod'))
    (objHandle);
end;

procedure CkXmlDSigGen_putSigLocationMod (objHandle: HCkXmlDSigGen; newPropVal: Integer);
begin
  TCkXmlDSigGen_putSigLocationMod(_map(47, 'CkXmlDSigGen_putSigLocationMod'))
    (objHandle, newPropVal);
end;

procedure CkXmlDSigGen_getSigNamespacePrefix (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getSigNamespacePrefix(_map(48, 'CkXmlDSigGen_getSigNamespacePrefix'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putSigNamespacePrefix (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putSigNamespacePrefix(_map(49, 'CkXmlDSigGen_putSigNamespacePrefix'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__sigNamespacePrefix (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__sigNamespacePrefix(_map(50, 'CkXmlDSigGen__sigNamespacePrefix'))
    (objHandle);
end;

procedure CkXmlDSigGen_getSigNamespaceUri (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getSigNamespaceUri(_map(51, 'CkXmlDSigGen_getSigNamespaceUri'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putSigNamespaceUri (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putSigNamespaceUri(_map(52, 'CkXmlDSigGen_putSigNamespaceUri'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__sigNamespaceUri (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__sigNamespaceUri(_map(53, 'CkXmlDSigGen__sigNamespaceUri'))
    (objHandle);
end;

procedure CkXmlDSigGen_getSignedInfoCanonAlg (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getSignedInfoCanonAlg(_map(54, 'CkXmlDSigGen_getSignedInfoCanonAlg'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putSignedInfoCanonAlg (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putSignedInfoCanonAlg(_map(55, 'CkXmlDSigGen_putSignedInfoCanonAlg'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__signedInfoCanonAlg (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__signedInfoCanonAlg(_map(56, 'CkXmlDSigGen__signedInfoCanonAlg'))
    (objHandle);
end;

procedure CkXmlDSigGen_getSignedInfoDigestMethod (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getSignedInfoDigestMethod(_map(57, 'CkXmlDSigGen_getSignedInfoDigestMethod'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putSignedInfoDigestMethod (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putSignedInfoDigestMethod(_map(58, 'CkXmlDSigGen_putSignedInfoDigestMethod'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__signedInfoDigestMethod (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__signedInfoDigestMethod(_map(59, 'CkXmlDSigGen__signedInfoDigestMethod'))
    (objHandle);
end;

procedure CkXmlDSigGen_getSignedInfoId (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getSignedInfoId(_map(60, 'CkXmlDSigGen_getSignedInfoId'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putSignedInfoId (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putSignedInfoId(_map(61, 'CkXmlDSigGen_putSignedInfoId'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__signedInfoId (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__signedInfoId(_map(62, 'CkXmlDSigGen__signedInfoId'))
    (objHandle);
end;

procedure CkXmlDSigGen_getSignedInfoPrefixList (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getSignedInfoPrefixList(_map(63, 'CkXmlDSigGen_getSignedInfoPrefixList'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putSignedInfoPrefixList (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putSignedInfoPrefixList(_map(64, 'CkXmlDSigGen_putSignedInfoPrefixList'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__signedInfoPrefixList (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__signedInfoPrefixList(_map(65, 'CkXmlDSigGen__signedInfoPrefixList'))
    (objHandle);
end;

procedure CkXmlDSigGen_getSigningAlg (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getSigningAlg(_map(66, 'CkXmlDSigGen_getSigningAlg'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putSigningAlg (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putSigningAlg(_map(67, 'CkXmlDSigGen_putSigningAlg'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__signingAlg (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__signingAlg(_map(68, 'CkXmlDSigGen__signingAlg'))
    (objHandle);
end;

procedure CkXmlDSigGen_getSigValueId (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getSigValueId(_map(69, 'CkXmlDSigGen_getSigValueId'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putSigValueId (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putSigValueId(_map(70, 'CkXmlDSigGen_putSigValueId'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__sigValueId (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__sigValueId(_map(71, 'CkXmlDSigGen__sigValueId'))
    (objHandle);
end;

procedure CkXmlDSigGen_getUncommonOptions (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getUncommonOptions(_map(72, 'CkXmlDSigGen_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putUncommonOptions (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putUncommonOptions(_map(73, 'CkXmlDSigGen_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__uncommonOptions (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__uncommonOptions(_map(74, 'CkXmlDSigGen__uncommonOptions'))
    (objHandle);
end;

function CkXmlDSigGen_getVerboseLogging (objHandle: HCkXmlDSigGen): wordbool;
begin
    result := TCkXmlDSigGen_getVerboseLogging(_map(75, 'CkXmlDSigGen_getVerboseLogging'))
    (objHandle);
end;

procedure CkXmlDSigGen_putVerboseLogging (objHandle: HCkXmlDSigGen; newPropVal: wordbool);
begin
  TCkXmlDSigGen_putVerboseLogging(_map(76, 'CkXmlDSigGen_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkXmlDSigGen_getVersion (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getVersion(_map(77, 'CkXmlDSigGen_getVersion'))
    (objHandle, outPropVal);
end;

function CkXmlDSigGen__version (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__version(_map(78, 'CkXmlDSigGen__version'))
    (objHandle);
end;

procedure CkXmlDSigGen_getX509Type (objHandle: HCkXmlDSigGen; outPropVal: HCkString);
begin
  TCkXmlDSigGen_getX509Type(_map(79, 'CkXmlDSigGen_getX509Type'))
    (objHandle, outPropVal);
end;

procedure CkXmlDSigGen_putX509Type (objHandle: HCkXmlDSigGen; newPropVal: PWideChar);
begin
  TCkXmlDSigGen_putX509Type(_map(80, 'CkXmlDSigGen_putX509Type'))
    (objHandle, newPropVal);
end;

function CkXmlDSigGen__x509Type (objHandle: HCkXmlDSigGen): PWideChar;
begin
  result := TCkXmlDSigGen__x509Type(_map(81, 'CkXmlDSigGen__x509Type'))
    (objHandle);
end;

function CkXmlDSigGen_AddEnvelopedRef (objHandle: HCkXmlDSigGen; id: PWideChar; content: HCkStringBuilder; digestMethod: PWideChar; canonMethod: PWideChar; refType: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_AddEnvelopedRef(_map(82, 'CkXmlDSigGen_AddEnvelopedRef'))
    (objHandle, id, content, digestMethod, canonMethod, refType);
end;

function CkXmlDSigGen_AddExternalBinaryRef (objHandle: HCkXmlDSigGen; uri: PWideChar; content: HCkBinData; digestMethod: PWideChar; refType: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_AddExternalBinaryRef(_map(83, 'CkXmlDSigGen_AddExternalBinaryRef'))
    (objHandle, uri, content, digestMethod, refType);
end;

function CkXmlDSigGen_AddExternalFileRef (objHandle: HCkXmlDSigGen; uri: PWideChar; localFilePath: PWideChar; digestMethod: PWideChar; refType: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_AddExternalFileRef(_map(84, 'CkXmlDSigGen_AddExternalFileRef'))
    (objHandle, uri, localFilePath, digestMethod, refType);
end;

function CkXmlDSigGen_AddExternalTextRef (objHandle: HCkXmlDSigGen; uri: PWideChar; content: HCkStringBuilder; charset: PWideChar; includeBom: wordbool; digestMethod: PWideChar; refType: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_AddExternalTextRef(_map(85, 'CkXmlDSigGen_AddExternalTextRef'))
    (objHandle, uri, content, charset, includeBom, digestMethod, refType);
end;

function CkXmlDSigGen_AddExternalXmlRef (objHandle: HCkXmlDSigGen; uri: PWideChar; content: HCkStringBuilder; digestMethod: PWideChar; canonMethod: PWideChar; refType: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_AddExternalXmlRef(_map(86, 'CkXmlDSigGen_AddExternalXmlRef'))
    (objHandle, uri, content, digestMethod, canonMethod, refType);
end;

function CkXmlDSigGen_AddObject (objHandle: HCkXmlDSigGen; id: PWideChar; content: PWideChar; mimeType: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_AddObject(_map(87, 'CkXmlDSigGen_AddObject'))
    (objHandle, id, content, mimeType, encoding);
end;

function CkXmlDSigGen_AddObjectRef (objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; canonMethod: PWideChar; prefixList: PWideChar; refType: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_AddObjectRef(_map(88, 'CkXmlDSigGen_AddObjectRef'))
    (objHandle, id, digestMethod, canonMethod, prefixList, refType);
end;

function CkXmlDSigGen_AddObjectRef2 (objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; transforms: HCkXml; refType: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_AddObjectRef2(_map(89, 'CkXmlDSigGen_AddObjectRef2'))
    (objHandle, id, digestMethod, transforms, refType);
end;

function CkXmlDSigGen_AddSameDocRef (objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; canonMethod: PWideChar; prefixList: PWideChar; refType: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_AddSameDocRef(_map(90, 'CkXmlDSigGen_AddSameDocRef'))
    (objHandle, id, digestMethod, canonMethod, prefixList, refType);
end;

function CkXmlDSigGen_AddSameDocRef2 (objHandle: HCkXmlDSigGen; id: PWideChar; digestMethod: PWideChar; transforms: HCkXml; refType: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_AddSameDocRef2(_map(91, 'CkXmlDSigGen_AddSameDocRef2'))
    (objHandle, id, digestMethod, transforms, refType);
end;

function CkXmlDSigGen_AddSignatureNamespace (objHandle: HCkXmlDSigGen; nsPrefix: PWideChar; nsUri: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_AddSignatureNamespace(_map(92, 'CkXmlDSigGen_AddSignatureNamespace'))
    (objHandle, nsPrefix, nsUri);
end;

function CkXmlDSigGen_ConstructSignedInfo (objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder; outStr: HCkString): wordbool;
begin
  result := TCkXmlDSigGen_ConstructSignedInfo(_map(93, 'CkXmlDSigGen_ConstructSignedInfo'))
    (objHandle, sbXml, outStr);
end;

function CkXmlDSigGen__constructSignedInfo (objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder): PWideChar;
begin
  result := TCkXmlDSigGen__constructSignedInfo(_map(94, 'CkXmlDSigGen__constructSignedInfo'))
    (objHandle, sbXml);
end;

function CkXmlDSigGen_CreateXmlDSig (objHandle: HCkXmlDSigGen; inXml: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkXmlDSigGen_CreateXmlDSig(_map(95, 'CkXmlDSigGen_CreateXmlDSig'))
    (objHandle, inXml, outStr);
end;

function CkXmlDSigGen__createXmlDSig (objHandle: HCkXmlDSigGen; inXml: PWideChar): PWideChar;
begin
  result := TCkXmlDSigGen__createXmlDSig(_map(96, 'CkXmlDSigGen__createXmlDSig'))
    (objHandle, inXml);
end;

function CkXmlDSigGen_CreateXmlDSigAsync (objHandle: HCkXmlDSigGen; inXml: PWideChar): HCkTask;
begin
  result := TCkXmlDSigGen_CreateXmlDSigAsync(_map(97, 'CkXmlDSigGen_CreateXmlDSigAsync'))
    (objHandle, inXml);
end;

function CkXmlDSigGen_CreateXmlDSigSb (objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder): wordbool;
begin
  result := TCkXmlDSigGen_CreateXmlDSigSb(_map(98, 'CkXmlDSigGen_CreateXmlDSigSb'))
    (objHandle, sbXml);
end;

function CkXmlDSigGen_CreateXmlDSigSbAsync (objHandle: HCkXmlDSigGen; sbXml: HCkStringBuilder): HCkTask;
begin
  result := TCkXmlDSigGen_CreateXmlDSigSbAsync(_map(99, 'CkXmlDSigGen_CreateXmlDSigSbAsync'))
    (objHandle, sbXml);
end;

function CkXmlDSigGen_SetHmacKey (objHandle: HCkXmlDSigGen; key: PWideChar; encoding: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_SetHmacKey(_map(100, 'CkXmlDSigGen_SetHmacKey'))
    (objHandle, key, encoding);
end;

procedure CkXmlDSigGen_SetHttpObj (objHandle: HCkXmlDSigGen; http: HCkHttp);
begin
  TCkXmlDSigGen_SetHttpObj(_map(101, 'CkXmlDSigGen_SetHttpObj'))
    (objHandle, http);
end;

function CkXmlDSigGen_SetPrivateKey (objHandle: HCkXmlDSigGen; privKey: HCkPrivateKey): wordbool;
begin
  result := TCkXmlDSigGen_SetPrivateKey(_map(102, 'CkXmlDSigGen_SetPrivateKey'))
    (objHandle, privKey);
end;

function CkXmlDSigGen_SetRefIdAttr (objHandle: HCkXmlDSigGen; uri_or_id: PWideChar; value: PWideChar): wordbool;
begin
  result := TCkXmlDSigGen_SetRefIdAttr(_map(103, 'CkXmlDSigGen_SetRefIdAttr'))
    (objHandle, uri_or_id, value);
end;

function CkXmlDSigGen_SetTsa (objHandle: HCkXmlDSigGen; json: HCkJsonObject): wordbool;
begin
  result := TCkXmlDSigGen_SetTsa(_map(104, 'CkXmlDSigGen_SetTsa'))
    (objHandle, json);
end;

function CkXmlDSigGen_SetX509Cert (objHandle: HCkXmlDSigGen; cert: HCkCert; usePrivateKey: wordbool): wordbool;
begin
  result := TCkXmlDSigGen_SetX509Cert(_map(105, 'CkXmlDSigGen_SetX509Cert'))
    (objHandle, cert, usePrivateKey);
end;

end.
