unit Xmp;

interface

type

HCkXml = Pointer;
HCkByteData = Pointer;
HCkStringArray = Pointer;
HCkXmp = Pointer;
HCkString = Pointer;


function CkXmp_Create: HCkXmp;  stdcall;
procedure CkXmp_Dispose(handle: HCkXmp); stdcall;
procedure CkXmp_getDebugLogFilePath(objHandle: HCkXmp; outPropVal: HCkString);
procedure CkXmp_putDebugLogFilePath(objHandle: HCkXmp; newPropVal: PWideChar);
function CkXmp__debugLogFilePath(objHandle: HCkXmp): PWideChar;
procedure CkXmp_getLastErrorHtml(objHandle: HCkXmp; outPropVal: HCkString);
function CkXmp__lastErrorHtml(objHandle: HCkXmp): PWideChar;
procedure CkXmp_getLastErrorText(objHandle: HCkXmp; outPropVal: HCkString);
function CkXmp__lastErrorText(objHandle: HCkXmp): PWideChar;
procedure CkXmp_getLastErrorXml(objHandle: HCkXmp; outPropVal: HCkString);
function CkXmp__lastErrorXml(objHandle: HCkXmp): PWideChar;
function CkXmp_getLastMethodSuccess(objHandle: HCkXmp): wordbool;
procedure CkXmp_putLastMethodSuccess(objHandle: HCkXmp; newPropVal: wordbool);
function CkXmp_getNumEmbedded(objHandle: HCkXmp): Integer;
function CkXmp_getStructInnerDescrip(objHandle: HCkXmp): wordbool;
procedure CkXmp_putStructInnerDescrip(objHandle: HCkXmp; newPropVal: wordbool);
procedure CkXmp_getUncommonOptions(objHandle: HCkXmp; outPropVal: HCkString);
procedure CkXmp_putUncommonOptions(objHandle: HCkXmp; newPropVal: PWideChar);
function CkXmp__uncommonOptions(objHandle: HCkXmp): PWideChar;
function CkXmp_getVerboseLogging(objHandle: HCkXmp): wordbool;
procedure CkXmp_putVerboseLogging(objHandle: HCkXmp; newPropVal: wordbool);
procedure CkXmp_getVersion(objHandle: HCkXmp; outPropVal: HCkString);
function CkXmp__version(objHandle: HCkXmp): PWideChar;
function CkXmp_AddArray(objHandle: HCkXmp; xml: HCkXml; arrType: PWideChar; propName: PWideChar; values: HCkStringArray): wordbool;
procedure CkXmp_AddNsMapping(objHandle: HCkXmp; ns: PWideChar; uri: PWideChar);
function CkXmp_AddSimpleInt(objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar; propVal: Integer): wordbool;
function CkXmp_AddSimpleStr(objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar; propVal: PWideChar): wordbool;
function CkXmp_AddStructProp(objHandle: HCkXmp; iChilkatXml: HCkXml; structName: PWideChar; propName: PWideChar; propValue: PWideChar): wordbool;
function CkXmp_Append(objHandle: HCkXmp; iXml: HCkXml): wordbool;
function CkXmp_GetArray(objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): HCkStringArray;
function CkXmp_GetEmbedded(objHandle: HCkXmp; index: Integer): HCkXml;
function CkXmp_GetProperty(objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): HCkXml;
function CkXmp_GetSimpleInt(objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): Integer;
function CkXmp_GetSimpleStr(objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar; outStr: HCkString): wordbool;
function CkXmp__getSimpleStr(objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): PWideChar;
function CkXmp_GetStructPropNames(objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar): HCkStringArray;
function CkXmp_GetStructValue(objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar; propName: PWideChar; outStr: HCkString): wordbool;
function CkXmp__getStructValue(objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar; propName: PWideChar): PWideChar;
function CkXmp_LoadAppFile(objHandle: HCkXmp; filename: PWideChar): wordbool;
function CkXmp_LoadFromBuffer(objHandle: HCkXmp; fileData: HCkByteData; ext: PWideChar): wordbool;
function CkXmp_NewXmp(objHandle: HCkXmp): HCkXml;
function CkXmp_RemoveAllEmbedded(objHandle: HCkXmp): wordbool;
function CkXmp_RemoveArray(objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): wordbool;
function CkXmp_RemoveEmbedded(objHandle: HCkXmp; index: Integer): wordbool;
procedure CkXmp_RemoveNsMapping(objHandle: HCkXmp; ns: PWideChar);
function CkXmp_RemoveSimple(objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): wordbool;
function CkXmp_RemoveStruct(objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar): wordbool;
function CkXmp_RemoveStructProp(objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar; propName: PWideChar): wordbool;
function CkXmp_SaveAppFile(objHandle: HCkXmp; filename: PWideChar): wordbool;
function CkXmp_SaveToBuffer(objHandle: HCkXmp; outData: HCkByteData): wordbool;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkXmp_Create = function : HCkXmp; stdcall;
  TCkXmp_Dispose = procedure (handle: HCkXmp); stdcall;
  TCkXmp_getDebugLogFilePath = procedure (objHandle: HCkXmp; outPropVal: HCkString); stdcall;
  TCkXmp_putDebugLogFilePath = procedure (objHandle: HCkXmp; newPropVal: PWideChar); stdcall;
  TCkXmp__debugLogFilePath = function (objHandle: HCkXmp): PWideChar; stdcall;
  TCkXmp_getLastErrorHtml = procedure (objHandle: HCkXmp; outPropVal: HCkString); stdcall;
  TCkXmp__lastErrorHtml = function (objHandle: HCkXmp): PWideChar; stdcall;
  TCkXmp_getLastErrorText = procedure (objHandle: HCkXmp; outPropVal: HCkString); stdcall;
  TCkXmp__lastErrorText = function (objHandle: HCkXmp): PWideChar; stdcall;
  TCkXmp_getLastErrorXml = procedure (objHandle: HCkXmp; outPropVal: HCkString); stdcall;
  TCkXmp__lastErrorXml = function (objHandle: HCkXmp): PWideChar; stdcall;
  TCkXmp_getLastMethodSuccess = function (objHandle: HCkXmp): wordbool; stdcall;
  TCkXmp_putLastMethodSuccess = procedure (objHandle: HCkXmp; newPropVal: wordbool); stdcall;
  TCkXmp_getNumEmbedded = function (objHandle: HCkXmp): Integer; stdcall;
  TCkXmp_getStructInnerDescrip = function (objHandle: HCkXmp): wordbool; stdcall;
  TCkXmp_putStructInnerDescrip = procedure (objHandle: HCkXmp; newPropVal: wordbool); stdcall;
  TCkXmp_getUncommonOptions = procedure (objHandle: HCkXmp; outPropVal: HCkString); stdcall;
  TCkXmp_putUncommonOptions = procedure (objHandle: HCkXmp; newPropVal: PWideChar); stdcall;
  TCkXmp__uncommonOptions = function (objHandle: HCkXmp): PWideChar; stdcall;
  TCkXmp_getVerboseLogging = function (objHandle: HCkXmp): wordbool; stdcall;
  TCkXmp_putVerboseLogging = procedure (objHandle: HCkXmp; newPropVal: wordbool); stdcall;
  TCkXmp_getVersion = procedure (objHandle: HCkXmp; outPropVal: HCkString); stdcall;
  TCkXmp__version = function (objHandle: HCkXmp): PWideChar; stdcall;
  TCkXmp_AddArray = function (objHandle: HCkXmp; xml: HCkXml; arrType: PWideChar; propName: PWideChar; values: HCkStringArray): wordbool; stdcall;
  TCkXmp_AddNsMapping = procedure (objHandle: HCkXmp; ns: PWideChar; uri: PWideChar); stdcall;
  TCkXmp_AddSimpleInt = function (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar; propVal: Integer): wordbool; stdcall;
  TCkXmp_AddSimpleStr = function (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar; propVal: PWideChar): wordbool; stdcall;
  TCkXmp_AddStructProp = function (objHandle: HCkXmp; iChilkatXml: HCkXml; structName: PWideChar; propName: PWideChar; propValue: PWideChar): wordbool; stdcall;
  TCkXmp_Append = function (objHandle: HCkXmp; iXml: HCkXml): wordbool; stdcall;
  TCkXmp_GetArray = function (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): HCkStringArray; stdcall;
  TCkXmp_GetEmbedded = function (objHandle: HCkXmp; index: Integer): HCkXml; stdcall;
  TCkXmp_GetProperty = function (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): HCkXml; stdcall;
  TCkXmp_GetSimpleInt = function (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): Integer; stdcall;
  TCkXmp_GetSimpleStr = function (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkXmp__getSimpleStr = function (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): PWideChar; stdcall;
  TCkXmp_GetStructPropNames = function (objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar): HCkStringArray; stdcall;
  TCkXmp_GetStructValue = function (objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar; propName: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkXmp__getStructValue = function (objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar; propName: PWideChar): PWideChar; stdcall;
  TCkXmp_LoadAppFile = function (objHandle: HCkXmp; filename: PWideChar): wordbool; stdcall;
  TCkXmp_LoadFromBuffer = function (objHandle: HCkXmp; fileData: HCkByteData; ext: PWideChar): wordbool; stdcall;
  TCkXmp_NewXmp = function (objHandle: HCkXmp): HCkXml; stdcall;
  TCkXmp_RemoveAllEmbedded = function (objHandle: HCkXmp): wordbool; stdcall;
  TCkXmp_RemoveArray = function (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): wordbool; stdcall;
  TCkXmp_RemoveEmbedded = function (objHandle: HCkXmp; index: Integer): wordbool; stdcall;
  TCkXmp_RemoveNsMapping = procedure (objHandle: HCkXmp; ns: PWideChar); stdcall;
  TCkXmp_RemoveSimple = function (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): wordbool; stdcall;
  TCkXmp_RemoveStruct = function (objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar): wordbool; stdcall;
  TCkXmp_RemoveStructProp = function (objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar; propName: PWideChar): wordbool; stdcall;
  TCkXmp_SaveAppFile = function (objHandle: HCkXmp; filename: PWideChar): wordbool; stdcall;
  TCkXmp_SaveToBuffer = function (objHandle: HCkXmp; outData: HCkByteData): wordbool; stdcall;

var
  _fkt_ptr_arr:   array [0..49] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkXmp_Create : HCkXmp;
begin
  result := TCkXmp_Create(_map(0, 'CkXmp_Create'));
end;

procedure CkXmp_Dispose (handle: HCkXmp);
begin
  TCkXmp_Dispose(_map(1, 'CkXmp_Dispose'))
    (handle);
end;


procedure CkXmp_getDebugLogFilePath (objHandle: HCkXmp; outPropVal: HCkString);
begin
  TCkXmp_getDebugLogFilePath(_map(2, 'CkXmp_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkXmp_putDebugLogFilePath (objHandle: HCkXmp; newPropVal: PWideChar);
begin
  TCkXmp_putDebugLogFilePath(_map(3, 'CkXmp_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkXmp__debugLogFilePath (objHandle: HCkXmp): PWideChar;
begin
  result := TCkXmp__debugLogFilePath(_map(4, 'CkXmp__debugLogFilePath'))
    (objHandle);
end;

procedure CkXmp_getLastErrorHtml (objHandle: HCkXmp; outPropVal: HCkString);
begin
  TCkXmp_getLastErrorHtml(_map(5, 'CkXmp_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkXmp__lastErrorHtml (objHandle: HCkXmp): PWideChar;
begin
  result := TCkXmp__lastErrorHtml(_map(6, 'CkXmp__lastErrorHtml'))
    (objHandle);
end;

procedure CkXmp_getLastErrorText (objHandle: HCkXmp; outPropVal: HCkString);
begin
  TCkXmp_getLastErrorText(_map(7, 'CkXmp_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkXmp__lastErrorText (objHandle: HCkXmp): PWideChar;
begin
  result := TCkXmp__lastErrorText(_map(8, 'CkXmp__lastErrorText'))
    (objHandle);
end;

procedure CkXmp_getLastErrorXml (objHandle: HCkXmp; outPropVal: HCkString);
begin
  TCkXmp_getLastErrorXml(_map(9, 'CkXmp_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkXmp__lastErrorXml (objHandle: HCkXmp): PWideChar;
begin
  result := TCkXmp__lastErrorXml(_map(10, 'CkXmp__lastErrorXml'))
    (objHandle);
end;

function CkXmp_getLastMethodSuccess (objHandle: HCkXmp): wordbool;
begin
    result := TCkXmp_getLastMethodSuccess(_map(11, 'CkXmp_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkXmp_putLastMethodSuccess (objHandle: HCkXmp; newPropVal: wordbool);
begin
  TCkXmp_putLastMethodSuccess(_map(12, 'CkXmp_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkXmp_getNumEmbedded (objHandle: HCkXmp): Integer;
begin
    result := TCkXmp_getNumEmbedded(_map(13, 'CkXmp_getNumEmbedded'))
    (objHandle);
end;

function CkXmp_getStructInnerDescrip (objHandle: HCkXmp): wordbool;
begin
    result := TCkXmp_getStructInnerDescrip(_map(14, 'CkXmp_getStructInnerDescrip'))
    (objHandle);
end;

procedure CkXmp_putStructInnerDescrip (objHandle: HCkXmp; newPropVal: wordbool);
begin
  TCkXmp_putStructInnerDescrip(_map(15, 'CkXmp_putStructInnerDescrip'))
    (objHandle, newPropVal);
end;

procedure CkXmp_getUncommonOptions (objHandle: HCkXmp; outPropVal: HCkString);
begin
  TCkXmp_getUncommonOptions(_map(16, 'CkXmp_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkXmp_putUncommonOptions (objHandle: HCkXmp; newPropVal: PWideChar);
begin
  TCkXmp_putUncommonOptions(_map(17, 'CkXmp_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkXmp__uncommonOptions (objHandle: HCkXmp): PWideChar;
begin
  result := TCkXmp__uncommonOptions(_map(18, 'CkXmp__uncommonOptions'))
    (objHandle);
end;

function CkXmp_getVerboseLogging (objHandle: HCkXmp): wordbool;
begin
    result := TCkXmp_getVerboseLogging(_map(19, 'CkXmp_getVerboseLogging'))
    (objHandle);
end;

procedure CkXmp_putVerboseLogging (objHandle: HCkXmp; newPropVal: wordbool);
begin
  TCkXmp_putVerboseLogging(_map(20, 'CkXmp_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkXmp_getVersion (objHandle: HCkXmp; outPropVal: HCkString);
begin
  TCkXmp_getVersion(_map(21, 'CkXmp_getVersion'))
    (objHandle, outPropVal);
end;

function CkXmp__version (objHandle: HCkXmp): PWideChar;
begin
  result := TCkXmp__version(_map(22, 'CkXmp__version'))
    (objHandle);
end;

function CkXmp_AddArray (objHandle: HCkXmp; xml: HCkXml; arrType: PWideChar; propName: PWideChar; values: HCkStringArray): wordbool;
begin
  result := TCkXmp_AddArray(_map(23, 'CkXmp_AddArray'))
    (objHandle, xml, arrType, propName, values);
end;

procedure CkXmp_AddNsMapping (objHandle: HCkXmp; ns: PWideChar; uri: PWideChar);
begin
  TCkXmp_AddNsMapping(_map(24, 'CkXmp_AddNsMapping'))
    (objHandle, ns, uri);
end;

function CkXmp_AddSimpleInt (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar; propVal: Integer): wordbool;
begin
  result := TCkXmp_AddSimpleInt(_map(25, 'CkXmp_AddSimpleInt'))
    (objHandle, iXml, propName, propVal);
end;

function CkXmp_AddSimpleStr (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar; propVal: PWideChar): wordbool;
begin
  result := TCkXmp_AddSimpleStr(_map(26, 'CkXmp_AddSimpleStr'))
    (objHandle, iXml, propName, propVal);
end;

function CkXmp_AddStructProp (objHandle: HCkXmp; iChilkatXml: HCkXml; structName: PWideChar; propName: PWideChar; propValue: PWideChar): wordbool;
begin
  result := TCkXmp_AddStructProp(_map(27, 'CkXmp_AddStructProp'))
    (objHandle, iChilkatXml, structName, propName, propValue);
end;

function CkXmp_Append (objHandle: HCkXmp; iXml: HCkXml): wordbool;
begin
  result := TCkXmp_Append(_map(28, 'CkXmp_Append'))
    (objHandle, iXml);
end;

function CkXmp_GetArray (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): HCkStringArray;
begin
  result := TCkXmp_GetArray(_map(29, 'CkXmp_GetArray'))
    (objHandle, iXml, propName);
end;

function CkXmp_GetEmbedded (objHandle: HCkXmp; index: Integer): HCkXml;
begin
  result := TCkXmp_GetEmbedded(_map(30, 'CkXmp_GetEmbedded'))
    (objHandle, index);
end;

function CkXmp_GetProperty (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): HCkXml;
begin
  result := TCkXmp_GetProperty(_map(31, 'CkXmp_GetProperty'))
    (objHandle, iXml, propName);
end;

function CkXmp_GetSimpleInt (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): Integer;
begin
  result := TCkXmp_GetSimpleInt(_map(32, 'CkXmp_GetSimpleInt'))
    (objHandle, iXml, propName);
end;

function CkXmp_GetSimpleStr (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkXmp_GetSimpleStr(_map(33, 'CkXmp_GetSimpleStr'))
    (objHandle, iXml, propName, outStr);
end;

function CkXmp__getSimpleStr (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): PWideChar;
begin
  result := TCkXmp__getSimpleStr(_map(34, 'CkXmp__getSimpleStr'))
    (objHandle, iXml, propName);
end;

function CkXmp_GetStructPropNames (objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar): HCkStringArray;
begin
  result := TCkXmp_GetStructPropNames(_map(35, 'CkXmp_GetStructPropNames'))
    (objHandle, iXml, structName);
end;

function CkXmp_GetStructValue (objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar; propName: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkXmp_GetStructValue(_map(36, 'CkXmp_GetStructValue'))
    (objHandle, iXml, structName, propName, outStr);
end;

function CkXmp__getStructValue (objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar; propName: PWideChar): PWideChar;
begin
  result := TCkXmp__getStructValue(_map(37, 'CkXmp__getStructValue'))
    (objHandle, iXml, structName, propName);
end;

function CkXmp_LoadAppFile (objHandle: HCkXmp; filename: PWideChar): wordbool;
begin
  result := TCkXmp_LoadAppFile(_map(38, 'CkXmp_LoadAppFile'))
    (objHandle, filename);
end;

function CkXmp_LoadFromBuffer (objHandle: HCkXmp; fileData: HCkByteData; ext: PWideChar): wordbool;
begin
  result := TCkXmp_LoadFromBuffer(_map(39, 'CkXmp_LoadFromBuffer'))
    (objHandle, fileData, ext);
end;

function CkXmp_NewXmp (objHandle: HCkXmp): HCkXml;
begin
  result := TCkXmp_NewXmp(_map(40, 'CkXmp_NewXmp'))
    (objHandle);
end;

function CkXmp_RemoveAllEmbedded (objHandle: HCkXmp): wordbool;
begin
  result := TCkXmp_RemoveAllEmbedded(_map(41, 'CkXmp_RemoveAllEmbedded'))
    (objHandle);
end;

function CkXmp_RemoveArray (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): wordbool;
begin
  result := TCkXmp_RemoveArray(_map(42, 'CkXmp_RemoveArray'))
    (objHandle, iXml, propName);
end;

function CkXmp_RemoveEmbedded (objHandle: HCkXmp; index: Integer): wordbool;
begin
  result := TCkXmp_RemoveEmbedded(_map(43, 'CkXmp_RemoveEmbedded'))
    (objHandle, index);
end;

procedure CkXmp_RemoveNsMapping (objHandle: HCkXmp; ns: PWideChar);
begin
  TCkXmp_RemoveNsMapping(_map(44, 'CkXmp_RemoveNsMapping'))
    (objHandle, ns);
end;

function CkXmp_RemoveSimple (objHandle: HCkXmp; iXml: HCkXml; propName: PWideChar): wordbool;
begin
  result := TCkXmp_RemoveSimple(_map(45, 'CkXmp_RemoveSimple'))
    (objHandle, iXml, propName);
end;

function CkXmp_RemoveStruct (objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar): wordbool;
begin
  result := TCkXmp_RemoveStruct(_map(46, 'CkXmp_RemoveStruct'))
    (objHandle, iXml, structName);
end;

function CkXmp_RemoveStructProp (objHandle: HCkXmp; iXml: HCkXml; structName: PWideChar; propName: PWideChar): wordbool;
begin
  result := TCkXmp_RemoveStructProp(_map(47, 'CkXmp_RemoveStructProp'))
    (objHandle, iXml, structName, propName);
end;

function CkXmp_SaveAppFile (objHandle: HCkXmp; filename: PWideChar): wordbool;
begin
  result := TCkXmp_SaveAppFile(_map(48, 'CkXmp_SaveAppFile'))
    (objHandle, filename);
end;

function CkXmp_SaveToBuffer (objHandle: HCkXmp; outData: HCkByteData): wordbool;
begin
  result := TCkXmp_SaveToBuffer(_map(49, 'CkXmp_SaveToBuffer'))
    (objHandle, outData);
end;

end.
