unit Zip;

interface

type

HCkBinData = Pointer;
HCkTask = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkZip = Pointer;
HCkStringBuilder = Pointer;
HCkZipEntry = Pointer;
HCkStringArray = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TZipAbortCheck = function(): Integer; cdecl;
TZipProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TZipPercentDone = function(pctDone: Integer): Integer; cdecl;
TZipTaskCompleted = procedure(task: HCkTask); cdecl;


function CkZip_Create: HCkZip;  stdcall;
procedure CkZip_Dispose(handle: HCkZip); stdcall;

procedure CkZip_SetAbortCheck(objHandle: HCkZip; fn: TZipAbortCheck) stdcall;
procedure CkZip_SetProgressInfo(objHandle: HCkZip; fn: TZipProgressInfo) stdcall;
procedure CkZip_SetPercentDone(objHandle: HCkZip; fn: TZipPercentDone) stdcall;
procedure CkZip_SetTaskCompleted(objHandle: HCkZip; fn: TZipTaskCompleted) stdcall;
function CkZip_getAbortCurrent(objHandle: HCkZip): wordbool;
procedure CkZip_putAbortCurrent(objHandle: HCkZip; newPropVal: wordbool);
procedure CkZip_getAppendFromDir(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putAppendFromDir(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__appendFromDir(objHandle: HCkZip): PWideChar;
procedure CkZip_getAutoRun(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putAutoRun(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__autoRun(objHandle: HCkZip): PWideChar;
procedure CkZip_getAutoRunParams(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putAutoRunParams(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__autoRunParams(objHandle: HCkZip): PWideChar;
function CkZip_getAutoTemp(objHandle: HCkZip): wordbool;
procedure CkZip_putAutoTemp(objHandle: HCkZip; newPropVal: wordbool);
function CkZip_getCaseSensitive(objHandle: HCkZip): wordbool;
procedure CkZip_putCaseSensitive(objHandle: HCkZip; newPropVal: wordbool);
function CkZip_getClearArchiveAttribute(objHandle: HCkZip): wordbool;
procedure CkZip_putClearArchiveAttribute(objHandle: HCkZip; newPropVal: wordbool);
function CkZip_getClearReadOnlyAttr(objHandle: HCkZip): wordbool;
procedure CkZip_putClearReadOnlyAttr(objHandle: HCkZip; newPropVal: wordbool);
procedure CkZip_getComment(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putComment(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__comment(objHandle: HCkZip): PWideChar;
procedure CkZip_getDebugLogFilePath(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putDebugLogFilePath(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__debugLogFilePath(objHandle: HCkZip): PWideChar;
procedure CkZip_getDecryptPassword(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putDecryptPassword(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__decryptPassword(objHandle: HCkZip): PWideChar;
function CkZip_getDiscardPaths(objHandle: HCkZip): wordbool;
procedure CkZip_putDiscardPaths(objHandle: HCkZip; newPropVal: wordbool);
function CkZip_getEncryption(objHandle: HCkZip): Integer;
procedure CkZip_putEncryption(objHandle: HCkZip; newPropVal: Integer);
function CkZip_getEncryptKeyLength(objHandle: HCkZip): Integer;
procedure CkZip_putEncryptKeyLength(objHandle: HCkZip; newPropVal: Integer);
procedure CkZip_getEncryptPassword(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putEncryptPassword(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__encryptPassword(objHandle: HCkZip): PWideChar;
procedure CkZip_getExeDefaultDir(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putExeDefaultDir(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__exeDefaultDir(objHandle: HCkZip): PWideChar;
function CkZip_getExeFinishNotifier(objHandle: HCkZip): wordbool;
procedure CkZip_putExeFinishNotifier(objHandle: HCkZip; newPropVal: wordbool);
procedure CkZip_getExeIconFile(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putExeIconFile(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__exeIconFile(objHandle: HCkZip): PWideChar;
function CkZip_getExeNoInterface(objHandle: HCkZip): wordbool;
procedure CkZip_putExeNoInterface(objHandle: HCkZip; newPropVal: wordbool);
function CkZip_getExeSilentProgress(objHandle: HCkZip): wordbool;
procedure CkZip_putExeSilentProgress(objHandle: HCkZip; newPropVal: wordbool);
procedure CkZip_getExeTitle(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putExeTitle(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__exeTitle(objHandle: HCkZip): PWideChar;
procedure CkZip_getExeUnzipCaption(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putExeUnzipCaption(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__exeUnzipCaption(objHandle: HCkZip): PWideChar;
procedure CkZip_getExeUnzipDir(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putExeUnzipDir(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__exeUnzipDir(objHandle: HCkZip): PWideChar;
function CkZip_getExeWaitForSetup(objHandle: HCkZip): wordbool;
procedure CkZip_putExeWaitForSetup(objHandle: HCkZip; newPropVal: wordbool);
procedure CkZip_getExeXmlConfig(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putExeXmlConfig(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__exeXmlConfig(objHandle: HCkZip): PWideChar;
function CkZip_getFileCount(objHandle: HCkZip): Integer;
procedure CkZip_getFileName(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putFileName(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__fileName(objHandle: HCkZip): PWideChar;
function CkZip_getHasZipFormatErrors(objHandle: HCkZip): wordbool;
function CkZip_getHeartbeatMs(objHandle: HCkZip): Integer;
procedure CkZip_putHeartbeatMs(objHandle: HCkZip; newPropVal: Integer);
function CkZip_getIgnoreAccessDenied(objHandle: HCkZip): wordbool;
procedure CkZip_putIgnoreAccessDenied(objHandle: HCkZip; newPropVal: wordbool);
procedure CkZip_getLastErrorHtml(objHandle: HCkZip; outPropVal: HCkString);
function CkZip__lastErrorHtml(objHandle: HCkZip): PWideChar;
procedure CkZip_getLastErrorText(objHandle: HCkZip; outPropVal: HCkString);
function CkZip__lastErrorText(objHandle: HCkZip): PWideChar;
procedure CkZip_getLastErrorXml(objHandle: HCkZip; outPropVal: HCkString);
function CkZip__lastErrorXml(objHandle: HCkZip): PWideChar;
function CkZip_getLastMethodSuccess(objHandle: HCkZip): wordbool;
procedure CkZip_putLastMethodSuccess(objHandle: HCkZip; newPropVal: wordbool);
procedure CkZip_getMaxDate(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putMaxDate(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__maxDate(objHandle: HCkZip): PWideChar;
function CkZip_getMaxUncompressSize(objHandle: HCkZip): LongWord;
procedure CkZip_putMaxUncompressSize(objHandle: HCkZip; newPropVal: LongWord);
procedure CkZip_getMinDate(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putMinDate(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__minDate(objHandle: HCkZip): PWideChar;
function CkZip_getNumEntries(objHandle: HCkZip): Integer;
function CkZip_getOemCodePage(objHandle: HCkZip): Integer;
procedure CkZip_putOemCodePage(objHandle: HCkZip; newPropVal: Integer);
function CkZip_getOverwriteExisting(objHandle: HCkZip): wordbool;
procedure CkZip_putOverwriteExisting(objHandle: HCkZip; newPropVal: wordbool);
function CkZip_getPasswordProtect(objHandle: HCkZip): wordbool;
procedure CkZip_putPasswordProtect(objHandle: HCkZip; newPropVal: wordbool);
procedure CkZip_getPathPrefix(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putPathPrefix(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__pathPrefix(objHandle: HCkZip): PWideChar;
function CkZip_getPercentDoneScale(objHandle: HCkZip): Integer;
procedure CkZip_putPercentDoneScale(objHandle: HCkZip; newPropVal: Integer);
procedure CkZip_getPwdProtCharset(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putPwdProtCharset(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__pwdProtCharset(objHandle: HCkZip): PWideChar;
procedure CkZip_getTempDir(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putTempDir(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__tempDir(objHandle: HCkZip): PWideChar;
procedure CkZip_getUncommonOptions(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putUncommonOptions(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__uncommonOptions(objHandle: HCkZip): PWideChar;
function CkZip_getVerboseLogging(objHandle: HCkZip): wordbool;
procedure CkZip_putVerboseLogging(objHandle: HCkZip; newPropVal: wordbool);
procedure CkZip_getVersion(objHandle: HCkZip; outPropVal: HCkString);
function CkZip__version(objHandle: HCkZip): PWideChar;
function CkZip_getZipx(objHandle: HCkZip): wordbool;
procedure CkZip_putZipx(objHandle: HCkZip; newPropVal: wordbool);
procedure CkZip_getZipxDefaultAlg(objHandle: HCkZip; outPropVal: HCkString);
procedure CkZip_putZipxDefaultAlg(objHandle: HCkZip; newPropVal: PWideChar);
function CkZip__zipxDefaultAlg(objHandle: HCkZip): PWideChar;
function CkZip_AddBd(objHandle: HCkZip; pathInZip: PWideChar; bd: HCkBinData): wordbool;
function CkZip_AddEmpty(objHandle: HCkZip; isDir: wordbool; pathInZip: PWideChar): wordbool;
function CkZip_AddEncoded(objHandle: HCkZip; pathInZip: PWideChar; encoding: PWideChar; data: PWideChar): wordbool;
function CkZip_AddFile(objHandle: HCkZip; localPath: PWideChar; saveExtraPath: wordbool): wordbool;
procedure CkZip_AddNoCompressExtension(objHandle: HCkZip; fileExtension: PWideChar);
function CkZip_AddSb(objHandle: HCkZip; pathInZip: PWideChar; sb: HCkStringBuilder; charset: PWideChar): wordbool;
function CkZip_AddString(objHandle: HCkZip; pathInZip: PWideChar; content: PWideChar; charset: PWideChar): wordbool;
function CkZip_AppendBd(objHandle: HCkZip; pathInZip: PWideChar; byteData: HCkBinData): HCkZipEntry;
function CkZip_AppendData(objHandle: HCkZip; fileName: PWideChar; inData: HCkByteData): HCkZipEntry;
function CkZip_AppendDataEncoded(objHandle: HCkZip; filename: PWideChar; encoding: PWideChar; data: PWideChar): HCkZipEntry;
function CkZip_AppendFiles(objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool): wordbool;
function CkZip_AppendFilesAsync(objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool): HCkTask;
function CkZip_AppendFilesEx(objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool; saveExtraPath: wordbool; archiveOnly: wordbool; includeHidden: wordbool; includeSystem: wordbool): wordbool;
function CkZip_AppendFilesExAsync(objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool; saveExtraPath: wordbool; archiveOnly: wordbool; includeHidden: wordbool; includeSystem: wordbool): HCkTask;
function CkZip_AppendNew(objHandle: HCkZip; fileName: PWideChar): HCkZipEntry;
function CkZip_AppendNewDir(objHandle: HCkZip; dirName: PWideChar): HCkZipEntry;
function CkZip_AppendOneFileOrDir(objHandle: HCkZip; fileOrDirPath: PWideChar; saveExtraPath: wordbool): wordbool;
function CkZip_AppendOneFileOrDirAsync(objHandle: HCkZip; fileOrDirPath: PWideChar; saveExtraPath: wordbool): HCkTask;
function CkZip_AppendSb(objHandle: HCkZip; pathInZip: PWideChar; sb: HCkStringBuilder; charset: PWideChar): wordbool;
function CkZip_AppendString(objHandle: HCkZip; internalZipFilepath: PWideChar; textData: PWideChar): HCkZipEntry;
function CkZip_AppendString2(objHandle: HCkZip; internalZipFilepath: PWideChar; textData: PWideChar; charset: PWideChar): HCkZipEntry;
function CkZip_AppendZip(objHandle: HCkZip; zipFileName: PWideChar): wordbool;
procedure CkZip_CloseZip(objHandle: HCkZip);
function CkZip_DeleteEntry(objHandle: HCkZip; entry: HCkZipEntry): wordbool;
function CkZip_EntryAt(objHandle: HCkZip; index: Integer; entry: HCkZipEntry): wordbool;
function CkZip_EntryById(objHandle: HCkZip; id: Integer; entry: HCkZipEntry): wordbool;
function CkZip_EntryMatching(objHandle: HCkZip; pattern: PWideChar; entry: HCkZipEntry): wordbool;
function CkZip_EntryOf(objHandle: HCkZip; pathInZip: PWideChar; entry: HCkZipEntry): wordbool;
procedure CkZip_ExcludeDir(objHandle: HCkZip; dirName: PWideChar);
function CkZip_ExtractExe(objHandle: HCkZip; exePath: PWideChar; dirPath: PWideChar): wordbool;
function CkZip_ExtractExeAsync(objHandle: HCkZip; exePath: PWideChar; dirPath: PWideChar): HCkTask;
function CkZip_FirstEntry(objHandle: HCkZip): HCkZipEntry;
function CkZip_FirstMatchingEntry(objHandle: HCkZip; pattern: PWideChar): HCkZipEntry;
function CkZip_GetDirectoryAsXML(objHandle: HCkZip; outStr: HCkString): wordbool;
function CkZip__getDirectoryAsXML(objHandle: HCkZip): PWideChar;
function CkZip_GetEntryByID(objHandle: HCkZip; entryID: Integer): HCkZipEntry;
function CkZip_GetEntryByIndex(objHandle: HCkZip; index: Integer): HCkZipEntry;
function CkZip_GetEntryByName(objHandle: HCkZip; entryName: PWideChar): HCkZipEntry;
function CkZip_GetExclusions(objHandle: HCkZip): HCkStringArray;
function CkZip_GetExeConfigParam(objHandle: HCkZip; name: PWideChar; outStr: HCkString): wordbool;
function CkZip__getExeConfigParam(objHandle: HCkZip; name: PWideChar): PWideChar;
function CkZip_GetMaxUncompressedSize(objHandle: HCkZip; outStr: HCkString): wordbool;
function CkZip__getMaxUncompressedSize(objHandle: HCkZip): PWideChar;
function CkZip_IsNoCompressExtension(objHandle: HCkZip; fileExtension: PWideChar): wordbool;
function CkZip_IsPasswordProtected(objHandle: HCkZip; zipFilename: PWideChar): wordbool;
function CkZip_LoadTaskCaller(objHandle: HCkZip; task: HCkTask): wordbool;
function CkZip_NewZip(objHandle: HCkZip; zipFilePath: PWideChar): wordbool;
function CkZip_OpenBd(objHandle: HCkZip; binData: HCkBinData): wordbool;
function CkZip_OpenEmbedded(objHandle: HCkZip; exeFilename: PWideChar; resourceName: PWideChar): wordbool;
function CkZip_OpenFromByteData(objHandle: HCkZip; byteData: HCkByteData): wordbool;
function CkZip_OpenFromMemory(objHandle: HCkZip; inData: HCkByteData): wordbool;
function CkZip_OpenZip(objHandle: HCkZip; zipPath: PWideChar): wordbool;
function CkZip_OpenZipAsync(objHandle: HCkZip; zipPath: PWideChar): HCkTask;
function CkZip_QuickAppend(objHandle: HCkZip; ZipFileName: PWideChar): wordbool;
function CkZip_QuickAppendAsync(objHandle: HCkZip; ZipFileName: PWideChar): HCkTask;
procedure CkZip_RemoveNoCompressExtension(objHandle: HCkZip; fileExtension: PWideChar);
procedure CkZip_SetCompressionLevel(objHandle: HCkZip; level: Integer);
procedure CkZip_SetExclusions(objHandle: HCkZip; excludePatterns: HCkStringArray);
procedure CkZip_SetExeConfigParam(objHandle: HCkZip; paramName: PWideChar; paramValue: PWideChar);
procedure CkZip_SetPassword(objHandle: HCkZip; password: PWideChar);
function CkZip_Unzip(objHandle: HCkZip; dirPath: PWideChar): Integer;
function CkZip_UnzipAsync(objHandle: HCkZip; dirPath: PWideChar): HCkTask;
function CkZip_UnzipInto(objHandle: HCkZip; dirPath: PWideChar): Integer;
function CkZip_UnzipIntoAsync(objHandle: HCkZip; dirPath: PWideChar): HCkTask;
function CkZip_UnzipMatching(objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): Integer;
function CkZip_UnzipMatchingAsync(objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): HCkTask;
function CkZip_UnzipMatchingInto(objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): Integer;
function CkZip_UnzipMatchingIntoAsync(objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): HCkTask;
function CkZip_UnzipNewer(objHandle: HCkZip; dirPath: PWideChar): Integer;
function CkZip_UnzipNewerAsync(objHandle: HCkZip; dirPath: PWideChar): HCkTask;
function CkZip_VerifyPassword(objHandle: HCkZip): wordbool;
function CkZip_WriteBd(objHandle: HCkZip; binData: HCkBinData): wordbool;
function CkZip_WriteBdAsync(objHandle: HCkZip; binData: HCkBinData): HCkTask;
function CkZip_WriteExe(objHandle: HCkZip; exeFilename: PWideChar): wordbool;
function CkZip_WriteExeAsync(objHandle: HCkZip; exeFilename: PWideChar): HCkTask;
function CkZip_WriteExe2(objHandle: HCkZip; exePath: PWideChar; destExePath: PWideChar; bAesEncrypt: wordbool; keyLength: Integer; password: PWideChar): wordbool;
function CkZip_WriteExe2Async(objHandle: HCkZip; exePath: PWideChar; destExePath: PWideChar; bAesEncrypt: wordbool; keyLength: Integer; password: PWideChar): HCkTask;
function CkZip_WriteExeToMemory(objHandle: HCkZip; outData: HCkByteData): wordbool;
function CkZip_WriteExeToMemoryAsync(objHandle: HCkZip): HCkTask;
function CkZip_WriteToMemory(objHandle: HCkZip; outData: HCkByteData): wordbool;
function CkZip_WriteToMemoryAsync(objHandle: HCkZip): HCkTask;
function CkZip_WriteZip(objHandle: HCkZip): wordbool;
function CkZip_WriteZipAsync(objHandle: HCkZip): HCkTask;
function CkZip_WriteZipAndClose(objHandle: HCkZip): wordbool;
function CkZip_WriteZipAndCloseAsync(objHandle: HCkZip): HCkTask;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkZip_Create = function : HCkZip; stdcall;
  TCkZip_Dispose = procedure (handle: HCkZip); stdcall;
  TCkZip_SetAbortCheck = procedure (objHandle: HCkZip; fn: TZipAbortCheck); stdcall;
  TCkZip_SetProgressInfo = procedure (objHandle: HCkZip; fn: TZipProgressInfo); stdcall;
  TCkZip_SetPercentDone = procedure (objHandle: HCkZip; fn: TZipPercentDone); stdcall;
  TCkZip_SetTaskCompleted = procedure (objHandle: HCkZip; fn: TZipTaskCompleted); stdcall;
  TCkZip_getAbortCurrent = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putAbortCurrent = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getAppendFromDir = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putAppendFromDir = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__appendFromDir = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getAutoRun = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putAutoRun = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__autoRun = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getAutoRunParams = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putAutoRunParams = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__autoRunParams = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getAutoTemp = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putAutoTemp = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getCaseSensitive = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putCaseSensitive = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getClearArchiveAttribute = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putClearArchiveAttribute = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getClearReadOnlyAttr = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putClearReadOnlyAttr = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getComment = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putComment = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__comment = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getDebugLogFilePath = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putDebugLogFilePath = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__debugLogFilePath = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getDecryptPassword = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putDecryptPassword = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__decryptPassword = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getDiscardPaths = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putDiscardPaths = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getEncryption = function (objHandle: HCkZip): Integer; stdcall;
  TCkZip_putEncryption = procedure (objHandle: HCkZip; newPropVal: Integer); stdcall;
  TCkZip_getEncryptKeyLength = function (objHandle: HCkZip): Integer; stdcall;
  TCkZip_putEncryptKeyLength = procedure (objHandle: HCkZip; newPropVal: Integer); stdcall;
  TCkZip_getEncryptPassword = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putEncryptPassword = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__encryptPassword = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getExeDefaultDir = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putExeDefaultDir = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__exeDefaultDir = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getExeFinishNotifier = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putExeFinishNotifier = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getExeIconFile = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putExeIconFile = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__exeIconFile = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getExeNoInterface = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putExeNoInterface = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getExeSilentProgress = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putExeSilentProgress = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getExeTitle = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putExeTitle = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__exeTitle = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getExeUnzipCaption = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putExeUnzipCaption = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__exeUnzipCaption = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getExeUnzipDir = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putExeUnzipDir = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__exeUnzipDir = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getExeWaitForSetup = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putExeWaitForSetup = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getExeXmlConfig = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putExeXmlConfig = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__exeXmlConfig = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getFileCount = function (objHandle: HCkZip): Integer; stdcall;
  TCkZip_getFileName = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putFileName = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__fileName = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getHasZipFormatErrors = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_getHeartbeatMs = function (objHandle: HCkZip): Integer; stdcall;
  TCkZip_putHeartbeatMs = procedure (objHandle: HCkZip; newPropVal: Integer); stdcall;
  TCkZip_getIgnoreAccessDenied = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putIgnoreAccessDenied = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getLastErrorHtml = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip__lastErrorHtml = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getLastErrorText = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip__lastErrorText = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getLastErrorXml = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip__lastErrorXml = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getLastMethodSuccess = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putLastMethodSuccess = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getMaxDate = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putMaxDate = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__maxDate = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getMaxUncompressSize = function (objHandle: HCkZip): LongWord; stdcall;
  TCkZip_putMaxUncompressSize = procedure (objHandle: HCkZip; newPropVal: LongWord); stdcall;
  TCkZip_getMinDate = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putMinDate = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__minDate = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getNumEntries = function (objHandle: HCkZip): Integer; stdcall;
  TCkZip_getOemCodePage = function (objHandle: HCkZip): Integer; stdcall;
  TCkZip_putOemCodePage = procedure (objHandle: HCkZip; newPropVal: Integer); stdcall;
  TCkZip_getOverwriteExisting = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putOverwriteExisting = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getPasswordProtect = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putPasswordProtect = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getPathPrefix = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putPathPrefix = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__pathPrefix = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getPercentDoneScale = function (objHandle: HCkZip): Integer; stdcall;
  TCkZip_putPercentDoneScale = procedure (objHandle: HCkZip; newPropVal: Integer); stdcall;
  TCkZip_getPwdProtCharset = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putPwdProtCharset = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__pwdProtCharset = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getTempDir = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putTempDir = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__tempDir = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getUncommonOptions = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putUncommonOptions = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__uncommonOptions = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getVerboseLogging = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putVerboseLogging = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getVersion = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip__version = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_getZipx = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_putZipx = procedure (objHandle: HCkZip; newPropVal: wordbool); stdcall;
  TCkZip_getZipxDefaultAlg = procedure (objHandle: HCkZip; outPropVal: HCkString); stdcall;
  TCkZip_putZipxDefaultAlg = procedure (objHandle: HCkZip; newPropVal: PWideChar); stdcall;
  TCkZip__zipxDefaultAlg = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_AddBd = function (objHandle: HCkZip; pathInZip: PWideChar; bd: HCkBinData): wordbool; stdcall;
  TCkZip_AddEmpty = function (objHandle: HCkZip; isDir: wordbool; pathInZip: PWideChar): wordbool; stdcall;
  TCkZip_AddEncoded = function (objHandle: HCkZip; pathInZip: PWideChar; encoding: PWideChar; data: PWideChar): wordbool; stdcall;
  TCkZip_AddFile = function (objHandle: HCkZip; localPath: PWideChar; saveExtraPath: wordbool): wordbool; stdcall;
  TCkZip_AddNoCompressExtension = procedure (objHandle: HCkZip; fileExtension: PWideChar); stdcall;
  TCkZip_AddSb = function (objHandle: HCkZip; pathInZip: PWideChar; sb: HCkStringBuilder; charset: PWideChar): wordbool; stdcall;
  TCkZip_AddString = function (objHandle: HCkZip; pathInZip: PWideChar; content: PWideChar; charset: PWideChar): wordbool; stdcall;
  TCkZip_AppendBd = function (objHandle: HCkZip; pathInZip: PWideChar; byteData: HCkBinData): HCkZipEntry; stdcall;
  TCkZip_AppendData = function (objHandle: HCkZip; fileName: PWideChar; inData: HCkByteData): HCkZipEntry; stdcall;
  TCkZip_AppendDataEncoded = function (objHandle: HCkZip; filename: PWideChar; encoding: PWideChar; data: PWideChar): HCkZipEntry; stdcall;
  TCkZip_AppendFiles = function (objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool): wordbool; stdcall;
  TCkZip_AppendFilesAsync = function (objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool): HCkTask; stdcall;
  TCkZip_AppendFilesEx = function (objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool; saveExtraPath: wordbool; archiveOnly: wordbool; includeHidden: wordbool; includeSystem: wordbool): wordbool; stdcall;
  TCkZip_AppendFilesExAsync = function (objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool; saveExtraPath: wordbool; archiveOnly: wordbool; includeHidden: wordbool; includeSystem: wordbool): HCkTask; stdcall;
  TCkZip_AppendNew = function (objHandle: HCkZip; fileName: PWideChar): HCkZipEntry; stdcall;
  TCkZip_AppendNewDir = function (objHandle: HCkZip; dirName: PWideChar): HCkZipEntry; stdcall;
  TCkZip_AppendOneFileOrDir = function (objHandle: HCkZip; fileOrDirPath: PWideChar; saveExtraPath: wordbool): wordbool; stdcall;
  TCkZip_AppendOneFileOrDirAsync = function (objHandle: HCkZip; fileOrDirPath: PWideChar; saveExtraPath: wordbool): HCkTask; stdcall;
  TCkZip_AppendSb = function (objHandle: HCkZip; pathInZip: PWideChar; sb: HCkStringBuilder; charset: PWideChar): wordbool; stdcall;
  TCkZip_AppendString = function (objHandle: HCkZip; internalZipFilepath: PWideChar; textData: PWideChar): HCkZipEntry; stdcall;
  TCkZip_AppendString2 = function (objHandle: HCkZip; internalZipFilepath: PWideChar; textData: PWideChar; charset: PWideChar): HCkZipEntry; stdcall;
  TCkZip_AppendZip = function (objHandle: HCkZip; zipFileName: PWideChar): wordbool; stdcall;
  TCkZip_CloseZip = procedure (objHandle: HCkZip); stdcall;
  TCkZip_DeleteEntry = function (objHandle: HCkZip; entry: HCkZipEntry): wordbool; stdcall;
  TCkZip_EntryAt = function (objHandle: HCkZip; index: Integer; entry: HCkZipEntry): wordbool; stdcall;
  TCkZip_EntryById = function (objHandle: HCkZip; id: Integer; entry: HCkZipEntry): wordbool; stdcall;
  TCkZip_EntryMatching = function (objHandle: HCkZip; pattern: PWideChar; entry: HCkZipEntry): wordbool; stdcall;
  TCkZip_EntryOf = function (objHandle: HCkZip; pathInZip: PWideChar; entry: HCkZipEntry): wordbool; stdcall;
  TCkZip_ExcludeDir = procedure (objHandle: HCkZip; dirName: PWideChar); stdcall;
  TCkZip_ExtractExe = function (objHandle: HCkZip; exePath: PWideChar; dirPath: PWideChar): wordbool; stdcall;
  TCkZip_ExtractExeAsync = function (objHandle: HCkZip; exePath: PWideChar; dirPath: PWideChar): HCkTask; stdcall;
  TCkZip_FirstEntry = function (objHandle: HCkZip): HCkZipEntry; stdcall;
  TCkZip_FirstMatchingEntry = function (objHandle: HCkZip; pattern: PWideChar): HCkZipEntry; stdcall;
  TCkZip_GetDirectoryAsXML = function (objHandle: HCkZip; outStr: HCkString): wordbool; stdcall;
  TCkZip__getDirectoryAsXML = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_GetEntryByID = function (objHandle: HCkZip; entryID: Integer): HCkZipEntry; stdcall;
  TCkZip_GetEntryByIndex = function (objHandle: HCkZip; index: Integer): HCkZipEntry; stdcall;
  TCkZip_GetEntryByName = function (objHandle: HCkZip; entryName: PWideChar): HCkZipEntry; stdcall;
  TCkZip_GetExclusions = function (objHandle: HCkZip): HCkStringArray; stdcall;
  TCkZip_GetExeConfigParam = function (objHandle: HCkZip; name: PWideChar; outStr: HCkString): wordbool; stdcall;
  TCkZip__getExeConfigParam = function (objHandle: HCkZip; name: PWideChar): PWideChar; stdcall;
  TCkZip_GetMaxUncompressedSize = function (objHandle: HCkZip; outStr: HCkString): wordbool; stdcall;
  TCkZip__getMaxUncompressedSize = function (objHandle: HCkZip): PWideChar; stdcall;
  TCkZip_IsNoCompressExtension = function (objHandle: HCkZip; fileExtension: PWideChar): wordbool; stdcall;
  TCkZip_IsPasswordProtected = function (objHandle: HCkZip; zipFilename: PWideChar): wordbool; stdcall;
  TCkZip_LoadTaskCaller = function (objHandle: HCkZip; task: HCkTask): wordbool; stdcall;
  TCkZip_NewZip = function (objHandle: HCkZip; zipFilePath: PWideChar): wordbool; stdcall;
  TCkZip_OpenBd = function (objHandle: HCkZip; binData: HCkBinData): wordbool; stdcall;
  TCkZip_OpenEmbedded = function (objHandle: HCkZip; exeFilename: PWideChar; resourceName: PWideChar): wordbool; stdcall;
  TCkZip_OpenFromByteData = function (objHandle: HCkZip; byteData: HCkByteData): wordbool; stdcall;
  TCkZip_OpenFromMemory = function (objHandle: HCkZip; inData: HCkByteData): wordbool; stdcall;
  TCkZip_OpenZip = function (objHandle: HCkZip; zipPath: PWideChar): wordbool; stdcall;
  TCkZip_OpenZipAsync = function (objHandle: HCkZip; zipPath: PWideChar): HCkTask; stdcall;
  TCkZip_QuickAppend = function (objHandle: HCkZip; ZipFileName: PWideChar): wordbool; stdcall;
  TCkZip_QuickAppendAsync = function (objHandle: HCkZip; ZipFileName: PWideChar): HCkTask; stdcall;
  TCkZip_RemoveNoCompressExtension = procedure (objHandle: HCkZip; fileExtension: PWideChar); stdcall;
  TCkZip_SetCompressionLevel = procedure (objHandle: HCkZip; level: Integer); stdcall;
  TCkZip_SetExclusions = procedure (objHandle: HCkZip; excludePatterns: HCkStringArray); stdcall;
  TCkZip_SetExeConfigParam = procedure (objHandle: HCkZip; paramName: PWideChar; paramValue: PWideChar); stdcall;
  TCkZip_SetPassword = procedure (objHandle: HCkZip; password: PWideChar); stdcall;
  TCkZip_Unzip = function (objHandle: HCkZip; dirPath: PWideChar): Integer; stdcall;
  TCkZip_UnzipAsync = function (objHandle: HCkZip; dirPath: PWideChar): HCkTask; stdcall;
  TCkZip_UnzipInto = function (objHandle: HCkZip; dirPath: PWideChar): Integer; stdcall;
  TCkZip_UnzipIntoAsync = function (objHandle: HCkZip; dirPath: PWideChar): HCkTask; stdcall;
  TCkZip_UnzipMatching = function (objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): Integer; stdcall;
  TCkZip_UnzipMatchingAsync = function (objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): HCkTask; stdcall;
  TCkZip_UnzipMatchingInto = function (objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): Integer; stdcall;
  TCkZip_UnzipMatchingIntoAsync = function (objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): HCkTask; stdcall;
  TCkZip_UnzipNewer = function (objHandle: HCkZip; dirPath: PWideChar): Integer; stdcall;
  TCkZip_UnzipNewerAsync = function (objHandle: HCkZip; dirPath: PWideChar): HCkTask; stdcall;
  TCkZip_VerifyPassword = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_WriteBd = function (objHandle: HCkZip; binData: HCkBinData): wordbool; stdcall;
  TCkZip_WriteBdAsync = function (objHandle: HCkZip; binData: HCkBinData): HCkTask; stdcall;
  TCkZip_WriteExe = function (objHandle: HCkZip; exeFilename: PWideChar): wordbool; stdcall;
  TCkZip_WriteExeAsync = function (objHandle: HCkZip; exeFilename: PWideChar): HCkTask; stdcall;
  TCkZip_WriteExe2 = function (objHandle: HCkZip; exePath: PWideChar; destExePath: PWideChar; bAesEncrypt: wordbool; keyLength: Integer; password: PWideChar): wordbool; stdcall;
  TCkZip_WriteExe2Async = function (objHandle: HCkZip; exePath: PWideChar; destExePath: PWideChar; bAesEncrypt: wordbool; keyLength: Integer; password: PWideChar): HCkTask; stdcall;
  TCkZip_WriteExeToMemory = function (objHandle: HCkZip; outData: HCkByteData): wordbool; stdcall;
  TCkZip_WriteExeToMemoryAsync = function (objHandle: HCkZip): HCkTask; stdcall;
  TCkZip_WriteToMemory = function (objHandle: HCkZip; outData: HCkByteData): wordbool; stdcall;
  TCkZip_WriteToMemoryAsync = function (objHandle: HCkZip): HCkTask; stdcall;
  TCkZip_WriteZip = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_WriteZipAsync = function (objHandle: HCkZip): HCkTask; stdcall;
  TCkZip_WriteZipAndClose = function (objHandle: HCkZip): wordbool; stdcall;
  TCkZip_WriteZipAndCloseAsync = function (objHandle: HCkZip): HCkTask; stdcall;

var
  _fkt_ptr_arr:   array [0..208] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkZip_Create : HCkZip;
begin
  result := TCkZip_Create(_map(0, 'CkZip_Create'));
end;

procedure CkZip_Dispose (handle: HCkZip);
begin
  TCkZip_Dispose(_map(1, 'CkZip_Dispose'))
    (handle);
end;


procedure CkZip_SetAbortCheck (objHandle: HCkZip; fn: TZipAbortCheck);
begin
    TCkZip_SetAbortCheck(_map(2, 'CkZip_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkZip_SetProgressInfo (objHandle: HCkZip; fn: TZipProgressInfo);
begin
    TCkZip_SetProgressInfo(_map(3, 'CkZip_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkZip_SetPercentDone (objHandle: HCkZip; fn: TZipPercentDone);
begin
    TCkZip_SetPercentDone(_map(4, 'CkZip_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkZip_SetTaskCompleted (objHandle: HCkZip; fn: TZipTaskCompleted);
begin
    TCkZip_SetTaskCompleted(_map(5, 'CkZip_SetTaskCompleted'))
    (objHandle, fn);
end;

function CkZip_getAbortCurrent (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getAbortCurrent(_map(6, 'CkZip_getAbortCurrent'))
    (objHandle);
end;

procedure CkZip_putAbortCurrent (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putAbortCurrent(_map(7, 'CkZip_putAbortCurrent'))
    (objHandle, newPropVal);
end;

procedure CkZip_getAppendFromDir (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getAppendFromDir(_map(8, 'CkZip_getAppendFromDir'))
    (objHandle, outPropVal);
end;

procedure CkZip_putAppendFromDir (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putAppendFromDir(_map(9, 'CkZip_putAppendFromDir'))
    (objHandle, newPropVal);
end;

function CkZip__appendFromDir (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__appendFromDir(_map(10, 'CkZip__appendFromDir'))
    (objHandle);
end;

procedure CkZip_getAutoRun (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getAutoRun(_map(11, 'CkZip_getAutoRun'))
    (objHandle, outPropVal);
end;

procedure CkZip_putAutoRun (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putAutoRun(_map(12, 'CkZip_putAutoRun'))
    (objHandle, newPropVal);
end;

function CkZip__autoRun (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__autoRun(_map(13, 'CkZip__autoRun'))
    (objHandle);
end;

procedure CkZip_getAutoRunParams (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getAutoRunParams(_map(14, 'CkZip_getAutoRunParams'))
    (objHandle, outPropVal);
end;

procedure CkZip_putAutoRunParams (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putAutoRunParams(_map(15, 'CkZip_putAutoRunParams'))
    (objHandle, newPropVal);
end;

function CkZip__autoRunParams (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__autoRunParams(_map(16, 'CkZip__autoRunParams'))
    (objHandle);
end;

function CkZip_getAutoTemp (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getAutoTemp(_map(17, 'CkZip_getAutoTemp'))
    (objHandle);
end;

procedure CkZip_putAutoTemp (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putAutoTemp(_map(18, 'CkZip_putAutoTemp'))
    (objHandle, newPropVal);
end;

function CkZip_getCaseSensitive (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getCaseSensitive(_map(19, 'CkZip_getCaseSensitive'))
    (objHandle);
end;

procedure CkZip_putCaseSensitive (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putCaseSensitive(_map(20, 'CkZip_putCaseSensitive'))
    (objHandle, newPropVal);
end;

function CkZip_getClearArchiveAttribute (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getClearArchiveAttribute(_map(21, 'CkZip_getClearArchiveAttribute'))
    (objHandle);
end;

procedure CkZip_putClearArchiveAttribute (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putClearArchiveAttribute(_map(22, 'CkZip_putClearArchiveAttribute'))
    (objHandle, newPropVal);
end;

function CkZip_getClearReadOnlyAttr (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getClearReadOnlyAttr(_map(23, 'CkZip_getClearReadOnlyAttr'))
    (objHandle);
end;

procedure CkZip_putClearReadOnlyAttr (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putClearReadOnlyAttr(_map(24, 'CkZip_putClearReadOnlyAttr'))
    (objHandle, newPropVal);
end;

procedure CkZip_getComment (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getComment(_map(25, 'CkZip_getComment'))
    (objHandle, outPropVal);
end;

procedure CkZip_putComment (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putComment(_map(26, 'CkZip_putComment'))
    (objHandle, newPropVal);
end;

function CkZip__comment (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__comment(_map(27, 'CkZip__comment'))
    (objHandle);
end;

procedure CkZip_getDebugLogFilePath (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getDebugLogFilePath(_map(28, 'CkZip_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkZip_putDebugLogFilePath (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putDebugLogFilePath(_map(29, 'CkZip_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkZip__debugLogFilePath (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__debugLogFilePath(_map(30, 'CkZip__debugLogFilePath'))
    (objHandle);
end;

procedure CkZip_getDecryptPassword (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getDecryptPassword(_map(31, 'CkZip_getDecryptPassword'))
    (objHandle, outPropVal);
end;

procedure CkZip_putDecryptPassword (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putDecryptPassword(_map(32, 'CkZip_putDecryptPassword'))
    (objHandle, newPropVal);
end;

function CkZip__decryptPassword (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__decryptPassword(_map(33, 'CkZip__decryptPassword'))
    (objHandle);
end;

function CkZip_getDiscardPaths (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getDiscardPaths(_map(34, 'CkZip_getDiscardPaths'))
    (objHandle);
end;

procedure CkZip_putDiscardPaths (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putDiscardPaths(_map(35, 'CkZip_putDiscardPaths'))
    (objHandle, newPropVal);
end;

function CkZip_getEncryption (objHandle: HCkZip): Integer;
begin
    result := TCkZip_getEncryption(_map(36, 'CkZip_getEncryption'))
    (objHandle);
end;

procedure CkZip_putEncryption (objHandle: HCkZip; newPropVal: Integer);
begin
  TCkZip_putEncryption(_map(37, 'CkZip_putEncryption'))
    (objHandle, newPropVal);
end;

function CkZip_getEncryptKeyLength (objHandle: HCkZip): Integer;
begin
    result := TCkZip_getEncryptKeyLength(_map(38, 'CkZip_getEncryptKeyLength'))
    (objHandle);
end;

procedure CkZip_putEncryptKeyLength (objHandle: HCkZip; newPropVal: Integer);
begin
  TCkZip_putEncryptKeyLength(_map(39, 'CkZip_putEncryptKeyLength'))
    (objHandle, newPropVal);
end;

procedure CkZip_getEncryptPassword (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getEncryptPassword(_map(40, 'CkZip_getEncryptPassword'))
    (objHandle, outPropVal);
end;

procedure CkZip_putEncryptPassword (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putEncryptPassword(_map(41, 'CkZip_putEncryptPassword'))
    (objHandle, newPropVal);
end;

function CkZip__encryptPassword (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__encryptPassword(_map(42, 'CkZip__encryptPassword'))
    (objHandle);
end;

procedure CkZip_getExeDefaultDir (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getExeDefaultDir(_map(43, 'CkZip_getExeDefaultDir'))
    (objHandle, outPropVal);
end;

procedure CkZip_putExeDefaultDir (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putExeDefaultDir(_map(44, 'CkZip_putExeDefaultDir'))
    (objHandle, newPropVal);
end;

function CkZip__exeDefaultDir (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__exeDefaultDir(_map(45, 'CkZip__exeDefaultDir'))
    (objHandle);
end;

function CkZip_getExeFinishNotifier (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getExeFinishNotifier(_map(46, 'CkZip_getExeFinishNotifier'))
    (objHandle);
end;

procedure CkZip_putExeFinishNotifier (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putExeFinishNotifier(_map(47, 'CkZip_putExeFinishNotifier'))
    (objHandle, newPropVal);
end;

procedure CkZip_getExeIconFile (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getExeIconFile(_map(48, 'CkZip_getExeIconFile'))
    (objHandle, outPropVal);
end;

procedure CkZip_putExeIconFile (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putExeIconFile(_map(49, 'CkZip_putExeIconFile'))
    (objHandle, newPropVal);
end;

function CkZip__exeIconFile (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__exeIconFile(_map(50, 'CkZip__exeIconFile'))
    (objHandle);
end;

function CkZip_getExeNoInterface (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getExeNoInterface(_map(51, 'CkZip_getExeNoInterface'))
    (objHandle);
end;

procedure CkZip_putExeNoInterface (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putExeNoInterface(_map(52, 'CkZip_putExeNoInterface'))
    (objHandle, newPropVal);
end;

function CkZip_getExeSilentProgress (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getExeSilentProgress(_map(53, 'CkZip_getExeSilentProgress'))
    (objHandle);
end;

procedure CkZip_putExeSilentProgress (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putExeSilentProgress(_map(54, 'CkZip_putExeSilentProgress'))
    (objHandle, newPropVal);
end;

procedure CkZip_getExeTitle (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getExeTitle(_map(55, 'CkZip_getExeTitle'))
    (objHandle, outPropVal);
end;

procedure CkZip_putExeTitle (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putExeTitle(_map(56, 'CkZip_putExeTitle'))
    (objHandle, newPropVal);
end;

function CkZip__exeTitle (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__exeTitle(_map(57, 'CkZip__exeTitle'))
    (objHandle);
end;

procedure CkZip_getExeUnzipCaption (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getExeUnzipCaption(_map(58, 'CkZip_getExeUnzipCaption'))
    (objHandle, outPropVal);
end;

procedure CkZip_putExeUnzipCaption (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putExeUnzipCaption(_map(59, 'CkZip_putExeUnzipCaption'))
    (objHandle, newPropVal);
end;

function CkZip__exeUnzipCaption (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__exeUnzipCaption(_map(60, 'CkZip__exeUnzipCaption'))
    (objHandle);
end;

procedure CkZip_getExeUnzipDir (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getExeUnzipDir(_map(61, 'CkZip_getExeUnzipDir'))
    (objHandle, outPropVal);
end;

procedure CkZip_putExeUnzipDir (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putExeUnzipDir(_map(62, 'CkZip_putExeUnzipDir'))
    (objHandle, newPropVal);
end;

function CkZip__exeUnzipDir (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__exeUnzipDir(_map(63, 'CkZip__exeUnzipDir'))
    (objHandle);
end;

function CkZip_getExeWaitForSetup (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getExeWaitForSetup(_map(64, 'CkZip_getExeWaitForSetup'))
    (objHandle);
end;

procedure CkZip_putExeWaitForSetup (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putExeWaitForSetup(_map(65, 'CkZip_putExeWaitForSetup'))
    (objHandle, newPropVal);
end;

procedure CkZip_getExeXmlConfig (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getExeXmlConfig(_map(66, 'CkZip_getExeXmlConfig'))
    (objHandle, outPropVal);
end;

procedure CkZip_putExeXmlConfig (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putExeXmlConfig(_map(67, 'CkZip_putExeXmlConfig'))
    (objHandle, newPropVal);
end;

function CkZip__exeXmlConfig (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__exeXmlConfig(_map(68, 'CkZip__exeXmlConfig'))
    (objHandle);
end;

function CkZip_getFileCount (objHandle: HCkZip): Integer;
begin
    result := TCkZip_getFileCount(_map(69, 'CkZip_getFileCount'))
    (objHandle);
end;

procedure CkZip_getFileName (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getFileName(_map(70, 'CkZip_getFileName'))
    (objHandle, outPropVal);
end;

procedure CkZip_putFileName (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putFileName(_map(71, 'CkZip_putFileName'))
    (objHandle, newPropVal);
end;

function CkZip__fileName (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__fileName(_map(72, 'CkZip__fileName'))
    (objHandle);
end;

function CkZip_getHasZipFormatErrors (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getHasZipFormatErrors(_map(73, 'CkZip_getHasZipFormatErrors'))
    (objHandle);
end;

function CkZip_getHeartbeatMs (objHandle: HCkZip): Integer;
begin
    result := TCkZip_getHeartbeatMs(_map(74, 'CkZip_getHeartbeatMs'))
    (objHandle);
end;

procedure CkZip_putHeartbeatMs (objHandle: HCkZip; newPropVal: Integer);
begin
  TCkZip_putHeartbeatMs(_map(75, 'CkZip_putHeartbeatMs'))
    (objHandle, newPropVal);
end;

function CkZip_getIgnoreAccessDenied (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getIgnoreAccessDenied(_map(76, 'CkZip_getIgnoreAccessDenied'))
    (objHandle);
end;

procedure CkZip_putIgnoreAccessDenied (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putIgnoreAccessDenied(_map(77, 'CkZip_putIgnoreAccessDenied'))
    (objHandle, newPropVal);
end;

procedure CkZip_getLastErrorHtml (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getLastErrorHtml(_map(78, 'CkZip_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkZip__lastErrorHtml (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__lastErrorHtml(_map(79, 'CkZip__lastErrorHtml'))
    (objHandle);
end;

procedure CkZip_getLastErrorText (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getLastErrorText(_map(80, 'CkZip_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkZip__lastErrorText (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__lastErrorText(_map(81, 'CkZip__lastErrorText'))
    (objHandle);
end;

procedure CkZip_getLastErrorXml (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getLastErrorXml(_map(82, 'CkZip_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkZip__lastErrorXml (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__lastErrorXml(_map(83, 'CkZip__lastErrorXml'))
    (objHandle);
end;

function CkZip_getLastMethodSuccess (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getLastMethodSuccess(_map(84, 'CkZip_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkZip_putLastMethodSuccess (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putLastMethodSuccess(_map(85, 'CkZip_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

procedure CkZip_getMaxDate (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getMaxDate(_map(86, 'CkZip_getMaxDate'))
    (objHandle, outPropVal);
end;

procedure CkZip_putMaxDate (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putMaxDate(_map(87, 'CkZip_putMaxDate'))
    (objHandle, newPropVal);
end;

function CkZip__maxDate (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__maxDate(_map(88, 'CkZip__maxDate'))
    (objHandle);
end;

function CkZip_getMaxUncompressSize (objHandle: HCkZip): LongWord;
begin
    result := TCkZip_getMaxUncompressSize(_map(89, 'CkZip_getMaxUncompressSize'))
    (objHandle);
end;

procedure CkZip_putMaxUncompressSize (objHandle: HCkZip; newPropVal: LongWord);
begin
  TCkZip_putMaxUncompressSize(_map(90, 'CkZip_putMaxUncompressSize'))
    (objHandle, newPropVal);
end;

procedure CkZip_getMinDate (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getMinDate(_map(91, 'CkZip_getMinDate'))
    (objHandle, outPropVal);
end;

procedure CkZip_putMinDate (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putMinDate(_map(92, 'CkZip_putMinDate'))
    (objHandle, newPropVal);
end;

function CkZip__minDate (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__minDate(_map(93, 'CkZip__minDate'))
    (objHandle);
end;

function CkZip_getNumEntries (objHandle: HCkZip): Integer;
begin
    result := TCkZip_getNumEntries(_map(94, 'CkZip_getNumEntries'))
    (objHandle);
end;

function CkZip_getOemCodePage (objHandle: HCkZip): Integer;
begin
    result := TCkZip_getOemCodePage(_map(95, 'CkZip_getOemCodePage'))
    (objHandle);
end;

procedure CkZip_putOemCodePage (objHandle: HCkZip; newPropVal: Integer);
begin
  TCkZip_putOemCodePage(_map(96, 'CkZip_putOemCodePage'))
    (objHandle, newPropVal);
end;

function CkZip_getOverwriteExisting (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getOverwriteExisting(_map(97, 'CkZip_getOverwriteExisting'))
    (objHandle);
end;

procedure CkZip_putOverwriteExisting (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putOverwriteExisting(_map(98, 'CkZip_putOverwriteExisting'))
    (objHandle, newPropVal);
end;

function CkZip_getPasswordProtect (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getPasswordProtect(_map(99, 'CkZip_getPasswordProtect'))
    (objHandle);
end;

procedure CkZip_putPasswordProtect (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putPasswordProtect(_map(100, 'CkZip_putPasswordProtect'))
    (objHandle, newPropVal);
end;

procedure CkZip_getPathPrefix (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getPathPrefix(_map(101, 'CkZip_getPathPrefix'))
    (objHandle, outPropVal);
end;

procedure CkZip_putPathPrefix (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putPathPrefix(_map(102, 'CkZip_putPathPrefix'))
    (objHandle, newPropVal);
end;

function CkZip__pathPrefix (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__pathPrefix(_map(103, 'CkZip__pathPrefix'))
    (objHandle);
end;

function CkZip_getPercentDoneScale (objHandle: HCkZip): Integer;
begin
    result := TCkZip_getPercentDoneScale(_map(104, 'CkZip_getPercentDoneScale'))
    (objHandle);
end;

procedure CkZip_putPercentDoneScale (objHandle: HCkZip; newPropVal: Integer);
begin
  TCkZip_putPercentDoneScale(_map(105, 'CkZip_putPercentDoneScale'))
    (objHandle, newPropVal);
end;

procedure CkZip_getPwdProtCharset (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getPwdProtCharset(_map(106, 'CkZip_getPwdProtCharset'))
    (objHandle, outPropVal);
end;

procedure CkZip_putPwdProtCharset (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putPwdProtCharset(_map(107, 'CkZip_putPwdProtCharset'))
    (objHandle, newPropVal);
end;

function CkZip__pwdProtCharset (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__pwdProtCharset(_map(108, 'CkZip__pwdProtCharset'))
    (objHandle);
end;

procedure CkZip_getTempDir (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getTempDir(_map(109, 'CkZip_getTempDir'))
    (objHandle, outPropVal);
end;

procedure CkZip_putTempDir (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putTempDir(_map(110, 'CkZip_putTempDir'))
    (objHandle, newPropVal);
end;

function CkZip__tempDir (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__tempDir(_map(111, 'CkZip__tempDir'))
    (objHandle);
end;

procedure CkZip_getUncommonOptions (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getUncommonOptions(_map(112, 'CkZip_getUncommonOptions'))
    (objHandle, outPropVal);
end;

procedure CkZip_putUncommonOptions (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putUncommonOptions(_map(113, 'CkZip_putUncommonOptions'))
    (objHandle, newPropVal);
end;

function CkZip__uncommonOptions (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__uncommonOptions(_map(114, 'CkZip__uncommonOptions'))
    (objHandle);
end;

function CkZip_getVerboseLogging (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getVerboseLogging(_map(115, 'CkZip_getVerboseLogging'))
    (objHandle);
end;

procedure CkZip_putVerboseLogging (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putVerboseLogging(_map(116, 'CkZip_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkZip_getVersion (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getVersion(_map(117, 'CkZip_getVersion'))
    (objHandle, outPropVal);
end;

function CkZip__version (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__version(_map(118, 'CkZip__version'))
    (objHandle);
end;

function CkZip_getZipx (objHandle: HCkZip): wordbool;
begin
    result := TCkZip_getZipx(_map(119, 'CkZip_getZipx'))
    (objHandle);
end;

procedure CkZip_putZipx (objHandle: HCkZip; newPropVal: wordbool);
begin
  TCkZip_putZipx(_map(120, 'CkZip_putZipx'))
    (objHandle, newPropVal);
end;

procedure CkZip_getZipxDefaultAlg (objHandle: HCkZip; outPropVal: HCkString);
begin
  TCkZip_getZipxDefaultAlg(_map(121, 'CkZip_getZipxDefaultAlg'))
    (objHandle, outPropVal);
end;

procedure CkZip_putZipxDefaultAlg (objHandle: HCkZip; newPropVal: PWideChar);
begin
  TCkZip_putZipxDefaultAlg(_map(122, 'CkZip_putZipxDefaultAlg'))
    (objHandle, newPropVal);
end;

function CkZip__zipxDefaultAlg (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__zipxDefaultAlg(_map(123, 'CkZip__zipxDefaultAlg'))
    (objHandle);
end;

function CkZip_AddBd (objHandle: HCkZip; pathInZip: PWideChar; bd: HCkBinData): wordbool;
begin
  result := TCkZip_AddBd(_map(124, 'CkZip_AddBd'))
    (objHandle, pathInZip, bd);
end;

function CkZip_AddEmpty (objHandle: HCkZip; isDir: wordbool; pathInZip: PWideChar): wordbool;
begin
  result := TCkZip_AddEmpty(_map(125, 'CkZip_AddEmpty'))
    (objHandle, isDir, pathInZip);
end;

function CkZip_AddEncoded (objHandle: HCkZip; pathInZip: PWideChar; encoding: PWideChar; data: PWideChar): wordbool;
begin
  result := TCkZip_AddEncoded(_map(126, 'CkZip_AddEncoded'))
    (objHandle, pathInZip, encoding, data);
end;

function CkZip_AddFile (objHandle: HCkZip; localPath: PWideChar; saveExtraPath: wordbool): wordbool;
begin
  result := TCkZip_AddFile(_map(127, 'CkZip_AddFile'))
    (objHandle, localPath, saveExtraPath);
end;

procedure CkZip_AddNoCompressExtension (objHandle: HCkZip; fileExtension: PWideChar);
begin
  TCkZip_AddNoCompressExtension(_map(128, 'CkZip_AddNoCompressExtension'))
    (objHandle, fileExtension);
end;

function CkZip_AddSb (objHandle: HCkZip; pathInZip: PWideChar; sb: HCkStringBuilder; charset: PWideChar): wordbool;
begin
  result := TCkZip_AddSb(_map(129, 'CkZip_AddSb'))
    (objHandle, pathInZip, sb, charset);
end;

function CkZip_AddString (objHandle: HCkZip; pathInZip: PWideChar; content: PWideChar; charset: PWideChar): wordbool;
begin
  result := TCkZip_AddString(_map(130, 'CkZip_AddString'))
    (objHandle, pathInZip, content, charset);
end;

function CkZip_AppendBd (objHandle: HCkZip; pathInZip: PWideChar; byteData: HCkBinData): HCkZipEntry;
begin
  result := TCkZip_AppendBd(_map(131, 'CkZip_AppendBd'))
    (objHandle, pathInZip, byteData);
end;

function CkZip_AppendData (objHandle: HCkZip; fileName: PWideChar; inData: HCkByteData): HCkZipEntry;
begin
  result := TCkZip_AppendData(_map(132, 'CkZip_AppendData'))
    (objHandle, fileName, inData);
end;

function CkZip_AppendDataEncoded (objHandle: HCkZip; filename: PWideChar; encoding: PWideChar; data: PWideChar): HCkZipEntry;
begin
  result := TCkZip_AppendDataEncoded(_map(133, 'CkZip_AppendDataEncoded'))
    (objHandle, filename, encoding, data);
end;

function CkZip_AppendFiles (objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool): wordbool;
begin
  result := TCkZip_AppendFiles(_map(134, 'CkZip_AppendFiles'))
    (objHandle, filePattern, recurse);
end;

function CkZip_AppendFilesAsync (objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool): HCkTask;
begin
  result := TCkZip_AppendFilesAsync(_map(135, 'CkZip_AppendFilesAsync'))
    (objHandle, filePattern, recurse);
end;

function CkZip_AppendFilesEx (objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool; saveExtraPath: wordbool; archiveOnly: wordbool; includeHidden: wordbool; includeSystem: wordbool): wordbool;
begin
  result := TCkZip_AppendFilesEx(_map(136, 'CkZip_AppendFilesEx'))
    (objHandle, filePattern, recurse, saveExtraPath, archiveOnly, includeHidden, includeSystem);
end;

function CkZip_AppendFilesExAsync (objHandle: HCkZip; filePattern: PWideChar; recurse: wordbool; saveExtraPath: wordbool; archiveOnly: wordbool; includeHidden: wordbool; includeSystem: wordbool): HCkTask;
begin
  result := TCkZip_AppendFilesExAsync(_map(137, 'CkZip_AppendFilesExAsync'))
    (objHandle, filePattern, recurse, saveExtraPath, archiveOnly, includeHidden, includeSystem);
end;

function CkZip_AppendNew (objHandle: HCkZip; fileName: PWideChar): HCkZipEntry;
begin
  result := TCkZip_AppendNew(_map(138, 'CkZip_AppendNew'))
    (objHandle, fileName);
end;

function CkZip_AppendNewDir (objHandle: HCkZip; dirName: PWideChar): HCkZipEntry;
begin
  result := TCkZip_AppendNewDir(_map(139, 'CkZip_AppendNewDir'))
    (objHandle, dirName);
end;

function CkZip_AppendOneFileOrDir (objHandle: HCkZip; fileOrDirPath: PWideChar; saveExtraPath: wordbool): wordbool;
begin
  result := TCkZip_AppendOneFileOrDir(_map(140, 'CkZip_AppendOneFileOrDir'))
    (objHandle, fileOrDirPath, saveExtraPath);
end;

function CkZip_AppendOneFileOrDirAsync (objHandle: HCkZip; fileOrDirPath: PWideChar; saveExtraPath: wordbool): HCkTask;
begin
  result := TCkZip_AppendOneFileOrDirAsync(_map(141, 'CkZip_AppendOneFileOrDirAsync'))
    (objHandle, fileOrDirPath, saveExtraPath);
end;

function CkZip_AppendSb (objHandle: HCkZip; pathInZip: PWideChar; sb: HCkStringBuilder; charset: PWideChar): wordbool;
begin
  result := TCkZip_AppendSb(_map(142, 'CkZip_AppendSb'))
    (objHandle, pathInZip, sb, charset);
end;

function CkZip_AppendString (objHandle: HCkZip; internalZipFilepath: PWideChar; textData: PWideChar): HCkZipEntry;
begin
  result := TCkZip_AppendString(_map(143, 'CkZip_AppendString'))
    (objHandle, internalZipFilepath, textData);
end;

function CkZip_AppendString2 (objHandle: HCkZip; internalZipFilepath: PWideChar; textData: PWideChar; charset: PWideChar): HCkZipEntry;
begin
  result := TCkZip_AppendString2(_map(144, 'CkZip_AppendString2'))
    (objHandle, internalZipFilepath, textData, charset);
end;

function CkZip_AppendZip (objHandle: HCkZip; zipFileName: PWideChar): wordbool;
begin
  result := TCkZip_AppendZip(_map(145, 'CkZip_AppendZip'))
    (objHandle, zipFileName);
end;

procedure CkZip_CloseZip (objHandle: HCkZip);
begin
  TCkZip_CloseZip(_map(146, 'CkZip_CloseZip'))
    (objHandle);
end;

function CkZip_DeleteEntry (objHandle: HCkZip; entry: HCkZipEntry): wordbool;
begin
  result := TCkZip_DeleteEntry(_map(147, 'CkZip_DeleteEntry'))
    (objHandle, entry);
end;

function CkZip_EntryAt (objHandle: HCkZip; index: Integer; entry: HCkZipEntry): wordbool;
begin
  result := TCkZip_EntryAt(_map(148, 'CkZip_EntryAt'))
    (objHandle, index, entry);
end;

function CkZip_EntryById (objHandle: HCkZip; id: Integer; entry: HCkZipEntry): wordbool;
begin
  result := TCkZip_EntryById(_map(149, 'CkZip_EntryById'))
    (objHandle, id, entry);
end;

function CkZip_EntryMatching (objHandle: HCkZip; pattern: PWideChar; entry: HCkZipEntry): wordbool;
begin
  result := TCkZip_EntryMatching(_map(150, 'CkZip_EntryMatching'))
    (objHandle, pattern, entry);
end;

function CkZip_EntryOf (objHandle: HCkZip; pathInZip: PWideChar; entry: HCkZipEntry): wordbool;
begin
  result := TCkZip_EntryOf(_map(151, 'CkZip_EntryOf'))
    (objHandle, pathInZip, entry);
end;

procedure CkZip_ExcludeDir (objHandle: HCkZip; dirName: PWideChar);
begin
  TCkZip_ExcludeDir(_map(152, 'CkZip_ExcludeDir'))
    (objHandle, dirName);
end;

function CkZip_ExtractExe (objHandle: HCkZip; exePath: PWideChar; dirPath: PWideChar): wordbool;
begin
  result := TCkZip_ExtractExe(_map(153, 'CkZip_ExtractExe'))
    (objHandle, exePath, dirPath);
end;

function CkZip_ExtractExeAsync (objHandle: HCkZip; exePath: PWideChar; dirPath: PWideChar): HCkTask;
begin
  result := TCkZip_ExtractExeAsync(_map(154, 'CkZip_ExtractExeAsync'))
    (objHandle, exePath, dirPath);
end;

function CkZip_FirstEntry (objHandle: HCkZip): HCkZipEntry;
begin
  result := TCkZip_FirstEntry(_map(155, 'CkZip_FirstEntry'))
    (objHandle);
end;

function CkZip_FirstMatchingEntry (objHandle: HCkZip; pattern: PWideChar): HCkZipEntry;
begin
  result := TCkZip_FirstMatchingEntry(_map(156, 'CkZip_FirstMatchingEntry'))
    (objHandle, pattern);
end;

function CkZip_GetDirectoryAsXML (objHandle: HCkZip; outStr: HCkString): wordbool;
begin
  result := TCkZip_GetDirectoryAsXML(_map(157, 'CkZip_GetDirectoryAsXML'))
    (objHandle, outStr);
end;

function CkZip__getDirectoryAsXML (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__getDirectoryAsXML(_map(158, 'CkZip__getDirectoryAsXML'))
    (objHandle);
end;

function CkZip_GetEntryByID (objHandle: HCkZip; entryID: Integer): HCkZipEntry;
begin
  result := TCkZip_GetEntryByID(_map(159, 'CkZip_GetEntryByID'))
    (objHandle, entryID);
end;

function CkZip_GetEntryByIndex (objHandle: HCkZip; index: Integer): HCkZipEntry;
begin
  result := TCkZip_GetEntryByIndex(_map(160, 'CkZip_GetEntryByIndex'))
    (objHandle, index);
end;

function CkZip_GetEntryByName (objHandle: HCkZip; entryName: PWideChar): HCkZipEntry;
begin
  result := TCkZip_GetEntryByName(_map(161, 'CkZip_GetEntryByName'))
    (objHandle, entryName);
end;

function CkZip_GetExclusions (objHandle: HCkZip): HCkStringArray;
begin
  result := TCkZip_GetExclusions(_map(162, 'CkZip_GetExclusions'))
    (objHandle);
end;

function CkZip_GetExeConfigParam (objHandle: HCkZip; name: PWideChar; outStr: HCkString): wordbool;
begin
  result := TCkZip_GetExeConfigParam(_map(163, 'CkZip_GetExeConfigParam'))
    (objHandle, name, outStr);
end;

function CkZip__getExeConfigParam (objHandle: HCkZip; name: PWideChar): PWideChar;
begin
  result := TCkZip__getExeConfigParam(_map(164, 'CkZip__getExeConfigParam'))
    (objHandle, name);
end;

function CkZip_GetMaxUncompressedSize (objHandle: HCkZip; outStr: HCkString): wordbool;
begin
  result := TCkZip_GetMaxUncompressedSize(_map(165, 'CkZip_GetMaxUncompressedSize'))
    (objHandle, outStr);
end;

function CkZip__getMaxUncompressedSize (objHandle: HCkZip): PWideChar;
begin
  result := TCkZip__getMaxUncompressedSize(_map(166, 'CkZip__getMaxUncompressedSize'))
    (objHandle);
end;

function CkZip_IsNoCompressExtension (objHandle: HCkZip; fileExtension: PWideChar): wordbool;
begin
  result := TCkZip_IsNoCompressExtension(_map(167, 'CkZip_IsNoCompressExtension'))
    (objHandle, fileExtension);
end;

function CkZip_IsPasswordProtected (objHandle: HCkZip; zipFilename: PWideChar): wordbool;
begin
  result := TCkZip_IsPasswordProtected(_map(168, 'CkZip_IsPasswordProtected'))
    (objHandle, zipFilename);
end;

function CkZip_LoadTaskCaller (objHandle: HCkZip; task: HCkTask): wordbool;
begin
  result := TCkZip_LoadTaskCaller(_map(169, 'CkZip_LoadTaskCaller'))
    (objHandle, task);
end;

function CkZip_NewZip (objHandle: HCkZip; zipFilePath: PWideChar): wordbool;
begin
  result := TCkZip_NewZip(_map(170, 'CkZip_NewZip'))
    (objHandle, zipFilePath);
end;

function CkZip_OpenBd (objHandle: HCkZip; binData: HCkBinData): wordbool;
begin
  result := TCkZip_OpenBd(_map(171, 'CkZip_OpenBd'))
    (objHandle, binData);
end;

function CkZip_OpenEmbedded (objHandle: HCkZip; exeFilename: PWideChar; resourceName: PWideChar): wordbool;
begin
  result := TCkZip_OpenEmbedded(_map(172, 'CkZip_OpenEmbedded'))
    (objHandle, exeFilename, resourceName);
end;

function CkZip_OpenFromByteData (objHandle: HCkZip; byteData: HCkByteData): wordbool;
begin
  result := TCkZip_OpenFromByteData(_map(173, 'CkZip_OpenFromByteData'))
    (objHandle, byteData);
end;

function CkZip_OpenFromMemory (objHandle: HCkZip; inData: HCkByteData): wordbool;
begin
  result := TCkZip_OpenFromMemory(_map(174, 'CkZip_OpenFromMemory'))
    (objHandle, inData);
end;

function CkZip_OpenZip (objHandle: HCkZip; zipPath: PWideChar): wordbool;
begin
  result := TCkZip_OpenZip(_map(175, 'CkZip_OpenZip'))
    (objHandle, zipPath);
end;

function CkZip_OpenZipAsync (objHandle: HCkZip; zipPath: PWideChar): HCkTask;
begin
  result := TCkZip_OpenZipAsync(_map(176, 'CkZip_OpenZipAsync'))
    (objHandle, zipPath);
end;

function CkZip_QuickAppend (objHandle: HCkZip; ZipFileName: PWideChar): wordbool;
begin
  result := TCkZip_QuickAppend(_map(177, 'CkZip_QuickAppend'))
    (objHandle, ZipFileName);
end;

function CkZip_QuickAppendAsync (objHandle: HCkZip; ZipFileName: PWideChar): HCkTask;
begin
  result := TCkZip_QuickAppendAsync(_map(178, 'CkZip_QuickAppendAsync'))
    (objHandle, ZipFileName);
end;

procedure CkZip_RemoveNoCompressExtension (objHandle: HCkZip; fileExtension: PWideChar);
begin
  TCkZip_RemoveNoCompressExtension(_map(179, 'CkZip_RemoveNoCompressExtension'))
    (objHandle, fileExtension);
end;

procedure CkZip_SetCompressionLevel (objHandle: HCkZip; level: Integer);
begin
  TCkZip_SetCompressionLevel(_map(180, 'CkZip_SetCompressionLevel'))
    (objHandle, level);
end;

procedure CkZip_SetExclusions (objHandle: HCkZip; excludePatterns: HCkStringArray);
begin
  TCkZip_SetExclusions(_map(181, 'CkZip_SetExclusions'))
    (objHandle, excludePatterns);
end;

procedure CkZip_SetExeConfigParam (objHandle: HCkZip; paramName: PWideChar; paramValue: PWideChar);
begin
  TCkZip_SetExeConfigParam(_map(182, 'CkZip_SetExeConfigParam'))
    (objHandle, paramName, paramValue);
end;

procedure CkZip_SetPassword (objHandle: HCkZip; password: PWideChar);
begin
  TCkZip_SetPassword(_map(183, 'CkZip_SetPassword'))
    (objHandle, password);
end;

function CkZip_Unzip (objHandle: HCkZip; dirPath: PWideChar): Integer;
begin
  result := TCkZip_Unzip(_map(184, 'CkZip_Unzip'))
    (objHandle, dirPath);
end;

function CkZip_UnzipAsync (objHandle: HCkZip; dirPath: PWideChar): HCkTask;
begin
  result := TCkZip_UnzipAsync(_map(185, 'CkZip_UnzipAsync'))
    (objHandle, dirPath);
end;

function CkZip_UnzipInto (objHandle: HCkZip; dirPath: PWideChar): Integer;
begin
  result := TCkZip_UnzipInto(_map(186, 'CkZip_UnzipInto'))
    (objHandle, dirPath);
end;

function CkZip_UnzipIntoAsync (objHandle: HCkZip; dirPath: PWideChar): HCkTask;
begin
  result := TCkZip_UnzipIntoAsync(_map(187, 'CkZip_UnzipIntoAsync'))
    (objHandle, dirPath);
end;

function CkZip_UnzipMatching (objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): Integer;
begin
  result := TCkZip_UnzipMatching(_map(188, 'CkZip_UnzipMatching'))
    (objHandle, dirPath, pattern, verbose);
end;

function CkZip_UnzipMatchingAsync (objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): HCkTask;
begin
  result := TCkZip_UnzipMatchingAsync(_map(189, 'CkZip_UnzipMatchingAsync'))
    (objHandle, dirPath, pattern, verbose);
end;

function CkZip_UnzipMatchingInto (objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): Integer;
begin
  result := TCkZip_UnzipMatchingInto(_map(190, 'CkZip_UnzipMatchingInto'))
    (objHandle, dirPath, pattern, verbose);
end;

function CkZip_UnzipMatchingIntoAsync (objHandle: HCkZip; dirPath: PWideChar; pattern: PWideChar; verbose: wordbool): HCkTask;
begin
  result := TCkZip_UnzipMatchingIntoAsync(_map(191, 'CkZip_UnzipMatchingIntoAsync'))
    (objHandle, dirPath, pattern, verbose);
end;

function CkZip_UnzipNewer (objHandle: HCkZip; dirPath: PWideChar): Integer;
begin
  result := TCkZip_UnzipNewer(_map(192, 'CkZip_UnzipNewer'))
    (objHandle, dirPath);
end;

function CkZip_UnzipNewerAsync (objHandle: HCkZip; dirPath: PWideChar): HCkTask;
begin
  result := TCkZip_UnzipNewerAsync(_map(193, 'CkZip_UnzipNewerAsync'))
    (objHandle, dirPath);
end;

function CkZip_VerifyPassword (objHandle: HCkZip): wordbool;
begin
  result := TCkZip_VerifyPassword(_map(194, 'CkZip_VerifyPassword'))
    (objHandle);
end;

function CkZip_WriteBd (objHandle: HCkZip; binData: HCkBinData): wordbool;
begin
  result := TCkZip_WriteBd(_map(195, 'CkZip_WriteBd'))
    (objHandle, binData);
end;

function CkZip_WriteBdAsync (objHandle: HCkZip; binData: HCkBinData): HCkTask;
begin
  result := TCkZip_WriteBdAsync(_map(196, 'CkZip_WriteBdAsync'))
    (objHandle, binData);
end;

function CkZip_WriteExe (objHandle: HCkZip; exeFilename: PWideChar): wordbool;
begin
  result := TCkZip_WriteExe(_map(197, 'CkZip_WriteExe'))
    (objHandle, exeFilename);
end;

function CkZip_WriteExeAsync (objHandle: HCkZip; exeFilename: PWideChar): HCkTask;
begin
  result := TCkZip_WriteExeAsync(_map(198, 'CkZip_WriteExeAsync'))
    (objHandle, exeFilename);
end;

function CkZip_WriteExe2 (objHandle: HCkZip; exePath: PWideChar; destExePath: PWideChar; bAesEncrypt: wordbool; keyLength: Integer; password: PWideChar): wordbool;
begin
  result := TCkZip_WriteExe2(_map(199, 'CkZip_WriteExe2'))
    (objHandle, exePath, destExePath, bAesEncrypt, keyLength, password);
end;

function CkZip_WriteExe2Async (objHandle: HCkZip; exePath: PWideChar; destExePath: PWideChar; bAesEncrypt: wordbool; keyLength: Integer; password: PWideChar): HCkTask;
begin
  result := TCkZip_WriteExe2Async(_map(200, 'CkZip_WriteExe2Async'))
    (objHandle, exePath, destExePath, bAesEncrypt, keyLength, password);
end;

function CkZip_WriteExeToMemory (objHandle: HCkZip; outData: HCkByteData): wordbool;
begin
  result := TCkZip_WriteExeToMemory(_map(201, 'CkZip_WriteExeToMemory'))
    (objHandle, outData);
end;

function CkZip_WriteExeToMemoryAsync (objHandle: HCkZip): HCkTask;
begin
  result := TCkZip_WriteExeToMemoryAsync(_map(202, 'CkZip_WriteExeToMemoryAsync'))
    (objHandle);
end;

function CkZip_WriteToMemory (objHandle: HCkZip; outData: HCkByteData): wordbool;
begin
  result := TCkZip_WriteToMemory(_map(203, 'CkZip_WriteToMemory'))
    (objHandle, outData);
end;

function CkZip_WriteToMemoryAsync (objHandle: HCkZip): HCkTask;
begin
  result := TCkZip_WriteToMemoryAsync(_map(204, 'CkZip_WriteToMemoryAsync'))
    (objHandle);
end;

function CkZip_WriteZip (objHandle: HCkZip): wordbool;
begin
  result := TCkZip_WriteZip(_map(205, 'CkZip_WriteZip'))
    (objHandle);
end;

function CkZip_WriteZipAsync (objHandle: HCkZip): HCkTask;
begin
  result := TCkZip_WriteZipAsync(_map(206, 'CkZip_WriteZipAsync'))
    (objHandle);
end;

function CkZip_WriteZipAndClose (objHandle: HCkZip): wordbool;
begin
  result := TCkZip_WriteZipAndClose(_map(207, 'CkZip_WriteZipAndClose'))
    (objHandle);
end;

function CkZip_WriteZipAndCloseAsync (objHandle: HCkZip): HCkTask;
begin
  result := TCkZip_WriteZipAndCloseAsync(_map(208, 'CkZip_WriteZipAndCloseAsync'))
    (objHandle);
end;

end.
