unit ZipCrc;

interface

type

HCkBinData = Pointer;
HCkByteData = Pointer;
HCkString = Pointer;
HCkStringBuilder = Pointer;
HCkTask = Pointer;
HCkZipCrc = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TZipCrcAbortCheck = function(): Integer; cdecl;
TZipCrcProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TZipCrcPercentDone = function(pctDone: Integer): Integer; cdecl;
TZipCrcTaskCompleted = procedure(task: HCkTask); cdecl;


function CkZipCrc_Create: HCkZipCrc;  stdcall;
procedure CkZipCrc_Dispose(handle: HCkZipCrc); stdcall;

procedure CkZipCrc_SetAbortCheck(objHandle: HCkZipCrc; fn: TZipCrcAbortCheck) stdcall;
procedure CkZipCrc_SetProgressInfo(objHandle: HCkZipCrc; fn: TZipCrcProgressInfo) stdcall;
procedure CkZipCrc_SetPercentDone(objHandle: HCkZipCrc; fn: TZipCrcPercentDone) stdcall;
procedure CkZipCrc_SetTaskCompleted(objHandle: HCkZipCrc; fn: TZipCrcTaskCompleted) stdcall;
procedure CkZipCrc_getDebugLogFilePath(objHandle: HCkZipCrc; outPropVal: HCkString);
procedure CkZipCrc_putDebugLogFilePath(objHandle: HCkZipCrc; newPropVal: PWideChar);
function CkZipCrc__debugLogFilePath(objHandle: HCkZipCrc): PWideChar;
procedure CkZipCrc_getLastErrorHtml(objHandle: HCkZipCrc; outPropVal: HCkString);
function CkZipCrc__lastErrorHtml(objHandle: HCkZipCrc): PWideChar;
procedure CkZipCrc_getLastErrorText(objHandle: HCkZipCrc; outPropVal: HCkString);
function CkZipCrc__lastErrorText(objHandle: HCkZipCrc): PWideChar;
procedure CkZipCrc_getLastErrorXml(objHandle: HCkZipCrc; outPropVal: HCkString);
function CkZipCrc__lastErrorXml(objHandle: HCkZipCrc): PWideChar;
function CkZipCrc_getLastMethodSuccess(objHandle: HCkZipCrc): wordbool;
procedure CkZipCrc_putLastMethodSuccess(objHandle: HCkZipCrc; newPropVal: wordbool);
function CkZipCrc_getVerboseLogging(objHandle: HCkZipCrc): wordbool;
procedure CkZipCrc_putVerboseLogging(objHandle: HCkZipCrc; newPropVal: wordbool);
procedure CkZipCrc_getVersion(objHandle: HCkZipCrc; outPropVal: HCkString);
function CkZipCrc__version(objHandle: HCkZipCrc): PWideChar;
procedure CkZipCrc_BeginStream(objHandle: HCkZipCrc);
function CkZipCrc_CalculateCrc(objHandle: HCkZipCrc; data: HCkByteData): LongWord;
function CkZipCrc_CrcBd(objHandle: HCkZipCrc; bd: HCkBinData): LongWord;
function CkZipCrc_CrcSb(objHandle: HCkZipCrc; sb: HCkStringBuilder; charset: PWideChar): LongWord;
function CkZipCrc_CrcString(objHandle: HCkZipCrc; str: PWideChar; charset: PWideChar): LongWord;
function CkZipCrc_EndStream(objHandle: HCkZipCrc): LongWord;
function CkZipCrc_FileCrc(objHandle: HCkZipCrc; path: PWideChar): LongWord;
function CkZipCrc_FileCrcAsync(objHandle: HCkZipCrc; path: PWideChar): HCkTask;
function CkZipCrc_LoadTaskCaller(objHandle: HCkZipCrc; task: HCkTask): wordbool;
procedure CkZipCrc_MoreData(objHandle: HCkZipCrc; data: HCkByteData);
function CkZipCrc_ToHex(objHandle: HCkZipCrc; crc: LongWord; outStr: HCkString): wordbool;
function CkZipCrc__toHex(objHandle: HCkZipCrc; crc: LongWord): PWideChar;
implementation

      // Delphi7
{$IF Compilerversion = 15}
      uses Windows, SysUtils, ckDllLoader;
{$ELSE}
      uses Winapi.Windows, System.SysUtils, ckDllLoader;
{$IFEND}

Type
  TCkZipCrc_Create = function : HCkZipCrc; stdcall;
  TCkZipCrc_Dispose = procedure (handle: HCkZipCrc); stdcall;
  TCkZipCrc_SetAbortCheck = procedure (objHandle: HCkZipCrc; fn: TZipCrcAbortCheck); stdcall;
  TCkZipCrc_SetProgressInfo = procedure (objHandle: HCkZipCrc; fn: TZipCrcProgressInfo); stdcall;
  TCkZipCrc_SetPercentDone = procedure (objHandle: HCkZipCrc; fn: TZipCrcPercentDone); stdcall;
  TCkZipCrc_SetTaskCompleted = procedure (objHandle: HCkZipCrc; fn: TZipCrcTaskCompleted); stdcall;
  TCkZipCrc_getDebugLogFilePath = procedure (objHandle: HCkZipCrc; outPropVal: HCkString); stdcall;
  TCkZipCrc_putDebugLogFilePath = procedure (objHandle: HCkZipCrc; newPropVal: PWideChar); stdcall;
  TCkZipCrc__debugLogFilePath = function (objHandle: HCkZipCrc): PWideChar; stdcall;
  TCkZipCrc_getLastErrorHtml = procedure (objHandle: HCkZipCrc; outPropVal: HCkString); stdcall;
  TCkZipCrc__lastErrorHtml = function (objHandle: HCkZipCrc): PWideChar; stdcall;
  TCkZipCrc_getLastErrorText = procedure (objHandle: HCkZipCrc; outPropVal: HCkString); stdcall;
  TCkZipCrc__lastErrorText = function (objHandle: HCkZipCrc): PWideChar; stdcall;
  TCkZipCrc_getLastErrorXml = procedure (objHandle: HCkZipCrc; outPropVal: HCkString); stdcall;
  TCkZipCrc__lastErrorXml = function (objHandle: HCkZipCrc): PWideChar; stdcall;
  TCkZipCrc_getLastMethodSuccess = function (objHandle: HCkZipCrc): wordbool; stdcall;
  TCkZipCrc_putLastMethodSuccess = procedure (objHandle: HCkZipCrc; newPropVal: wordbool); stdcall;
  TCkZipCrc_getVerboseLogging = function (objHandle: HCkZipCrc): wordbool; stdcall;
  TCkZipCrc_putVerboseLogging = procedure (objHandle: HCkZipCrc; newPropVal: wordbool); stdcall;
  TCkZipCrc_getVersion = procedure (objHandle: HCkZipCrc; outPropVal: HCkString); stdcall;
  TCkZipCrc__version = function (objHandle: HCkZipCrc): PWideChar; stdcall;
  TCkZipCrc_BeginStream = procedure (objHandle: HCkZipCrc); stdcall;
  TCkZipCrc_CalculateCrc = function (objHandle: HCkZipCrc; data: HCkByteData): LongWord; stdcall;
  TCkZipCrc_CrcBd = function (objHandle: HCkZipCrc; bd: HCkBinData): LongWord; stdcall;
  TCkZipCrc_CrcSb = function (objHandle: HCkZipCrc; sb: HCkStringBuilder; charset: PWideChar): LongWord; stdcall;
  TCkZipCrc_CrcString = function (objHandle: HCkZipCrc; str: PWideChar; charset: PWideChar): LongWord; stdcall;
  TCkZipCrc_EndStream = function (objHandle: HCkZipCrc): LongWord; stdcall;
  TCkZipCrc_FileCrc = function (objHandle: HCkZipCrc; path: PWideChar): LongWord; stdcall;
  TCkZipCrc_FileCrcAsync = function (objHandle: HCkZipCrc; path: PWideChar): HCkTask; stdcall;
  TCkZipCrc_LoadTaskCaller = function (objHandle: HCkZipCrc; task: HCkTask): wordbool; stdcall;
  TCkZipCrc_MoreData = procedure (objHandle: HCkZipCrc; data: HCkByteData); stdcall;
  TCkZipCrc_ToHex = function (objHandle: HCkZipCrc; crc: LongWord; outStr: HCkString): wordbool; stdcall;
  TCkZipCrc__toHex = function (objHandle: HCkZipCrc; crc: LongWord): PWideChar; stdcall;

var
  _fkt_ptr_arr:   array [0..32] of Pointer;

function _Map( k:Integer; n:String):Pointer;
begin
  Result:=  _fkt_ptr_arr[k];
  if Result = nil then begin
    Chilkat_GetProcedureAddress(Result, n);
    _fkt_ptr_arr[k]:=   Result;
  end;
end;


function CkZipCrc_Create : HCkZipCrc;
begin
  result := TCkZipCrc_Create(_map(0, 'CkZipCrc_Create'));
end;

procedure CkZipCrc_Dispose (handle: HCkZipCrc);
begin
  TCkZipCrc_Dispose(_map(1, 'CkZipCrc_Dispose'))
    (handle);
end;


procedure CkZipCrc_SetAbortCheck (objHandle: HCkZipCrc; fn: TZipCrcAbortCheck);
begin
    TCkZipCrc_SetAbortCheck(_map(2, 'CkZipCrc_SetAbortCheck'))
    (objHandle, fn);
end;
procedure CkZipCrc_SetProgressInfo (objHandle: HCkZipCrc; fn: TZipCrcProgressInfo);
begin
    TCkZipCrc_SetProgressInfo(_map(3, 'CkZipCrc_SetProgressInfo'))
    (objHandle, fn);
end;
procedure CkZipCrc_SetPercentDone (objHandle: HCkZipCrc; fn: TZipCrcPercentDone);
begin
    TCkZipCrc_SetPercentDone(_map(4, 'CkZipCrc_SetPercentDone'))
    (objHandle, fn);
end;
procedure CkZipCrc_SetTaskCompleted (objHandle: HCkZipCrc; fn: TZipCrcTaskCompleted);
begin
    TCkZipCrc_SetTaskCompleted(_map(5, 'CkZipCrc_SetTaskCompleted'))
    (objHandle, fn);
end;

procedure CkZipCrc_getDebugLogFilePath (objHandle: HCkZipCrc; outPropVal: HCkString);
begin
  TCkZipCrc_getDebugLogFilePath(_map(6, 'CkZipCrc_getDebugLogFilePath'))
    (objHandle, outPropVal);
end;

procedure CkZipCrc_putDebugLogFilePath (objHandle: HCkZipCrc; newPropVal: PWideChar);
begin
  TCkZipCrc_putDebugLogFilePath(_map(7, 'CkZipCrc_putDebugLogFilePath'))
    (objHandle, newPropVal);
end;

function CkZipCrc__debugLogFilePath (objHandle: HCkZipCrc): PWideChar;
begin
  result := TCkZipCrc__debugLogFilePath(_map(8, 'CkZipCrc__debugLogFilePath'))
    (objHandle);
end;

procedure CkZipCrc_getLastErrorHtml (objHandle: HCkZipCrc; outPropVal: HCkString);
begin
  TCkZipCrc_getLastErrorHtml(_map(9, 'CkZipCrc_getLastErrorHtml'))
    (objHandle, outPropVal);
end;

function CkZipCrc__lastErrorHtml (objHandle: HCkZipCrc): PWideChar;
begin
  result := TCkZipCrc__lastErrorHtml(_map(10, 'CkZipCrc__lastErrorHtml'))
    (objHandle);
end;

procedure CkZipCrc_getLastErrorText (objHandle: HCkZipCrc; outPropVal: HCkString);
begin
  TCkZipCrc_getLastErrorText(_map(11, 'CkZipCrc_getLastErrorText'))
    (objHandle, outPropVal);
end;

function CkZipCrc__lastErrorText (objHandle: HCkZipCrc): PWideChar;
begin
  result := TCkZipCrc__lastErrorText(_map(12, 'CkZipCrc__lastErrorText'))
    (objHandle);
end;

procedure CkZipCrc_getLastErrorXml (objHandle: HCkZipCrc; outPropVal: HCkString);
begin
  TCkZipCrc_getLastErrorXml(_map(13, 'CkZipCrc_getLastErrorXml'))
    (objHandle, outPropVal);
end;

function CkZipCrc__lastErrorXml (objHandle: HCkZipCrc): PWideChar;
begin
  result := TCkZipCrc__lastErrorXml(_map(14, 'CkZipCrc__lastErrorXml'))
    (objHandle);
end;

function CkZipCrc_getLastMethodSuccess (objHandle: HCkZipCrc): wordbool;
begin
    result := TCkZipCrc_getLastMethodSuccess(_map(15, 'CkZipCrc_getLastMethodSuccess'))
    (objHandle);
end;

procedure CkZipCrc_putLastMethodSuccess (objHandle: HCkZipCrc; newPropVal: wordbool);
begin
  TCkZipCrc_putLastMethodSuccess(_map(16, 'CkZipCrc_putLastMethodSuccess'))
    (objHandle, newPropVal);
end;

function CkZipCrc_getVerboseLogging (objHandle: HCkZipCrc): wordbool;
begin
    result := TCkZipCrc_getVerboseLogging(_map(17, 'CkZipCrc_getVerboseLogging'))
    (objHandle);
end;

procedure CkZipCrc_putVerboseLogging (objHandle: HCkZipCrc; newPropVal: wordbool);
begin
  TCkZipCrc_putVerboseLogging(_map(18, 'CkZipCrc_putVerboseLogging'))
    (objHandle, newPropVal);
end;

procedure CkZipCrc_getVersion (objHandle: HCkZipCrc; outPropVal: HCkString);
begin
  TCkZipCrc_getVersion(_map(19, 'CkZipCrc_getVersion'))
    (objHandle, outPropVal);
end;

function CkZipCrc__version (objHandle: HCkZipCrc): PWideChar;
begin
  result := TCkZipCrc__version(_map(20, 'CkZipCrc__version'))
    (objHandle);
end;

procedure CkZipCrc_BeginStream (objHandle: HCkZipCrc);
begin
  TCkZipCrc_BeginStream(_map(21, 'CkZipCrc_BeginStream'))
    (objHandle);
end;

function CkZipCrc_CalculateCrc (objHandle: HCkZipCrc; data: HCkByteData): LongWord;
begin
  result := TCkZipCrc_CalculateCrc(_map(22, 'CkZipCrc_CalculateCrc'))
    (objHandle, data);
end;

function CkZipCrc_CrcBd (objHandle: HCkZipCrc; bd: HCkBinData): LongWord;
begin
  result := TCkZipCrc_CrcBd(_map(23, 'CkZipCrc_CrcBd'))
    (objHandle, bd);
end;

function CkZipCrc_CrcSb (objHandle: HCkZipCrc; sb: HCkStringBuilder; charset: PWideChar): LongWord;
begin
  result := TCkZipCrc_CrcSb(_map(24, 'CkZipCrc_CrcSb'))
    (objHandle, sb, charset);
end;

function CkZipCrc_CrcString (objHandle: HCkZipCrc; str: PWideChar; charset: PWideChar): LongWord;
begin
  result := TCkZipCrc_CrcString(_map(25, 'CkZipCrc_CrcString'))
    (objHandle, str, charset);
end;

function CkZipCrc_EndStream (objHandle: HCkZipCrc): LongWord;
begin
  result := TCkZipCrc_EndStream(_map(26, 'CkZipCrc_EndStream'))
    (objHandle);
end;

function CkZipCrc_FileCrc (objHandle: HCkZipCrc; path: PWideChar): LongWord;
begin
  result := TCkZipCrc_FileCrc(_map(27, 'CkZipCrc_FileCrc'))
    (objHandle, path);
end;

function CkZipCrc_FileCrcAsync (objHandle: HCkZipCrc; path: PWideChar): HCkTask;
begin
  result := TCkZipCrc_FileCrcAsync(_map(28, 'CkZipCrc_FileCrcAsync'))
    (objHandle, path);
end;

function CkZipCrc_LoadTaskCaller (objHandle: HCkZipCrc; task: HCkTask): wordbool;
begin
  result := TCkZipCrc_LoadTaskCaller(_map(29, 'CkZipCrc_LoadTaskCaller'))
    (objHandle, task);
end;

procedure CkZipCrc_MoreData (objHandle: HCkZipCrc; data: HCkByteData);
begin
  TCkZipCrc_MoreData(_map(30, 'CkZipCrc_MoreData'))
    (objHandle, data);
end;

function CkZipCrc_ToHex (objHandle: HCkZipCrc; crc: LongWord; outStr: HCkString): wordbool;
begin
  result := TCkZipCrc_ToHex(_map(31, 'CkZipCrc_ToHex'))
    (objHandle, crc, outStr);
end;

function CkZipCrc__toHex (objHandle: HCkZipCrc; crc: LongWord): PWideChar;
begin
  result := TCkZipCrc__toHex(_map(32, 'CkZipCrc__toHex'))
    (objHandle, crc);
end;

end.
