unit Secrets;

interface

type

HCkJsonObject = Pointer;
HCkString = Pointer;
HCkSecrets = Pointer;
HCkStringBuilder = Pointer;
HCkTask = Pointer;
HCkBinData = Pointer;


// Note: The callback functions use the cdecl calling convention, while all other functions use stdcall.
TSecretsAbortCheck = function(): Integer; cdecl;
TSecretsProgressInfo = procedure(name: PWideChar; value: PWideChar); cdecl;
TSecretsPercentDone = function(pctDone: Integer): Integer; cdecl;
TSecretsTaskCompleted = procedure(task: HCkTask); cdecl;


function CkSecrets_Create: HCkSecrets; stdcall;
procedure CkSecrets_Dispose(handle: HCkSecrets); stdcall;

procedure CkSecrets_SetAbortCheck(objHandle: HCkSecrets; fn: TSecretsAbortCheck) stdcall;
procedure CkSecrets_SetProgressInfo(objHandle: HCkSecrets; fn: TSecretsProgressInfo) stdcall;
procedure CkSecrets_SetPercentDone(objHandle: HCkSecrets; fn: TSecretsPercentDone) stdcall;
procedure CkSecrets_SetTaskCompleted(objHandle: HCkSecrets; fn: TSecretsTaskCompleted) stdcall;
function CkSecrets_getAutoSplit(objHandle: HCkSecrets): wordbool; stdcall;

procedure CkSecrets_putAutoSplit(objHandle: HCkSecrets; newPropVal: wordbool); stdcall;

function CkSecrets_getCompression(objHandle: HCkSecrets): wordbool; stdcall;

procedure CkSecrets_putCompression(objHandle: HCkSecrets; newPropVal: wordbool); stdcall;

procedure CkSecrets_getDebugLogFilePath(objHandle: HCkSecrets; outPropVal: HCkString); stdcall;

procedure CkSecrets_putDebugLogFilePath(objHandle: HCkSecrets; newPropVal: PWideChar); stdcall;

function CkSecrets__debugLogFilePath(objHandle: HCkSecrets): PWideChar; stdcall;

procedure CkSecrets_getLastErrorHtml(objHandle: HCkSecrets; outPropVal: HCkString); stdcall;

function CkSecrets__lastErrorHtml(objHandle: HCkSecrets): PWideChar; stdcall;

procedure CkSecrets_getLastErrorText(objHandle: HCkSecrets; outPropVal: HCkString); stdcall;

function CkSecrets__lastErrorText(objHandle: HCkSecrets): PWideChar; stdcall;

procedure CkSecrets_getLastErrorXml(objHandle: HCkSecrets; outPropVal: HCkString); stdcall;

function CkSecrets__lastErrorXml(objHandle: HCkSecrets): PWideChar; stdcall;

function CkSecrets_getLastMethodSuccess(objHandle: HCkSecrets): wordbool; stdcall;

procedure CkSecrets_putLastMethodSuccess(objHandle: HCkSecrets; newPropVal: wordbool); stdcall;

procedure CkSecrets_getLocation(objHandle: HCkSecrets; outPropVal: HCkString); stdcall;

procedure CkSecrets_putLocation(objHandle: HCkSecrets; newPropVal: PWideChar); stdcall;

function CkSecrets__location(objHandle: HCkSecrets): PWideChar; stdcall;

procedure CkSecrets_getUncommonOptions(objHandle: HCkSecrets; outPropVal: HCkString); stdcall;

procedure CkSecrets_putUncommonOptions(objHandle: HCkSecrets; newPropVal: PWideChar); stdcall;

function CkSecrets__uncommonOptions(objHandle: HCkSecrets): PWideChar; stdcall;

function CkSecrets_getVerboseLogging(objHandle: HCkSecrets): wordbool; stdcall;

procedure CkSecrets_putVerboseLogging(objHandle: HCkSecrets; newPropVal: wordbool); stdcall;

procedure CkSecrets_getVersion(objHandle: HCkSecrets; outPropVal: HCkString); stdcall;

function CkSecrets__version(objHandle: HCkSecrets): PWideChar; stdcall;

function CkSecrets_DeleteSecret(objHandle: HCkSecrets; jsonId: HCkJsonObject): wordbool; stdcall;

function CkSecrets_DeleteSecretAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject): HCkTask; stdcall;

function CkSecrets_GetSecretBd(objHandle: HCkSecrets; jsonId: HCkJsonObject; bd: HCkBinData): wordbool; stdcall;

function CkSecrets_GetSecretBdAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; bd: HCkBinData): HCkTask; stdcall;

function CkSecrets_GetSecretJson(objHandle: HCkSecrets; jsonId: HCkJsonObject; jsonOut: HCkJsonObject): wordbool; stdcall;

function CkSecrets_GetSecretJsonAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask; stdcall;

function CkSecrets_GetSecretSb(objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): wordbool; stdcall;

function CkSecrets_GetSecretSbAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): HCkTask; stdcall;

function CkSecrets_GetSecretStr(objHandle: HCkSecrets; jsonId: HCkJsonObject; outStr: HCkString): wordbool; stdcall;

function CkSecrets__getSecretStr(objHandle: HCkSecrets; jsonId: HCkJsonObject): PWideChar; stdcall;

function CkSecrets_GetSecretStrAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject): HCkTask; stdcall;

function CkSecrets_ListSecrets(objHandle: HCkSecrets; json: HCkJsonObject; jsonOut: HCkJsonObject): wordbool; stdcall;

function CkSecrets_ListSecretsAsync(objHandle: HCkSecrets; json: HCkJsonObject; jsonOut: HCkJsonObject): HCkTask; stdcall;

function CkSecrets_SetBootstrapSecret(objHandle: HCkSecrets; jsonId: HCkJsonObject; secretContent: HCkSecrets): wordbool; stdcall;

function CkSecrets_UpdateSecretBd(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkBinData): wordbool; stdcall;

function CkSecrets_UpdateSecretBdAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkBinData): HCkTask; stdcall;

function CkSecrets_UpdateSecretJson(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkJsonObject): wordbool; stdcall;

function CkSecrets_UpdateSecretJsonAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: HCkJsonObject): HCkTask; stdcall;

function CkSecrets_UpdateSecretSb(objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): wordbool; stdcall;

function CkSecrets_UpdateSecretSbAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; sb: HCkStringBuilder): HCkTask; stdcall;

function CkSecrets_UpdateSecretStr(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: PWideChar): wordbool; stdcall;

function CkSecrets_UpdateSecretStrAsync(objHandle: HCkSecrets; jsonId: HCkJsonObject; secret: PWideChar): HCkTask; stdcall;

implementation

{$Include chilkatDllPath.inc}

function CkSecrets_Create; external DLLName;
procedure CkSecrets_Dispose; external DLLName;

procedure CkSecrets_SetAbortCheck; external DLLName;
procedure CkSecrets_SetProgressInfo; external DLLName;
procedure CkSecrets_SetPercentDone; external DLLName;
procedure CkSecrets_SetTaskCompleted; external DLLName;
function CkSecrets_getAutoSplit; external DLLName;
procedure CkSecrets_putAutoSplit; external DLLName;
function CkSecrets_getCompression; external DLLName;
procedure CkSecrets_putCompression; external DLLName;
procedure CkSecrets_getDebugLogFilePath; external DLLName;
procedure CkSecrets_putDebugLogFilePath; external DLLName;
function CkSecrets__debugLogFilePath; external DLLName;
procedure CkSecrets_getLastErrorHtml; external DLLName;
function CkSecrets__lastErrorHtml; external DLLName;
procedure CkSecrets_getLastErrorText; external DLLName;
function CkSecrets__lastErrorText; external DLLName;
procedure CkSecrets_getLastErrorXml; external DLLName;
function CkSecrets__lastErrorXml; external DLLName;
function CkSecrets_getLastMethodSuccess; external DLLName;
procedure CkSecrets_putLastMethodSuccess; external DLLName;
procedure CkSecrets_getLocation; external DLLName;
procedure CkSecrets_putLocation; external DLLName;
function CkSecrets__location; external DLLName;
procedure CkSecrets_getUncommonOptions; external DLLName;
procedure CkSecrets_putUncommonOptions; external DLLName;
function CkSecrets__uncommonOptions; external DLLName;
function CkSecrets_getVerboseLogging; external DLLName;
procedure CkSecrets_putVerboseLogging; external DLLName;
procedure CkSecrets_getVersion; external DLLName;
function CkSecrets__version; external DLLName;
function CkSecrets_DeleteSecret; external DLLName;
function CkSecrets_DeleteSecretAsync; external DLLName;
function CkSecrets_GetSecretBd; external DLLName;
function CkSecrets_GetSecretBdAsync; external DLLName;
function CkSecrets_GetSecretJson; external DLLName;
function CkSecrets_GetSecretJsonAsync; external DLLName;
function CkSecrets_GetSecretSb; external DLLName;
function CkSecrets_GetSecretSbAsync; external DLLName;
function CkSecrets_GetSecretStr; external DLLName;
function CkSecrets__getSecretStr; external DLLName;
function CkSecrets_GetSecretStrAsync; external DLLName;
function CkSecrets_ListSecrets; external DLLName;
function CkSecrets_ListSecretsAsync; external DLLName;
function CkSecrets_SetBootstrapSecret; external DLLName;
function CkSecrets_UpdateSecretBd; external DLLName;
function CkSecrets_UpdateSecretBdAsync; external DLLName;
function CkSecrets_UpdateSecretJson; external DLLName;
function CkSecrets_UpdateSecretJsonAsync; external DLLName;
function CkSecrets_UpdateSecretSb; external DLLName;
function CkSecrets_UpdateSecretSbAsync; external DLLName;
function CkSecrets_UpdateSecretStr; external DLLName;
function CkSecrets_UpdateSecretStrAsync; external DLLName;



end.
