// Chilkat Objective-C header.
// This is a generated header file for Chilkat version 11.3.0

// Generic/internal class name =  Pkcs11
// Wrapped Chilkat C++ class name =  CkPkcs11

@class CkoJsonObject;
@class CkoPublicKey;
@class CkoCert;
@class CkoPrivateKey;
@class CkoSshKey;


@interface CkoPkcs11 : NSObject {

	@private
		void *m_obj;

}

- (id)init;
- (void)dealloc;
- (void)dispose;
- (NSString *)stringWithUtf8: (const char *)s;
- (void *)CppImplObj;
- (void)setCppImplObj: (void *)pObj;

- (void)clearCppImplObj;

@property (nonatomic, copy) NSString *DebugLogFilePath;
@property (nonatomic, readonly, copy) NSString *LastErrorHtml;
@property (nonatomic, readonly, copy) NSString *LastErrorText;
@property (nonatomic, readonly, copy) NSString *LastErrorXml;
@property (nonatomic) BOOL LastMethodSuccess;
@property (nonatomic, readonly, copy) NSNumber *NumCerts;
@property (nonatomic, copy) NSString *SharedLibPath;
@property (nonatomic, copy) NSString *SigContextPin;
@property (nonatomic, copy) NSString *UncommonOptions;
@property (nonatomic) BOOL VerboseLogging;
@property (nonatomic, readonly, copy) NSString *Version;
// method: CloseSession
- (BOOL)CloseSession;
// method: CreatePkcs11Object
- (NSNumber *)CreatePkcs11Object: (CkoJsonObject *)attrs;
// method: DestroyObject
- (BOOL)DestroyObject: (NSNumber *)hObject;
// method: Discover
- (BOOL)Discover: (BOOL)onlyTokensPresent 
	json: (CkoJsonObject *)json;
// method: ExportPublicKey
- (BOOL)ExportPublicKey: (NSNumber *)keyHandle 
	pubKey: (CkoPublicKey *)pubKey;
// method: FindAllCerts
- (BOOL)FindAllCerts;
// method: FindAllKeys
- (BOOL)FindAllKeys: (NSString *)keyClass 
	json: (CkoJsonObject *)json;
// method: FindCert
- (BOOL)FindCert: (NSString *)certPart 
	partValue: (NSString *)partValue 
	cert: (CkoCert *)cert;
// method: FindObject
- (NSNumber *)FindObject: (CkoJsonObject *)jsonTemplate;
// method: GenEcKey
- (BOOL)GenEcKey: (CkoJsonObject *)publicAttrs 
	privateAttrs: (CkoJsonObject *)privateAttrs 
	jsonOut: (CkoJsonObject *)jsonOut 
	pubKey: (CkoPublicKey *)pubKey;
// method: GenRsaKey
- (BOOL)GenRsaKey: (CkoJsonObject *)publicAttrs 
	privateAttrs: (CkoJsonObject *)privateAttrs 
	jsonOut: (CkoJsonObject *)jsonOut 
	pubKey: (CkoPublicKey *)pubKey;
// method: GenSecretKey
- (NSNumber *)GenSecretKey: (NSString *)keyType 
	jsonTemplate: (CkoJsonObject *)jsonTemplate;
// method: GetCert
- (BOOL)GetCert: (NSNumber *)index 
	cert: (CkoCert *)cert;
// method: ImportPrivateKey
- (NSNumber *)ImportPrivateKey: (CkoPrivateKey *)privKey 
	jsonTemplate: (CkoJsonObject *)jsonTemplate;
// method: ImportSshKey
- (NSNumber *)ImportSshKey: (CkoSshKey *)sshKey 
	jsonTemplate: (CkoJsonObject *)jsonTemplate;
// method: Initialize
- (BOOL)Initialize;
// method: InitPin
- (BOOL)InitPin: (NSString *)pin;
// method: InitToken
- (BOOL)InitToken: (NSNumber *)slotId 
	pin: (NSString *)pin 
	tokenLabel: (NSString *)tokenLabel;
// method: Login
- (BOOL)Login: (NSNumber *)userType 
	pin: (NSString *)pin;
// method: Logout
- (BOOL)Logout;
// method: OpenSession
- (BOOL)OpenSession: (NSNumber *)slotId 
	readWrite: (BOOL)readWrite;
// method: QuickSession
- (BOOL)QuickSession: (NSNumber *)userType 
	pin: (NSString *)pin;
// method: SetPin
- (BOOL)SetPin: (NSString *)oldPin 
	newPin: (NSString *)newPin;

@end
