// CkCertChainU.h: interface for the CkCertChainU class.
//
//////////////////////////////////////////////////////////////////////

// This header is generated for Chilkat 11.3.0

#ifndef _CkCertChainU_H
#define _CkCertChainU_H
	
#include "../../Cpp/include/chilkatDefs.h"
#include "../../Cpp/include/CkString.h"
#include "CkUtf16Base.h"

class CkCertU;
class CkTrustedRootsU;
class CkJsonObjectU;



#if !defined(__sun__) && !defined(__sun)
#pragma pack (push, 8)
#endif
 

// CLASS: CkCertChainU
class CK_VISIBLE_PUBLIC CkCertChainU  : public CkUtf16Base
{
	

	private:
	
	// Don't allow assignment or copying these objects.
	CkCertChainU(const CkCertChainU &);
	CkCertChainU &operator=(const CkCertChainU &);

    public:
	CkCertChainU(void);
	virtual ~CkCertChainU(void);

	

	static CkCertChainU *createNew(void);
	

	
	void CK_VISIBLE_PRIVATE inject(void *impl);

	// May be called when finished with the object to free/dispose of any
	// internal resources held by the object. 
	void dispose(void);

	

	// BEGIN PUBLIC INTERFACE

	// ----------------------
	// Properties
	// ----------------------
	// The number of certificates in the chain. The end-user subscriber certificate is
	// at index 0. This is the certificate most removed from the trusted root.
	// Intermediate certificates are at indices 1 to NumCerts - 2. The trusted root (or
	// self-signed certificate) is at index NumCerts - 1.
	int get_NumCerts(void);

	// Returns the number of certificates in the chain that have expired.
	int get_NumExpiredCerts(void);

	// true if this certificate chain extends all the way to the root certificate.
	// The root certificate is either a trusted CA root or a self-signed certificate.
	// In both cases, the issuer of a root certificate is itself.
	bool get_ReachesRoot(void);

	// Can be set to a comma separated list of keywords to specify uncommon options.
	// The current uncommon options are:
	//     * PkiPathV1.ExcludeRoot Exclude the root certificate in the X509PKIPathv1
	//     method.
	void get_UncommonOptions(CkString &str);
	// Can be set to a comma separated list of keywords to specify uncommon options.
	// The current uncommon options are:
	//     * PkiPathV1.ExcludeRoot Exclude the root certificate in the X509PKIPathv1
	//     method.
	const uint16_t *uncommonOptions(void);
	// Can be set to a comma separated list of keywords to specify uncommon options.
	// The current uncommon options are:
	//     * PkiPathV1.ExcludeRoot Exclude the root certificate in the X509PKIPathv1
	//     method.
	void put_UncommonOptions(const uint16_t *newVal);



	// ----------------------
	// Methods
	// ----------------------
	// Returns the Nth certificate of the chain into cert. The 1st certificate is at
	// index 0.
	bool CertAt(int index, CkCertU &cert);

	// Returns the Nth certificate in the chain.
	// 
	// This method is deprecated. Applications should call CertAt instead.
	// 
	// The caller is responsible for deleting the object returned by this method.
	CkCertU *GetCert(int index);

	// Returns true if the root of the certificate chain is a certificate found in
	// trustedRoots.
	bool IsRootTrusted(CkTrustedRootsU &trustedRoots);

	// Loads a certificate chain from the x5c parameter of a JWK (JSON Web Key).
	bool LoadX5C(CkJsonObjectU &jwk);

	// Verifies the certificate signatures to the root. Returns true if all
	// certificate signatures are valid.
	bool VerifyCertSignatures(void);

	// Returns the base64 representation of an X509PKIPathv1 containing the
	// certificates in this chain. This is typically used in an X.509 Binary Security
	// Token. It is a PKIPath that contains an ordered list of X.509 public
	// certificates packaged in a PKIPath. The X509PKIPathv1 token type may be used to
	// represent a certificate path. (This is sometimes used in XAdES signatures.)
	bool X509PKIPathv1(CkString &outStr);
	// Returns the base64 representation of an X509PKIPathv1 containing the
	// certificates in this chain. This is typically used in an X.509 Binary Security
	// Token. It is a PKIPath that contains an ordered list of X.509 public
	// certificates packaged in a PKIPath. The X509PKIPathv1 token type may be used to
	// represent a certificate path. (This is sometimes used in XAdES signatures.)
	const uint16_t *x509PKIPathv1(void);





	// END PUBLIC INTERFACE


};
#if !defined(__sun__) && !defined(__sun)
#pragma pack (pop)
#endif
	
#endif
