// CkJsonArrayU.h: interface for the CkJsonArrayU class.
//
//////////////////////////////////////////////////////////////////////

// This header is generated for Chilkat 11.3.0

#ifndef _CkJsonArrayU_H
#define _CkJsonArrayU_H
	
#include "../../Cpp/include/chilkatDefs.h"
#include "../../Cpp/include/CkString.h"
#include "CkUtf16Base.h"

class CkJsonObjectU;
class CkDateTimeU;
class CkDtObjU;
class CkStringBuilderU;



#if !defined(__sun__) && !defined(__sun)
#pragma pack (push, 8)
#endif
 

// CLASS: CkJsonArrayU
class CK_VISIBLE_PUBLIC CkJsonArrayU  : public CkUtf16Base
{
	

	private:
	
	// Don't allow assignment or copying these objects.
	CkJsonArrayU(const CkJsonArrayU &);
	CkJsonArrayU &operator=(const CkJsonArrayU &);

    public:
	CkJsonArrayU(void);
	virtual ~CkJsonArrayU(void);

	

	static CkJsonArrayU *createNew(void);
	

	
	void CK_VISIBLE_PRIVATE inject(void *impl);

	// May be called when finished with the object to free/dispose of any
	// internal resources held by the object. 
	void dispose(void);

	

	// BEGIN PUBLIC INTERFACE

	// ----------------------
	// Properties
	// ----------------------
	// If true then the Emit method outputs in the most compact form possible (a
	// single-line with no extra whitespace). If false, then emits with whitespace
	// and indentation to make the JSON human-readable.
	// 
	// The default value is true.
	// 
	bool get_EmitCompact(void);
	// If true then the Emit method outputs in the most compact form possible (a
	// single-line with no extra whitespace). If false, then emits with whitespace
	// and indentation to make the JSON human-readable.
	// 
	// The default value is true.
	// 
	void put_EmitCompact(bool newVal);

	// If true then the Emit method uses CRLF line-endings when emitting the
	// non-compact (pretty-print) format. If false, then bare-LF's are emitted. (The
	// compact format emits to a single line with no end-of-line characters.) Windows
	// systems traditionally use CRLF line-endings, whereas Linux, Mac OS X, and other
	// systems traditionally use bare-LF line-endings.
	// 
	// The default value is true.
	// 
	bool get_EmitCrlf(void);
	// If true then the Emit method uses CRLF line-endings when emitting the
	// non-compact (pretty-print) format. If false, then bare-LF's are emitted. (The
	// compact format emits to a single line with no end-of-line characters.) Windows
	// systems traditionally use CRLF line-endings, whereas Linux, Mac OS X, and other
	// systems traditionally use bare-LF line-endings.
	// 
	// The default value is true.
	// 
	void put_EmitCrlf(bool newVal);

	// The number of JSON values in the array.
	int get_Size(void);



	// ----------------------
	// Methods
	// ----------------------
	// Inserts a new and empty JSON array member to the position indicated by index. To
	// prepend, pass an index of 0. To append, pass an index of -1. Indexing is 0-based
	// (the 1st member is at index 0).
	bool AddArrayAt(int index);

	// Inserts a new and empty JSON array member to the position indicated by index. To
	// prepend, pass an index of 0. To append, pass an index of -1. Indexing is 0-based
	// (the 1st member is at index 0). The jarr is an output argument that references
	// the appended JSON array.
	bool AddArrayAt2(int index, CkJsonArrayU &jarr);

	// Inserts a new boolean member to the position indicated by index. To prepend, pass
	// an index of 0. To append, pass an index of -1. Indexing is 0-based (the 1st member
	// is at index 0).
	bool AddBoolAt(int index, bool value);

	// Inserts a new integer member to the position indicated by index. To prepend, pass
	// an index of 0. To append, pass an index of -1. Indexing is 0-based (the 1st member
	// is at index 0).
	bool AddIntAt(int index, int value);

	// Inserts a new null member to the position indicated by index. To prepend, pass an
	// index of 0. To append, pass an index of -1. Indexing is 0-based (the 1st member is
	// at index 0).
	bool AddNullAt(int index);

	// Inserts a new numeric member to the position indicated by index. The numericStr is an
	// integer, float, or double already converted to a string in the format desired by
	// the application. To prepend, pass an index of 0. To append, pass an index of -1.
	// Indexing is 0-based (the 1st member is at index 0).
	bool AddNumberAt(int index, const uint16_t *numericStr);

	// Inserts a new and empty JSON object member to the position indicated by index. To
	// prepend, pass an index of 0. To append, pass an index of -1. Indexing is 0-based
	// (the 1st member is at index 0).
	bool AddObjectAt(int index);

	// Inserts a new and empty JSON object member to the position indicated by index. To
	// prepend, pass an index of 0. To append, pass an index of -1. Indexing is 0-based
	// (the 1st member is at index 0). The json is an output argument that references
	// the appended JSON object.
	bool AddObjectAt2(int index, CkJsonObjectU &json);

	// Inserts a copy of a JSON object to the position indicated by index. To prepend,
	// pass an index of 0. To append, pass an index of -1. Indexing is 0-based (the 1st
	// member is at index 0).
	bool AddObjectCopyAt(int index, CkJsonObjectU &jsonObj);

	// Inserts a new string at the position indicated by index. To prepend, pass an index
	// of 0. To append, pass an index of -1. Indexing is 0-based (the 1st member is at
	// index 0).
	bool AddStringAt(int index, const uint16_t *value);

	// Inserts a new unsigned integer member to the position indicated by index. To
	// prepend, pass an index of 0. To append, pass an index of -1. Indexing is 0-based
	// (the 1st member is at index 0).
	bool AddUIntAt(int index, unsigned long value);

	// Appends the array items contained in jarr.
	bool AppendArrayItems(CkJsonArrayU &jarr);

	// Returns the JSON array found at index, where indexing starts at 0.
	// The caller is responsible for deleting the object returned by this method.
	CkJsonArrayU *ArrayAt(int index);

	// Sets jarr to reference the JSON array found at index, where indexing starts at 0.
	bool ArrayAt2(int index, CkJsonArrayU &jarr);

	// Returns the boolean value of the Nth array element. Indexing is 0-based (the 1st
	// member is at index 0).
	bool BoolAt(int index);

	// Deletes all array elements.
	void Clear(void);

	// Fills the dateTime with the date/time string located in the Nth array element.
	// Indexing is 0-based (the 1st member is at index 0). Auto-recognizes the
	// following date/time string formats: ISO-8061 Timestamp (such as
	// 2009-11-04T19:55:41Z ), RFC822 date/time format (such as Wed, 18 Apr 2018
	// 15:51:55 -0400 ), or Unix timestamp integers.
	bool DateAt(int index, CkDateTimeU &dateTime);

	// Deletes the array element at the given index. Indexing is 0-based (the 1st member
	// is at index 0).
	bool DeleteAt(int index);

	// Fills the dt with the date/time string located in the Nth array element. If
	// bLocal is true, then dt is filled with the local date/time values, otherwise
	// it is filled with the UTC/GMT values. Indexing is 0-based (the 1st member is at
	// index 0). Auto-recognizes the following date/time string formats: ISO-8061
	// Timestamp (such as 2009-11-04T19:55:41Z ), RFC822 date/time format (such as Wed,
	// 18 Apr 2018 15:51:55 -0400 ), or Unix timestamp integers.
	bool DtAt(int index, bool bLocal, CkDtObjU &dt);

	// Writes the JSON array (rooted at the caller) and returns as a string.
	// 
	// Note: To control the compact/non-compact format, and to control the LF/CRLF
	// line-endings, set the EmitCompact and EmitCrlf properties.
	// 
	bool Emit(CkString &outStr);
	// Writes the JSON array (rooted at the caller) and returns as a string.
	// 
	// Note: To control the compact/non-compact format, and to control the LF/CRLF
	// line-endings, set the EmitCompact and EmitCrlf properties.
	// 
// QT defines the macro "emit" globally.  (Good grief!)
#if defined(QT_VERSION)
#pragma push_macro("emit")
#undef emit
const uint16_t *emit(void);
#pragma pop_macro("emit")
#else
const uint16_t *emit(void);
#endif



	// Writes the JSON array to the sb.
	// 
	// Note: To control the compact/non-compact format, and to control the LF/CRLF
	// line-endings, set the EmitCompact and EmitCrlf properties.
	// 
	bool EmitSb(CkStringBuilderU &sb);

	// Return the index of the first object in the array where value of the field at
	// name matches value. name is an object member name. The value is a value pattern
	// which can use * chars to indicate zero or more of any char. If caseSensitive is false,
	// then the matching is case insenstive, otherwise it is case sensitive. Returns -1
	// if no matching string was found.
	int FindObject(const uint16_t *name, const uint16_t *value, bool caseSensitive);

	// Return the index of the first matching string in the array. The value is a value
	// pattern which can use * chars to indicate zero or more of any char. If caseSensitive is
	// false, then the matching is case insenstive, otherwise it is case sensitive.
	// Returns -1 if no matching string was found.
	int FindString(const uint16_t *value, bool caseSensitive);

	// Returns the integer value of the Nth array element. Indexing is 0-based (the 1st
	// member is at index 0).
	int IntAt(int index);

	// Returns the true if the Nth array element is null, otherwise returns false.
	// Indexing is 0-based (the 1st member is at index 0).
	bool IsNullAt(int index);

	// Loads a JSON array from a string. A JSON array must begin with a [ and end with
	// a ] .
	// 
	// Note: The Load method causes the JsonArray to detach and become it's own JSON
	// document. It should only be called on new instances of the JsonArray. See the
	// example below.
	// 
	bool Load(const uint16_t *jsonArray);

	// Loads a JSON array from a StringBuilder. A JSON array must begin with a [ and
	// end with a ] .
	// 
	// Note: The Load method causes the JsonArray to detach and become it's own JSON
	// document. It should only be called on new instances of the JsonArray. See the
	// example below.
	// 
	bool LoadSb(CkStringBuilderU &sb);

	// Returns the JSON object found at index, where indexing starts at 0.
	// The caller is responsible for deleting the object returned by this method.
	CkJsonObjectU *ObjectAt(int index);

	// Sets jsonObj to reference the JSON object found at index, where indexing starts at
	// 0.
	bool ObjectAt2(int index, CkJsonObjectU &jsonObj);

	// Sets the boolean value of the Nth array element. Indexing is 0-based (the 1st
	// member is at index 0).
	bool SetBoolAt(int index, bool value);

	// Sets the integer value of the Nth array element. Indexing is 0-based (the 1st
	// member is at index 0).
	bool SetIntAt(int index, int value);

	// Sets the Nth array element to the value of null. Indexing is 0-based (the 1st
	// member is at index 0).
	bool SetNullAt(int index);

	// Sets the numeric value of the Nth array element. The value is an integer, float,
	// or double already converted to a string in the format desired by the
	// application. Indexing is 0-based (the 1st member is at index 0).
	bool SetNumberAt(int index, const uint16_t *value);

	// Sets the string value of the Nth array element. Indexing is 0-based (the 1st
	// member is at index 0).
	bool SetStringAt(int index, const uint16_t *value);

	// Sets the unsigned integer value of the Nth array element. Indexing is 0-based
	// (the 1st member is at index 0).
	bool SetUIntAt(int index, unsigned long value);

	// Returns the string value of the Nth array element. Indexing is 0-based (the 1st
	// member is at index 0).
	bool StringAt(int index, CkString &outStr);
	// Returns the string value of the Nth array element. Indexing is 0-based (the 1st
	// member is at index 0).
	const uint16_t *stringAt(int index);

	// Swaps the items at positions index1 and index2.
	bool Swap(int index1, int index2);

	// Returns the type of data at the given index. Possible return values are:
	//     1. string
	//     2. number
	//     3. object
	//     4. array
	//     5. boolean
	//     6. null
	// Returns -1 if no member exists at the given index.
	int TypeAt(int index);

	// Returns the unsigned integer value of the Nth array element. Indexing is 0-based
	// (the 1st member is at index 0).
	unsigned long UIntAt(int index);





	// END PUBLIC INTERFACE


};
#if !defined(__sun__) && !defined(__sun)
#pragma pack (pop)
#endif
	
#endif
