// Chilkat Objective-C header.
// This is a generated header file for Chilkat version 11.3.0

// Generic/internal class name =  CertStore
// Wrapped Chilkat C++ class name =  CkCertStore

@class CkoCert;
@class CkoJsonObject;
@class CkoBinData;


@interface CkoCertStore : NSObject {

	@private
		void *m_obj;

}

- (id)init;
- (void)dealloc;
- (void)dispose;
- (NSString *)stringWithUtf8: (const char *)s;
- (void *)CppImplObj;
- (void)setCppImplObj: (void *)pObj;

- (void)clearCppImplObj;

@property (nonatomic, copy) NSString *DebugLogFilePath;
@property (nonatomic, readonly, copy) NSString *LastErrorHtml;
@property (nonatomic, readonly, copy) NSString *LastErrorText;
@property (nonatomic, readonly, copy) NSString *LastErrorXml;
@property (nonatomic) BOOL LastMethodSuccess;
@property (nonatomic, readonly, copy) NSNumber *NumCertificates;
@property (nonatomic, copy) NSString *SmartCardPin;
@property (nonatomic, copy) NSString *UncommonOptions;
@property (nonatomic) BOOL VerboseLogging;
@property (nonatomic, readonly, copy) NSString *Version;
// method: AddCertificate
- (BOOL)AddCertificate: (CkoCert *)cert;
// method: CloseCertStore
- (BOOL)CloseCertStore;
// method: FindCert
- (BOOL)FindCert: (CkoJsonObject *)json 
	cert: (CkoCert *)cert;
// method: GetCert
- (BOOL)GetCert: (NSNumber *)index 
	cert: (CkoCert *)cert;
// method: LoadPemFile
- (BOOL)LoadPemFile: (NSString *)pemPath;
// method: LoadPemStr
- (BOOL)LoadPemStr: (NSString *)pemString;
// method: LoadPfxBd
- (BOOL)LoadPfxBd: (CkoBinData *)bd 
	password: (NSString *)password;
// method: LoadPfxFile
- (BOOL)LoadPfxFile: (NSString *)path 
	password: (NSString *)password;
// method: OpenCurrentUserStore
- (BOOL)OpenCurrentUserStore: (BOOL)readOnly;
// method: OpenSmartcard
- (BOOL)OpenSmartcard: (NSString *)csp;
// method: RemoveCertificate
- (BOOL)RemoveCertificate: (CkoCert *)cert;

@end
