// Chilkat Objective-C header.
// This is a generated header file for Chilkat version 11.3.0

// Generic/internal class name =  Compression
// Wrapped Chilkat C++ class name =  CkCompression

@class CkoBinData;
@class CkoTask;
@class CkoJsonObject;
@class CkoStringBuilder;
@class CkoStream;


@class CkoBaseProgress;

@interface CkoCompression : NSObject {

	@private
		void *m_eventCallback;
		void *m_obj;

}

- (id)init;
- (void)dealloc;
- (void)dispose;
- (NSString *)stringWithUtf8: (const char *)s;
- (void *)CppImplObj;
- (void)setCppImplObj: (void *)pObj;

- (void)clearCppImplObj;

// property setter: EventCallbackObject
- (void)setEventCallbackObject: (CkoBaseProgress *)eventObj;

@property (nonatomic, copy) NSString *Algorithm;
@property (nonatomic, copy) NSString *Charset;
@property (nonatomic, copy) NSString *DebugLogFilePath;
@property (nonatomic, copy) NSNumber *DeflateLevel;
@property (nonatomic, copy) NSString *EncodingMode;
@property (nonatomic) BOOL FirstChunk;
@property (nonatomic, copy) NSNumber *HeartbeatMs;
@property (nonatomic) BOOL LastChunk;
@property (nonatomic, readonly, copy) NSString *LastErrorHtml;
@property (nonatomic, readonly, copy) NSString *LastErrorText;
@property (nonatomic, readonly, copy) NSString *LastErrorXml;
@property (nonatomic) BOOL LastMethodSuccess;
@property (nonatomic, copy) NSString *UncommonOptions;
@property (nonatomic) BOOL VerboseLogging;
@property (nonatomic, readonly, copy) NSString *Version;
// method: BeginCompressBytes
- (NSData *)BeginCompressBytes: (NSData *)bData;
// method: BeginCompressBytesENC
- (NSString *)BeginCompressBytesENC: (NSData *)bData;
// method: BeginCompressString
- (NSData *)BeginCompressString: (NSString *)str;
// method: BeginCompressStringENC
- (NSString *)BeginCompressStringENC: (NSString *)str;
// method: BeginDecompressBytes
- (NSData *)BeginDecompressBytes: (NSData *)bData;
// method: BeginDecompressBytesENC
- (NSData *)BeginDecompressBytesENC: (NSString *)str;
// method: BeginDecompressString
- (NSString *)BeginDecompressString: (NSData *)bData;
// method: BeginDecompressStringENC
- (NSString *)BeginDecompressStringENC: (NSString *)str;
// method: CompressBd
- (BOOL)CompressBd: (CkoBinData *)bd;
// method: CompressBdAsync
- (CkoTask *)CompressBdAsync: (CkoBinData *)bd;
// method: CompressBd2
- (BOOL)CompressBd2: (CkoBinData *)bdIn 
	bdOut: (CkoBinData *)bdOut;
// method: CompressBd2Async
- (CkoTask *)CompressBd2Async: (CkoBinData *)bdIn 
	bdOut: (CkoBinData *)bdOut;
// method: CompressBytes
- (NSData *)CompressBytes: (NSData *)bData;
// method: CompressBytesAsync
- (CkoTask *)CompressBytesAsync: (NSData *)bData;
// method: CompressBytesENC
- (NSString *)CompressBytesENC: (NSData *)bData;
// method: CompressBytesENCAsync
- (CkoTask *)CompressBytesENCAsync: (NSData *)bData;
// method: CompressEncryptFile
- (BOOL)CompressEncryptFile: (CkoJsonObject *)cryptParams 
	srcPath: (NSString *)srcPath 
	destPath: (NSString *)destPath;
// method: CompressEncryptFileAsync
- (CkoTask *)CompressEncryptFileAsync: (CkoJsonObject *)cryptParams 
	srcPath: (NSString *)srcPath 
	destPath: (NSString *)destPath;
// method: CompressFile
- (BOOL)CompressFile: (NSString *)srcPath 
	destPath: (NSString *)destPath;
// method: CompressFileAsync
- (CkoTask *)CompressFileAsync: (NSString *)srcPath 
	destPath: (NSString *)destPath;
// method: CompressSb
- (BOOL)CompressSb: (CkoStringBuilder *)sb 
	binData: (CkoBinData *)binData;
// method: CompressSbAsync
- (CkoTask *)CompressSbAsync: (CkoStringBuilder *)sb 
	binData: (CkoBinData *)binData;
// method: CompressStr
- (BOOL)CompressStr: (NSString *)str 
	bd: (CkoBinData *)bd;
// method: CompressStrAsync
- (CkoTask *)CompressStrAsync: (NSString *)str 
	bd: (CkoBinData *)bd;
// method: CompressStream
- (BOOL)CompressStream: (CkoStream *)strm;
// method: CompressStreamAsync
- (CkoTask *)CompressStreamAsync: (CkoStream *)strm;
// method: CompressString
- (NSData *)CompressString: (NSString *)str;
// method: CompressStringAsync
- (CkoTask *)CompressStringAsync: (NSString *)str;
// method: CompressStringENC
- (NSString *)CompressStringENC: (NSString *)str;
// method: CompressStringENCAsync
- (CkoTask *)CompressStringENCAsync: (NSString *)str;
// method: DecompressBd
- (BOOL)DecompressBd: (CkoBinData *)bd;
// method: DecompressBdAsync
- (CkoTask *)DecompressBdAsync: (CkoBinData *)bd;
// method: DecompressBd2
- (BOOL)DecompressBd2: (CkoBinData *)bdIn 
	bdOut: (CkoBinData *)bdOut;
// method: DecompressBd2Async
- (CkoTask *)DecompressBd2Async: (CkoBinData *)bdIn 
	bdOut: (CkoBinData *)bdOut;
// method: DecompressBytes
- (NSData *)DecompressBytes: (NSData *)bData;
// method: DecompressBytesAsync
- (CkoTask *)DecompressBytesAsync: (NSData *)bData;
// method: DecompressBytesENC
- (NSData *)DecompressBytesENC: (NSString *)str;
// method: DecompressBytesENCAsync
- (CkoTask *)DecompressBytesENCAsync: (NSString *)str;
// method: DecompressFile
- (BOOL)DecompressFile: (NSString *)srcPath 
	destPath: (NSString *)destPath;
// method: DecompressFileAsync
- (CkoTask *)DecompressFileAsync: (NSString *)srcPath 
	destPath: (NSString *)destPath;
// method: DecompressSb
- (BOOL)DecompressSb: (CkoBinData *)binData 
	sb: (CkoStringBuilder *)sb;
// method: DecompressSbAsync
- (CkoTask *)DecompressSbAsync: (CkoBinData *)binData 
	sb: (CkoStringBuilder *)sb;
// method: DecompressStream
- (BOOL)DecompressStream: (CkoStream *)strm;
// method: DecompressStreamAsync
- (CkoTask *)DecompressStreamAsync: (CkoStream *)strm;
// method: DecompressString
- (NSString *)DecompressString: (NSData *)bData;
// method: DecompressStringENC
- (NSString *)DecompressStringENC: (NSString *)str;
// method: DecompressStringENCAsync
- (CkoTask *)DecompressStringENCAsync: (NSString *)str;
// method: DecryptDecompressFile
- (BOOL)DecryptDecompressFile: (CkoJsonObject *)cryptParams 
	srcPath: (NSString *)srcPath 
	destPath: (NSString *)destPath;
// method: DecryptDecompressFileAsync
- (CkoTask *)DecryptDecompressFileAsync: (CkoJsonObject *)cryptParams 
	srcPath: (NSString *)srcPath 
	destPath: (NSString *)destPath;
// method: EndCompressBytes
- (NSData *)EndCompressBytes;
// method: EndCompressBytesENC
- (NSString *)EndCompressBytesENC;
// method: EndCompressString
- (NSData *)EndCompressString;
// method: EndCompressStringENC
- (NSString *)EndCompressStringENC;
// method: EndDecompressBytes
- (NSData *)EndDecompressBytes;
// method: EndDecompressBytesENC
- (NSData *)EndDecompressBytesENC;
// method: EndDecompressString
- (NSString *)EndDecompressString;
// method: EndDecompressStringENC
- (NSString *)EndDecompressStringENC;
// method: LoadTaskCaller
- (BOOL)LoadTaskCaller: (CkoTask *)task;
// method: MoreCompressBytes
- (NSData *)MoreCompressBytes: (NSData *)bData;
// method: MoreCompressBytesENC
- (NSString *)MoreCompressBytesENC: (NSData *)bData;
// method: MoreCompressString
- (NSData *)MoreCompressString: (NSString *)str;
// method: MoreCompressStringENC
- (NSString *)MoreCompressStringENC: (NSString *)str;
// method: MoreDecompressBytes
- (NSData *)MoreDecompressBytes: (NSData *)bData;
// method: MoreDecompressBytesENC
- (NSData *)MoreDecompressBytesENC: (NSString *)str;
// method: MoreDecompressString
- (NSString *)MoreDecompressString: (NSData *)bData;
// method: MoreDecompressStringENC
- (NSString *)MoreDecompressStringENC: (NSString *)str;

@end
