load ./chilkat.so

set glob [new_CkGlobal]

set success [CkGlobal_UnlockBundle $glob "Anything for 30-day trial"]
if {[expr $success != 1]} then {
    puts [CkGlobal_lastErrorText $glob]
    delete_CkGlobal $glob
    exit
}

puts [CkGlobal_version $glob]

set crypt [new_CkCrypt2]

#  AES is also known as Rijndael.
CkCrypt2_put_CryptAlgorithm $crypt "aes"

#  CipherMode may be "ecb" or "cbc"
CkCrypt2_put_CipherMode $crypt "cbc"

#  KeyLength may be 128, 192, 256
CkCrypt2_put_KeyLength $crypt 256

#  The padding scheme determines the contents of the bytes
#  that are added to pad the result to a multiple of the
#  encryption algorithm's block size.  AES has a block
#  size of 16 bytes, so encrypted output is always
#  a multiple of 16.
CkCrypt2_put_PaddingScheme $crypt 0

#  EncodingMode specifies the encoding of the output for
#  encryption, and the input for decryption.
#  It may be "hex", "url", "base64", or "quoted-printable".
CkCrypt2_put_EncodingMode $crypt "hex"

#  An initialization vector is required if using CBC mode.
#  ECB mode does not use an IV.
#  The length of the IV is equal to the algorithm's block size.
#  It is NOT equal to the length of the key.
set ivHex "000102030405060708090A0B0C0D0E0F"
CkCrypt2_SetEncodedIV $crypt $ivHex "hex"

#  The secret key must equal the size of the key.  For
#  256-bit encryption, the binary secret key is 32 bytes.
#  For 128-bit encryption, the binary secret key is 16 bytes.
set keyHex "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F"
CkCrypt2_SetEncodedKey $crypt $keyHex "hex"

#  Encrypt a string...
#  The input string is 44 ANSI characters (i.e. 44 bytes), so
#  the output should be 48 bytes (a multiple of 16).
#  Because the output is a hex string, it should
#  be 96 characters long (2 chars per byte).
set encStr [CkCrypt2_encryptStringENC $crypt "The quick brown fox jumps over the lazy dog."]
puts "$encStr"

#  Now decrypt:
set decStr [CkCrypt2_decryptStringENC $crypt $encStr]
puts "$decStr"

delete_CkCrypt2 $crypt