// Chilkat Objective-C header.
// This is a generated header file for Chilkat version 11.3.0

// Generic/internal class name =  Zip
// Wrapped Chilkat C++ class name =  CkZip

@class CkoBinData;
@class CkoStringBuilder;
@class CkoZipEntry;
@class CkoTask;
@class CkoStringArray;


@class CkoZipProgress;

@interface CkoZip : NSObject {

	@private
		void *m_eventCallback;
		void *m_obj;

}

- (id)init;
- (void)dealloc;
- (void)dispose;
- (NSString *)stringWithUtf8: (const char *)s;
- (void *)CppImplObj;
- (void)setCppImplObj: (void *)pObj;

- (void)clearCppImplObj;

// property setter: EventCallbackObject
- (void)setEventCallbackObject: (CkoZipProgress *)eventObj;

@property (nonatomic) BOOL AbortCurrent;
@property (nonatomic, copy) NSString *AppendFromDir;
@property (nonatomic) BOOL CaseSensitive;
@property (nonatomic) BOOL ClearArchiveAttribute;
@property (nonatomic) BOOL ClearReadOnlyAttr;
@property (nonatomic, copy) NSString *Comment;
@property (nonatomic, copy) NSString *DebugLogFilePath;
@property (nonatomic, copy) NSString *DecryptPassword;
@property (nonatomic) BOOL DiscardPaths;
@property (nonatomic, copy) NSNumber *Encryption;
@property (nonatomic, copy) NSNumber *EncryptKeyLength;
@property (nonatomic, copy) NSString *EncryptPassword;
@property (nonatomic, readonly, copy) NSNumber *FileCount;
@property (nonatomic, copy) NSString *FileName;
@property (nonatomic, readonly) BOOL HasZipFormatErrors;
@property (nonatomic, copy) NSNumber *HeartbeatMs;
@property (nonatomic) BOOL IgnoreAccessDenied;
@property (nonatomic, readonly, copy) NSString *LastErrorHtml;
@property (nonatomic, readonly, copy) NSString *LastErrorText;
@property (nonatomic, readonly, copy) NSString *LastErrorXml;
@property (nonatomic) BOOL LastMethodSuccess;
@property (nonatomic, copy) NSString *MaxDate;
@property (nonatomic, copy) NSNumber *MaxUncompressSize;
@property (nonatomic, copy) NSString *MinDate;
@property (nonatomic, readonly, copy) NSNumber *NumEntries;
@property (nonatomic, copy) NSNumber *OemCodePage;
@property (nonatomic) BOOL OverwriteExisting;
@property (nonatomic) BOOL PasswordProtect;
@property (nonatomic, copy) NSString *PathPrefix;
@property (nonatomic, copy) NSNumber *PercentDoneScale;
@property (nonatomic, copy) NSString *PwdProtCharset;
@property (nonatomic, copy) NSString *TempDir;
@property (nonatomic, copy) NSString *UncommonOptions;
@property (nonatomic) BOOL VerboseLogging;
@property (nonatomic, readonly, copy) NSString *Version;
@property (nonatomic) BOOL Zipx;
@property (nonatomic, copy) NSString *ZipxDefaultAlg;
// method: AddBd
- (BOOL)AddBd: (NSString *)pathInZip 
	bd: (CkoBinData *)bd;
// method: AddEmpty
- (BOOL)AddEmpty: (BOOL)isDir 
	pathInZip: (NSString *)pathInZip;
// method: AddEncoded
- (BOOL)AddEncoded: (NSString *)pathInZip 
	encoding: (NSString *)encoding 
	data: (NSString *)data;
// method: AddFile
- (BOOL)AddFile: (NSString *)localPath 
	saveExtraPath: (BOOL)saveExtraPath;
// method: AddNoCompressExtension
- (void)AddNoCompressExtension: (NSString *)fileExtension;
// method: AddSb
- (BOOL)AddSb: (NSString *)pathInZip 
	sb: (CkoStringBuilder *)sb 
	charset: (NSString *)charset;
// method: AddString
- (BOOL)AddString: (NSString *)pathInZip 
	content: (NSString *)content 
	charset: (NSString *)charset;
// method: AppendBd
- (CkoZipEntry *)AppendBd: (NSString *)pathInZip 
	byteData: (CkoBinData *)byteData;
// method: AppendData
- (CkoZipEntry *)AppendData: (NSString *)pathInZip 
	data: (NSData *)data;
// method: AppendDataEncoded
- (CkoZipEntry *)AppendDataEncoded: (NSString *)filename 
	encoding: (NSString *)encoding 
	data: (NSString *)data;
// method: AppendFiles
- (BOOL)AppendFiles: (NSString *)filePattern 
	recurse: (BOOL)recurse;
// method: AppendFilesAsync
- (CkoTask *)AppendFilesAsync: (NSString *)filePattern 
	recurse: (BOOL)recurse;
// method: AppendFilesEx
- (BOOL)AppendFilesEx: (NSString *)filePattern 
	recurse: (BOOL)recurse 
	saveExtraPath: (BOOL)saveExtraPath 
	archiveOnly: (BOOL)archiveOnly 
	includeHidden: (BOOL)includeHidden 
	includeSystem: (BOOL)includeSystem;
// method: AppendFilesExAsync
- (CkoTask *)AppendFilesExAsync: (NSString *)filePattern 
	recurse: (BOOL)recurse 
	saveExtraPath: (BOOL)saveExtraPath 
	archiveOnly: (BOOL)archiveOnly 
	includeHidden: (BOOL)includeHidden 
	includeSystem: (BOOL)includeSystem;
// method: AppendNew
- (CkoZipEntry *)AppendNew: (NSString *)pathInZip;
// method: AppendNewDir
- (CkoZipEntry *)AppendNewDir: (NSString *)pathInZip;
// method: AppendOneFileOrDir
- (BOOL)AppendOneFileOrDir: (NSString *)path 
	saveExtraPath: (BOOL)saveExtraPath;
// method: AppendOneFileOrDirAsync
- (CkoTask *)AppendOneFileOrDirAsync: (NSString *)path 
	saveExtraPath: (BOOL)saveExtraPath;
// method: AppendSb
- (BOOL)AppendSb: (NSString *)pathInZip 
	sb: (CkoStringBuilder *)sb 
	charset: (NSString *)charset;
// method: AppendString
- (CkoZipEntry *)AppendString: (NSString *)pathInZip 
	str: (NSString *)str;
// method: AppendString2
- (CkoZipEntry *)AppendString2: (NSString *)pathInZip 
	str: (NSString *)str 
	charset: (NSString *)charset;
// method: AppendZip
- (BOOL)AppendZip: (NSString *)zipPath;
// method: CloseZip
- (void)CloseZip;
// method: DeleteEntry
- (BOOL)DeleteEntry: (CkoZipEntry *)entry;
// method: EntryAt
- (BOOL)EntryAt: (NSNumber *)index 
	entry: (CkoZipEntry *)entry;
// method: EntryById
- (BOOL)EntryById: (NSNumber *)id 
	entry: (CkoZipEntry *)entry;
// method: EntryMatching
- (BOOL)EntryMatching: (NSString *)pattern 
	entry: (CkoZipEntry *)entry;
// method: EntryOf
- (BOOL)EntryOf: (NSString *)pathInZip 
	entry: (CkoZipEntry *)entry;
// method: ExcludeDir
- (void)ExcludeDir: (NSString *)dirName;
// method: FirstEntry
- (CkoZipEntry *)FirstEntry;
// method: FirstMatchingEntry
- (CkoZipEntry *)FirstMatchingEntry: (NSString *)pattern;
// method: GetDirectoryAsXML
- (NSString *)GetDirectoryAsXML;
// method: GetEntryByID
- (CkoZipEntry *)GetEntryByID: (NSNumber *)entryID;
// method: GetEntryByIndex
- (CkoZipEntry *)GetEntryByIndex: (NSNumber *)index;
// method: GetEntryByName
- (CkoZipEntry *)GetEntryByName: (NSString *)entryName;
// method: GetExclusions
- (CkoStringArray *)GetExclusions;
// method: GetMaxUncompressedSize
- (NSString *)GetMaxUncompressedSize;
// method: IsNoCompressExtension
- (BOOL)IsNoCompressExtension: (NSString *)fileExtension;
// method: IsPasswordProtected
- (BOOL)IsPasswordProtected: (NSString *)zipPath;
// method: LoadTaskCaller
- (BOOL)LoadTaskCaller: (CkoTask *)task;
// method: NewZip
- (BOOL)NewZip: (NSString *)zipPath;
// method: OpenBd
- (BOOL)OpenBd: (CkoBinData *)binData;
// method: OpenFromByteData
- (BOOL)OpenFromByteData: (NSData *)byteData;
// method: OpenFromMemory
- (BOOL)OpenFromMemory: (NSData *)inData;
// method: OpenZip
- (BOOL)OpenZip: (NSString *)zipPath;
// method: OpenZipAsync
- (CkoTask *)OpenZipAsync: (NSString *)zipPath;
// method: QuickAppend
- (BOOL)QuickAppend: (NSString *)zipPath;
// method: QuickAppendAsync
- (CkoTask *)QuickAppendAsync: (NSString *)zipPath;
// method: RemoveNoCompressExtension
- (void)RemoveNoCompressExtension: (NSString *)fileExtension;
// method: SetCompressionLevel
- (void)SetCompressionLevel: (NSNumber *)level;
// method: SetExclusions
- (void)SetExclusions: (CkoStringArray *)excludePatterns;
// method: SetPassword
- (void)SetPassword: (NSString *)password;
// method: Unzip
- (NSNumber *)Unzip: (NSString *)dirPath;
// method: UnzipAsync
- (CkoTask *)UnzipAsync: (NSString *)dirPath;
// method: UnzipInto
- (NSNumber *)UnzipInto: (NSString *)dirPath;
// method: UnzipIntoAsync
- (CkoTask *)UnzipIntoAsync: (NSString *)dirPath;
// method: UnzipMatching
- (NSNumber *)UnzipMatching: (NSString *)dirPath 
	pattern: (NSString *)pattern 
	verbose: (BOOL)verbose;
// method: UnzipMatchingAsync
- (CkoTask *)UnzipMatchingAsync: (NSString *)dirPath 
	pattern: (NSString *)pattern 
	verbose: (BOOL)verbose;
// method: UnzipMatchingInto
- (NSNumber *)UnzipMatchingInto: (NSString *)dirPath 
	pattern: (NSString *)pattern 
	verbose: (BOOL)verbose;
// method: UnzipMatchingIntoAsync
- (CkoTask *)UnzipMatchingIntoAsync: (NSString *)dirPath 
	pattern: (NSString *)pattern 
	verbose: (BOOL)verbose;
// method: UnzipNewer
- (NSNumber *)UnzipNewer: (NSString *)dirPath;
// method: UnzipNewerAsync
- (CkoTask *)UnzipNewerAsync: (NSString *)dirPath;
// method: VerifyPassword
- (BOOL)VerifyPassword;
// method: WriteBd
- (BOOL)WriteBd: (CkoBinData *)binData;
// method: WriteBdAsync
- (CkoTask *)WriteBdAsync: (CkoBinData *)binData;
// method: WriteToMemory
- (NSData *)WriteToMemory;
// method: WriteToMemoryAsync
- (CkoTask *)WriteToMemoryAsync;
// method: WriteZip
- (BOOL)WriteZip;
// method: WriteZipAsync
- (CkoTask *)WriteZipAsync;
// method: WriteZipAndClose
- (BOOL)WriteZipAndClose;
// method: WriteZipAndCloseAsync
- (CkoTask *)WriteZipAndCloseAsync;

@end
